/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.trace.internal.domain.event;

import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.context.NetworkInfo;
import com.datadog.android.api.context.UserInfo;
import com.datadog.android.core.internal.utils.NumberExtKt;
import com.datadog.android.trace.internal.domain.event.ContextAwareMapper;
import com.datadog.android.trace.model.SpanEvent;
import com.datadog.opentracing.DDSpan;
import java.math.BigInteger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/trace/internal/domain/event/DdSpanToSpanEventMapper;", "Lcom/datadog/android/trace/internal/domain/event/ContextAwareMapper;", "Lcom/datadog/opentracing/DDSpan;", "Lcom/datadog/android/trace/model/SpanEvent;", "networkInfoEnabled", "", "(Z)V", "getNetworkInfoEnabled$dd_sdk_android_trace_release", "()Z", "map", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "model", "resolveMeta", "Lcom/datadog/android/trace/model/SpanEvent$Meta;", "event", "resolveMetrics", "Lcom/datadog/android/trace/model/SpanEvent$Metrics;", "resolveSimCarrier", "Lcom/datadog/android/trace/model/SpanEvent$SimCarrier;", "networkInfo", "Lcom/datadog/android/api/context/NetworkInfo;", "dd-sdk-android-trace_release"})
@SourceDebugExtension(value={"SMAP\nDdSpanToSpanEventMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DdSpanToSpanEventMapper.kt\ncom/datadog/android/trace/internal/domain/event/DdSpanToSpanEventMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public final class DdSpanToSpanEventMapper
implements ContextAwareMapper<DDSpan, SpanEvent> {
    private final boolean networkInfoEnabled;

    public DdSpanToSpanEventMapper(boolean networkInfoEnabled) {
        this.networkInfoEnabled = networkInfoEnabled;
    }

    public final boolean getNetworkInfoEnabled$dd_sdk_android_trace_release() {
        return this.networkInfoEnabled;
    }

    @Override
    @NotNull
    public SpanEvent map(@NotNull DatadogContext datadogContext, @NotNull DDSpan model) {
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        long serverOffset = datadogContext.getTime().getServerTimeOffsetNs();
        SpanEvent.Metrics metrics = this.resolveMetrics(model);
        SpanEvent.Meta metadata = this.resolveMeta(datadogContext, model);
        BigInteger bigInteger = model.getTraceId();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"model.traceId");
        String string = NumberExtKt.toHexString((BigInteger)bigInteger);
        BigInteger bigInteger2 = model.getSpanId();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"model.spanId");
        String string2 = NumberExtKt.toHexString((BigInteger)bigInteger2);
        BigInteger bigInteger3 = model.getParentId();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"model.parentId");
        String string3 = NumberExtKt.toHexString((BigInteger)bigInteger3);
        String string4 = model.getResourceName();
        String string5 = model.getOperationName();
        String string6 = model.getServiceName();
        long l = model.getDurationNano();
        long l2 = model.getStartTime() + serverOffset;
        Boolean bl = model.isError();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"model.isError");
        long l3 = bl != false ? 1L : 0L;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"resourceName");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"operationName");
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"serviceName");
        return new SpanEvent(string, string2, string3, string4, string5, string6, l, l2, l3, metrics, metadata);
    }

    private final SpanEvent.Metrics resolveMetrics(DDSpan event) {
        Long l = event.getParentId().longValue() == 0L ? Long.valueOf(1L) : null;
        Map<String, Number> map2 = event.getMetrics();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"event.metrics");
        return new SpanEvent.Metrics(l, map2);
    }

    private final SpanEvent.Meta resolveMeta(DatadogContext datadogContext, DDSpan event) {
        SpanEvent.View view;
        SpanEvent.Session session;
        SpanEvent.Session session2;
        SpanEvent.Application application;
        SpanEvent.Application application2;
        Object it;
        String string;
        SpanEvent.Network network;
        if (this.networkInfoEnabled) {
            NetworkInfo networkInfo = datadogContext.getNetworkInfo();
            SpanEvent.SimCarrier simCarrier = this.resolveSimCarrier(networkInfo);
            Long l = networkInfo.getStrength();
            Long l2 = networkInfo.getDownKbps();
            Long l3 = networkInfo.getUpKbps();
            SpanEvent.Client networkInfoClient = new SpanEvent.Client(simCarrier, l != null ? l.toString() : null, l2 != null ? l2.toString() : null, l3 != null ? l3.toString() : null, networkInfo.getConnectivity().toString());
            network = new SpanEvent.Network(networkInfoClient);
        } else {
            network = null;
        }
        SpanEvent.Network networkInfoMeta = network;
        UserInfo userInfo = datadogContext.getUserInfo();
        SpanEvent.Usr usrMeta = new SpanEvent.Usr(userInfo.getId(), userInfo.getName(), userInfo.getEmail(), MapsKt.toMutableMap((Map)userInfo.getAdditionalProperties()));
        String string2 = datadogContext.getSource();
        Object object = event.getTags().get("application_id");
        if (object != null) {
            Object object2 = object;
            string = string2;
            boolean bl = false;
            application2 = new SpanEvent.Application(it instanceof String ? (String)it : null);
            string2 = string;
        } else {
            application2 = null;
        }
        Object object3 = event.getTags().get("session_id");
        if (object3 != null) {
            it = object3;
            application = application2;
            string = string2;
            boolean bl = false;
            session2 = new SpanEvent.Session(it instanceof String ? (String)it : null);
            string2 = string;
            application2 = application;
            session = session2;
        } else {
            session = null;
        }
        Object object4 = event.getTags().get("view.id");
        if (object4 != null) {
            it = object4;
            session2 = session;
            application = application2;
            string = string2;
            boolean bl = false;
            SpanEvent.View view2 = new SpanEvent.View(it instanceof String ? (String)it : null);
            string2 = string;
            application2 = application;
            session = session2;
            view = view2;
        } else {
            view = null;
        }
        SpanEvent.View view3 = view;
        SpanEvent.Session session3 = session;
        SpanEvent.Application application3 = application2;
        String string3 = string2;
        SpanEvent.Dd dd = new SpanEvent.Dd(string3, application3, session3, view3);
        String string4 = datadogContext.getVersion();
        SpanEvent.Span span = new SpanEvent.Span();
        SpanEvent.Tracer tracer = new SpanEvent.Tracer(datadogContext.getSdkVersion());
        Map<String, String> map2 = event.getMeta();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"event.meta");
        return new SpanEvent.Meta(string4, dd, span, tracer, usrMeta, networkInfoMeta, map2);
    }

    private final SpanEvent.SimCarrier resolveSimCarrier(NetworkInfo networkInfo) {
        SpanEvent.SimCarrier simCarrier;
        if (networkInfo.getCarrierId() != null || networkInfo.getCarrierName() != null) {
            Long l = networkInfo.getCarrierId();
            simCarrier = new SpanEvent.SimCarrier(l != null ? l.toString() : null, networkInfo.getCarrierName());
        } else {
            simCarrier = null;
        }
        return simCarrier;
    }
}

