/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.recorder.mapper;

import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.view.View;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.IntExtKt;
import com.datadog.android.sessionreplay.recorder.mapper.BaseWireframeMapper;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\n*\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/sessionreplay/recorder/mapper/ViewWireframeMapper;", "Lcom/datadog/android/sessionreplay/recorder/mapper/BaseWireframeMapper;", "Landroid/view/View;", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe$ShapeWireframe;", "()V", "map", "view", "pixelsDensity", "", "resolveShapeStyleAndBorder", "Lkotlin/Pair;", "Lcom/datadog/android/sessionreplay/model/MobileSegment$ShapeStyle;", "Lcom/datadog/android/sessionreplay/model/MobileSegment$ShapeBorder;", "Landroid/graphics/drawable/Drawable;", "viewAlpha", "dd-sdk-android-session-replay_release"})
public final class ViewWireframeMapper
extends BaseWireframeMapper<View, MobileSegment.Wireframe.ShapeWireframe> {
    public ViewWireframeMapper() {
        super(null, 1, null);
    }

    @Override
    @NotNull
    public MobileSegment.Wireframe.ShapeWireframe map(@NotNull View view, float pixelsDensity) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        long scaledHeight = IntExtKt.densityNormalized(view.getHeight(), pixelsDensity);
        long scaledWidth = IntExtKt.densityNormalized(view.getWidth(), pixelsDensity);
        int[] coordinates = new int[2];
        view.getLocationOnScreen(coordinates);
        long x = IntExtKt.densityNormalized(coordinates[0], pixelsDensity);
        long y = IntExtKt.densityNormalized(coordinates[1], pixelsDensity);
        Drawable drawable = view.getBackground();
        Pair<MobileSegment.ShapeStyle, MobileSegment.ShapeBorder> styleBorderPair = drawable == null ? null : this.resolveShapeStyleAndBorder(drawable, view.getAlpha());
        Pair<MobileSegment.ShapeStyle, MobileSegment.ShapeBorder> pair = styleBorderPair;
        Pair<MobileSegment.ShapeStyle, MobileSegment.ShapeBorder> pair2 = styleBorderPair;
        return new MobileSegment.Wireframe.ShapeWireframe(this.resolveViewId(view), x, y, scaledWidth, scaledHeight, null, pair == null ? null : (MobileSegment.ShapeStyle)pair.getFirst(), pair2 == null ? null : (MobileSegment.ShapeBorder)pair2.getSecond(), 32, null);
    }

    private final Pair<MobileSegment.ShapeStyle, MobileSegment.ShapeBorder> resolveShapeStyleAndBorder(Drawable $this$resolveShapeStyleAndBorder, float viewAlpha) {
        Object object;
        if ($this$resolveShapeStyleAndBorder instanceof ColorDrawable) {
            String color = this.colorAndAlphaAsStringHexa(((ColorDrawable)$this$resolveShapeStyleAndBorder).getColor(), ((ColorDrawable)$this$resolveShapeStyleAndBorder).getAlpha());
            object = TuplesKt.to((Object)new MobileSegment.ShapeStyle(color, Float.valueOf(viewAlpha), null, 4, null), null);
        } else if (Build.VERSION.SDK_INT >= 21 && $this$resolveShapeStyleAndBorder instanceof RippleDrawable && ((RippleDrawable)$this$resolveShapeStyleAndBorder).getNumberOfLayers() >= 1) {
            Drawable drawable = ((RippleDrawable)$this$resolveShapeStyleAndBorder).getDrawable(0);
            Intrinsics.checkNotNullExpressionValue((Object)drawable, (String)"getDrawable(0)");
            object = this.resolveShapeStyleAndBorder(drawable, viewAlpha);
        } else if (Build.VERSION.SDK_INT >= 23 && $this$resolveShapeStyleAndBorder instanceof InsetDrawable) {
            Drawable drawable = ((InsetDrawable)$this$resolveShapeStyleAndBorder).getDrawable();
            object = drawable == null ? null : this.resolveShapeStyleAndBorder(drawable, viewAlpha);
        } else {
            object = TuplesKt.to(null, (Object)new MobileSegment.ShapeBorder("#000000ff", 1L));
        }
        return object;
    }
}

