/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.recorder.mapper;

import android.graphics.Typeface;
import android.view.View;
import android.widget.TextView;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.IntExtKt;
import com.datadog.android.sessionreplay.recorder.LongExtKt;
import com.datadog.android.sessionreplay.recorder.mapper.BaseWireframeMapper;
import com.datadog.android.sessionreplay.recorder.mapper.ViewWireframeMapper;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000 \u001a2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001aB\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0002H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/datadog/android/sessionreplay/recorder/mapper/TextWireframeMapper;", "Lcom/datadog/android/sessionreplay/recorder/mapper/BaseWireframeMapper;", "Landroid/widget/TextView;", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe$TextWireframe;", "viewWireframeMapper", "Lcom/datadog/android/sessionreplay/recorder/mapper/ViewWireframeMapper;", "(Lcom/datadog/android/sessionreplay/recorder/mapper/ViewWireframeMapper;)V", "map", "view", "pixelsDensity", "", "resolveAlignment", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Alignment;", "textView", "resolveAlignmentFromGravity", "resolveFontFamily", "", "typeface", "Landroid/graphics/Typeface;", "resolvePadding", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Padding;", "resolveTextPosition", "Lcom/datadog/android/sessionreplay/model/MobileSegment$TextPosition;", "resolveTextStyle", "Lcom/datadog/android/sessionreplay/model/MobileSegment$TextStyle;", "resolveTextValue", "Companion", "dd-sdk-android-session-replay_release"})
public class TextWireframeMapper
extends BaseWireframeMapper<TextView, MobileSegment.Wireframe.TextWireframe> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewWireframeMapper viewWireframeMapper;
    @NotNull
    public static final String SANS_SERIF_FAMILY_NAME = "sans-serif";
    @NotNull
    public static final String SERIF_FAMILY_NAME = "serif";
    @NotNull
    public static final String MONOSPACE_FAMILY_NAME = "monospace";

    public TextWireframeMapper(@NotNull ViewWireframeMapper viewWireframeMapper) {
        Intrinsics.checkNotNullParameter((Object)viewWireframeMapper, (String)"viewWireframeMapper");
        super(null, 1, null);
        this.viewWireframeMapper = viewWireframeMapper;
    }

    public /* synthetic */ TextWireframeMapper(ViewWireframeMapper viewWireframeMapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            viewWireframeMapper = new ViewWireframeMapper();
        }
        this(viewWireframeMapper);
    }

    @Override
    @NotNull
    public MobileSegment.Wireframe.TextWireframe map(@NotNull TextView view, float pixelsDensity) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        MobileSegment.Wireframe.ShapeWireframe shapeWireframe = this.viewWireframeMapper.map((View)view, pixelsDensity);
        return new MobileSegment.Wireframe.TextWireframe(shapeWireframe.getId(), shapeWireframe.getX(), shapeWireframe.getY(), shapeWireframe.getWidth(), shapeWireframe.getHeight(), null, shapeWireframe.getShapeStyle(), shapeWireframe.getBorder(), this.resolveTextValue(view), this.resolveTextStyle(view, pixelsDensity), this.resolveTextPosition(view, pixelsDensity), 32, null);
    }

    @NotNull
    protected String resolveTextValue(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        return ((Object)textView.getText()).toString();
    }

    private final MobileSegment.TextStyle resolveTextStyle(TextView textView, float pixelsDensity) {
        return new MobileSegment.TextStyle(this.resolveFontFamily(textView.getTypeface()), LongExtKt.densityNormalized((long)textView.getTextSize(), pixelsDensity), this.colorAndAlphaAsStringHexa(textView.getCurrentTextColor(), 255));
    }

    private final String resolveFontFamily(Typeface typeface) {
        return typeface == Typeface.SANS_SERIF ? SANS_SERIF_FAMILY_NAME : (typeface == Typeface.MONOSPACE ? MONOSPACE_FAMILY_NAME : (typeface == Typeface.SERIF ? SERIF_FAMILY_NAME : SANS_SERIF_FAMILY_NAME));
    }

    private final MobileSegment.TextPosition resolveTextPosition(TextView textView, float pixelsDensity) {
        return new MobileSegment.TextPosition(this.resolvePadding(textView, pixelsDensity), this.resolveAlignment(textView));
    }

    private final MobileSegment.Padding resolvePadding(TextView textView, float pixelsDensity) {
        return new MobileSegment.Padding(Long.valueOf(IntExtKt.densityNormalized(textView.getTotalPaddingTop(), pixelsDensity)), Long.valueOf(IntExtKt.densityNormalized(textView.getTotalPaddingBottom(), pixelsDensity)), Long.valueOf(IntExtKt.densityNormalized(textView.getTotalPaddingStart(), pixelsDensity)), Long.valueOf(IntExtKt.densityNormalized(textView.getTotalPaddingEnd(), pixelsDensity)));
    }

    private final MobileSegment.Alignment resolveAlignment(TextView textView) {
        MobileSegment.Alignment alignment;
        switch (textView.getTextAlignment()) {
            case 4: {
                alignment = new MobileSegment.Alignment(MobileSegment.Horizontal.CENTER, MobileSegment.Vertical.CENTER);
                break;
            }
            case 3: 
            case 6: {
                alignment = new MobileSegment.Alignment(MobileSegment.Horizontal.RIGHT, MobileSegment.Vertical.CENTER);
                break;
            }
            case 2: 
            case 5: {
                alignment = new MobileSegment.Alignment(MobileSegment.Horizontal.LEFT, MobileSegment.Vertical.CENTER);
                break;
            }
            case 1: {
                alignment = this.resolveAlignmentFromGravity(textView);
                break;
            }
            default: {
                alignment = new MobileSegment.Alignment(MobileSegment.Horizontal.LEFT, MobileSegment.Vertical.CENTER);
            }
        }
        return alignment;
    }

    private final MobileSegment.Alignment resolveAlignmentFromGravity(TextView textView) {
        MobileSegment.Vertical vertical;
        MobileSegment.Horizontal horizontal;
        switch (textView.getGravity() & 7) {
            case 3: 
            case 0x800003: {
                horizontal = MobileSegment.Horizontal.LEFT;
                break;
            }
            case 5: 
            case 0x800005: {
                horizontal = MobileSegment.Horizontal.RIGHT;
                break;
            }
            case 17: {
                horizontal = MobileSegment.Horizontal.CENTER;
                break;
            }
            case 1: {
                horizontal = MobileSegment.Horizontal.CENTER;
                break;
            }
            default: {
                horizontal = MobileSegment.Horizontal.LEFT;
            }
        }
        MobileSegment.Horizontal horizontalAlignment = horizontal;
        switch (textView.getGravity() & 0x70) {
            case 48: {
                vertical = MobileSegment.Vertical.TOP;
                break;
            }
            case 80: {
                vertical = MobileSegment.Vertical.BOTTOM;
                break;
            }
            case 16: {
                vertical = MobileSegment.Vertical.CENTER;
                break;
            }
            case 17: {
                vertical = MobileSegment.Vertical.CENTER;
                break;
            }
            default: {
                vertical = MobileSegment.Vertical.CENTER;
            }
        }
        MobileSegment.Vertical verticalAlignment = vertical;
        return new MobileSegment.Alignment(horizontalAlignment, verticalAlignment);
    }

    public TextWireframeMapper() {
        this((ViewWireframeMapper)null, 1, (DefaultConstructorMarker)null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/sessionreplay/recorder/mapper/TextWireframeMapper$Companion;", "", "()V", "MONOSPACE_FAMILY_NAME", "", "SANS_SERIF_FAMILY_NAME", "SERIF_FAMILY_NAME", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

