/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.recorder.callback;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.view.ActionMode;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SearchEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.processor.Processor;
import com.datadog.android.sessionreplay.recorder.LongExtKt;
import com.datadog.android.sessionreplay.recorder.callback.MotionEventUtils;
import com.datadog.android.sessionreplay.utils.TimeProvider;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 H2\u00020\u0001:\u0001HBY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0011J\u0019\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n  *\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001J\u0019\u0010!\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n  *\u0004\u0018\u00010\"0\"H\u0096\u0001J\u0019\u0010#\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n  *\u0004\u0018\u00010\"0\"H\u0096\u0001J\u0019\u0010$\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n  *\u0004\u0018\u00010%0%H\u0096\u0001J\u0012\u0010&\u001a\u00020\u001e2\b\u0010'\u001a\u0004\u0018\u00010\u000bH\u0016J\u0019\u0010(\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n  *\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001J\b\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020*2\u0006\u0010'\u001a\u00020\u000bH\u0002J\u0019\u0010,\u001a\u00020*2\u000e\u0010\u001f\u001a\n  *\u0004\u0018\u00010-0-H\u0096\u0001J\u0019\u0010.\u001a\u00020*2\u000e\u0010\u001f\u001a\n  *\u0004\u0018\u00010-0-H\u0096\u0001J\t\u0010/\u001a\u00020*H\u0096\u0001J\t\u00100\u001a\u00020*H\u0096\u0001J\u001b\u00101\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u0002022\b\b\u0001\u00103\u001a\u000204H\u0096\u0001J\u0013\u00105\u001a\u0004\u0018\u0001062\u0006\u0010\u001f\u001a\u000202H\u0097\u0001J\t\u00107\u001a\u00020*H\u0096\u0001J\u001b\u00108\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u0002022\b\b\u0001\u00103\u001a\u000209H\u0096\u0001J\u001b\u0010:\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u0002022\b\b\u0001\u00103\u001a\u000204H\u0096\u0001J\u001b\u0010;\u001a\u00020*2\u0006\u0010\u001f\u001a\u0002022\b\b\u0001\u00103\u001a\u000204H\u0096\u0001J'\u0010<\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u0002022\n\b\u0001\u00103\u001a\u0004\u0018\u0001062\b\b\u0001\u0010=\u001a\u000204H\u0096\u0001J\t\u0010>\u001a\u00020\u001eH\u0096\u0001J\u0019\u0010>\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n  *\u0004\u0018\u00010?0?H\u0096\u0001J\u0019\u0010@\u001a\u00020*2\u000e\u0010\u001f\u001a\n  *\u0004\u0018\u00010A0AH\u0096\u0001J\u0011\u0010B\u001a\u00020*2\u0006\u0010\u001f\u001a\u00020\u001eH\u0096\u0001J\u001b\u0010C\u001a\u0004\u0018\u00010-2\u000e\u0010\u001f\u001a\n  *\u0004\u0018\u00010D0DH\u0097\u0001J#\u0010C\u001a\u0004\u0018\u00010-2\u000e\u0010\u001f\u001a\n  *\u0004\u0018\u00010D0D2\u0006\u00103\u001a\u000202H\u0097\u0001J\u0018\u0010E\u001a\u00020*2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010F\u001a\u00020GH\u0002R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006I"}, d2={"Lcom/datadog/android/sessionreplay/recorder/callback/RecorderWindowCallback;", "Landroid/view/Window$Callback;", "processor", "Lcom/datadog/android/sessionreplay/processor/Processor;", "pixelsDensity", "", "wrappedCallback", "timeProvider", "Lcom/datadog/android/sessionreplay/utils/TimeProvider;", "copyEvent", "Lkotlin/Function1;", "Landroid/view/MotionEvent;", "motionEventUtils", "Lcom/datadog/android/sessionreplay/recorder/callback/MotionEventUtils;", "motionUpdateThresholdInNs", "", "flushPositionBufferThresholdInNs", "(Lcom/datadog/android/sessionreplay/processor/Processor;FLandroid/view/Window$Callback;Lcom/datadog/android/sessionreplay/utils/TimeProvider;Lkotlin/jvm/functions/Function1;Lcom/datadog/android/sessionreplay/recorder/callback/MotionEventUtils;JJ)V", "lastOnMoveUpdateTimeInNs", "lastPerformedFlushTimeInNs", "pointerInteractions", "", "Lcom/datadog/android/sessionreplay/model/MobileSegment$MobileRecord;", "getPointerInteractions$dd_sdk_android_session_replay_release", "()Ljava/util/List;", "setPointerInteractions$dd_sdk_android_session_replay_release", "(Ljava/util/List;)V", "getWrappedCallback$dd_sdk_android_session_replay_release", "()Landroid/view/Window$Callback;", "dispatchGenericMotionEvent", "", "p0", "kotlin.jvm.PlatformType", "dispatchKeyEvent", "Landroid/view/KeyEvent;", "dispatchKeyShortcutEvent", "dispatchPopulateAccessibilityEvent", "Landroid/view/accessibility/AccessibilityEvent;", "dispatchTouchEvent", "event", "dispatchTrackballEvent", "flushPositions", "", "handleEvent", "onActionModeFinished", "Landroid/view/ActionMode;", "onActionModeStarted", "onAttachedToWindow", "onContentChanged", "onCreatePanelMenu", "", "p1", "Landroid/view/Menu;", "onCreatePanelView", "Landroid/view/View;", "onDetachedFromWindow", "onMenuItemSelected", "Landroid/view/MenuItem;", "onMenuOpened", "onPanelClosed", "onPreparePanel", "p2", "onSearchRequested", "Landroid/view/SearchEvent;", "onWindowAttributesChanged", "Landroid/view/WindowManager$LayoutParams;", "onWindowFocusChanged", "onWindowStartingActionMode", "Landroid/view/ActionMode$Callback;", "updatePositions", "eventType", "Lcom/datadog/android/sessionreplay/model/MobileSegment$PointerEventType;", "Companion", "dd-sdk-android-session-replay_release"})
public final class RecorderWindowCallback
implements Window.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Processor processor;
    private final float pixelsDensity;
    @NotNull
    private final Window.Callback wrappedCallback;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final Function1<MotionEvent, MotionEvent> copyEvent;
    @NotNull
    private final MotionEventUtils motionEventUtils;
    private final long motionUpdateThresholdInNs;
    private final long flushPositionBufferThresholdInNs;
    @NotNull
    private List<MobileSegment.MobileRecord> pointerInteractions;
    private long lastOnMoveUpdateTimeInNs;
    private long lastPerformedFlushTimeInNs;
    private static final boolean EVENT_CONSUMED = true;
    private static final long MOTION_UPDATE_DELAY_THRESHOLD_NS = TimeUnit.MILLISECONDS.toNanos(16L);
    private static final long FLUSH_BUFFER_THRESHOLD_NS = MOTION_UPDATE_DELAY_THRESHOLD_NS * (long)10;

    public RecorderWindowCallback(@NotNull Processor processor, float pixelsDensity, @NotNull Window.Callback wrappedCallback, @NotNull TimeProvider timeProvider, @NotNull Function1<? super MotionEvent, MotionEvent> copyEvent, @NotNull MotionEventUtils motionEventUtils, long motionUpdateThresholdInNs, long flushPositionBufferThresholdInNs) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)wrappedCallback, (String)"wrappedCallback");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter(copyEvent, (String)"copyEvent");
        Intrinsics.checkNotNullParameter((Object)motionEventUtils, (String)"motionEventUtils");
        this.processor = processor;
        this.pixelsDensity = pixelsDensity;
        this.wrappedCallback = wrappedCallback;
        this.timeProvider = timeProvider;
        this.copyEvent = copyEvent;
        this.motionEventUtils = motionEventUtils;
        this.motionUpdateThresholdInNs = motionUpdateThresholdInNs;
        this.flushPositionBufferThresholdInNs = flushPositionBufferThresholdInNs;
        this.pointerInteractions = new LinkedList();
        this.lastPerformedFlushTimeInNs = System.nanoTime();
    }

    public /* synthetic */ RecorderWindowCallback(Processor processor, float f, Window.Callback callback, TimeProvider timeProvider, Function1 function1, MotionEventUtils motionEventUtils, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            motionEventUtils = MotionEventUtils.INSTANCE;
        }
        if ((n & 0x40) != 0) {
            l = MOTION_UPDATE_DELAY_THRESHOLD_NS;
        }
        if ((n & 0x80) != 0) {
            l2 = FLUSH_BUFFER_THRESHOLD_NS;
        }
        this(processor, f, callback, timeProvider, (Function1<? super MotionEvent, MotionEvent>)function1, motionEventUtils, l, l2);
    }

    @NotNull
    public final Window.Callback getWrappedCallback$dd_sdk_android_session_replay_release() {
        return this.wrappedCallback;
    }

    public boolean dispatchGenericMotionEvent(MotionEvent p0) {
        return this.wrappedCallback.dispatchGenericMotionEvent(p0);
    }

    public boolean dispatchKeyEvent(KeyEvent p0) {
        return this.wrappedCallback.dispatchKeyEvent(p0);
    }

    public boolean dispatchKeyShortcutEvent(KeyEvent p0) {
        return this.wrappedCallback.dispatchKeyShortcutEvent(p0);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent p0) {
        return this.wrappedCallback.dispatchPopulateAccessibilityEvent(p0);
    }

    public boolean dispatchTrackballEvent(MotionEvent p0) {
        return this.wrappedCallback.dispatchTrackballEvent(p0);
    }

    public void onActionModeFinished(ActionMode p0) {
        this.wrappedCallback.onActionModeFinished(p0);
    }

    public void onActionModeStarted(ActionMode p0) {
        this.wrappedCallback.onActionModeStarted(p0);
    }

    public void onAttachedToWindow() {
        this.wrappedCallback.onAttachedToWindow();
    }

    public void onContentChanged() {
        this.wrappedCallback.onContentChanged();
    }

    public boolean onCreatePanelMenu(int p0, @NonNull @NotNull Menu p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return this.wrappedCallback.onCreatePanelMenu(p0, p1);
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public View onCreatePanelView(int p0) {
        return this.wrappedCallback.onCreatePanelView(p0);
    }

    public void onDetachedFromWindow() {
        this.wrappedCallback.onDetachedFromWindow();
    }

    public boolean onMenuItemSelected(int p0, @NonNull @NotNull MenuItem p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return this.wrappedCallback.onMenuItemSelected(p0, p1);
    }

    public boolean onMenuOpened(int p0, @NonNull @NotNull Menu p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return this.wrappedCallback.onMenuOpened(p0, p1);
    }

    public void onPanelClosed(int p0, @NonNull @NotNull Menu p1) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        this.wrappedCallback.onPanelClosed(p0, p1);
    }

    public boolean onPreparePanel(int p0, @Nullable @org.jetbrains.annotations.Nullable View p1, @NonNull @NotNull Menu p2) {
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return this.wrappedCallback.onPreparePanel(p0, p1, p2);
    }

    public boolean onSearchRequested() {
        return this.wrappedCallback.onSearchRequested();
    }

    public boolean onSearchRequested(SearchEvent p0) {
        return this.wrappedCallback.onSearchRequested(p0);
    }

    public void onWindowAttributesChanged(WindowManager.LayoutParams p0) {
        this.wrappedCallback.onWindowAttributesChanged(p0);
    }

    public void onWindowFocusChanged(boolean p0) {
        this.wrappedCallback.onWindowFocusChanged(p0);
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public ActionMode onWindowStartingActionMode(ActionMode.Callback p0) {
        return this.wrappedCallback.onWindowStartingActionMode(p0);
    }

    @Nullable
    @org.jetbrains.annotations.Nullable
    public ActionMode onWindowStartingActionMode(ActionMode.Callback p0, int p1) {
        return this.wrappedCallback.onWindowStartingActionMode(p0, p1);
    }

    @NotNull
    public final List<MobileSegment.MobileRecord> getPointerInteractions$dd_sdk_android_session_replay_release() {
        return this.pointerInteractions;
    }

    public final void setPointerInteractions$dd_sdk_android_session_replay_release(@NotNull List<MobileSegment.MobileRecord> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.pointerInteractions = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchTouchEvent(@org.jetbrains.annotations.Nullable MotionEvent event) {
        boolean bl;
        if (event != null) {
            MotionEvent copy = (MotionEvent)this.copyEvent.invoke((Object)event);
            try {
                this.handleEvent(copy);
            }
            finally {
                copy.recycle();
            }
        }
        try {
            bl = this.wrappedCallback.dispatchTouchEvent(event);
        }
        catch (Throwable e) {
            bl = true;
        }
        return bl;
    }

    private final void handleEvent(MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.lastPerformedFlushTimeInNs = System.nanoTime();
                this.updatePositions(event, MobileSegment.PointerEventType.DOWN);
                this.lastOnMoveUpdateTimeInNs = 0L;
                break;
            }
            case 2: {
                if (System.nanoTime() - this.lastOnMoveUpdateTimeInNs >= this.motionUpdateThresholdInNs) {
                    this.updatePositions(event, MobileSegment.PointerEventType.MOVE);
                    this.lastOnMoveUpdateTimeInNs = System.nanoTime();
                }
                if (System.nanoTime() - this.lastPerformedFlushTimeInNs < this.flushPositionBufferThresholdInNs) break;
                this.flushPositions();
                break;
            }
            case 1: {
                this.updatePositions(event, MobileSegment.PointerEventType.UP);
                this.flushPositions();
                this.lastOnMoveUpdateTimeInNs = 0L;
            }
        }
    }

    private final void updatePositions(MotionEvent event, MobileSegment.PointerEventType eventType) {
        int n = 0;
        int n2 = event.getPointerCount();
        while (n < n2) {
            int pointerIndex = n++;
            long pointerId = event.getPointerId(pointerIndex);
            float pointerAbsoluteX = this.motionEventUtils.getPointerAbsoluteX(event, pointerIndex);
            float pointerAbsoluteY = this.motionEventUtils.getPointerAbsoluteY(event, pointerIndex);
            this.pointerInteractions.add(new MobileSegment.MobileRecord.MobileIncrementalSnapshotRecord(this.timeProvider.getDeviceTimestamp(), new MobileSegment.MobileIncrementalData.PointerInteractionData(eventType, MobileSegment.PointerType.TOUCH, pointerId, LongExtKt.densityNormalized((long)pointerAbsoluteX, this.pixelsDensity), LongExtKt.densityNormalized((long)pointerAbsoluteY, this.pixelsDensity))));
        }
    }

    private final void flushPositions() {
        if (this.pointerInteractions.isEmpty()) {
            return;
        }
        this.processor.processTouchEventsRecords(new ArrayList(this.pointerInteractions));
        this.pointerInteractions.clear();
        this.lastPerformedFlushTimeInNs = System.nanoTime();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/sessionreplay/recorder/callback/RecorderWindowCallback$Companion;", "", "()V", "EVENT_CONSUMED", "", "FLUSH_BUFFER_THRESHOLD_NS", "", "getFLUSH_BUFFER_THRESHOLD_NS$dd_sdk_android_session_replay_release", "()J", "MOTION_UPDATE_DELAY_THRESHOLD_NS", "getMOTION_UPDATE_DELAY_THRESHOLD_NS$dd_sdk_android_session_replay_release", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getMOTION_UPDATE_DELAY_THRESHOLD_NS$dd_sdk_android_session_replay_release() {
            return MOTION_UPDATE_DELAY_THRESHOLD_NS;
        }

        public final long getFLUSH_BUFFER_THRESHOLD_NS$dd_sdk_android_session_replay_release() {
            return FLUSH_BUFFER_THRESHOLD_NS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

