/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.net;

import com.datadog.android.sessionreplay.gson.GsonExtKt;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.net.BatchesToSegmentsMapper;
import com.datadog.android.sessionreplay.utils.SessionReplayRumContext;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ&\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u0006H\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0006H\u0002J\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lcom/datadog/android/sessionreplay/net/BatchesToSegmentsMapper;", "", "()V", "groupBatchDataIntoSegments", "Lkotlin/Pair;", "Lcom/datadog/android/sessionreplay/model/MobileSegment;", "Lcom/google/gson/JsonObject;", "batchData", "", "", "hasFullSnapshotRecord", "", "records", "Lcom/google/gson/JsonArray;", "map", "mapToSegment", "rumContext", "Lcom/datadog/android/sessionreplay/utils/SessionReplayRumContext;", "timestamp", "", "(Lcom/google/gson/JsonObject;)Ljava/lang/Long;", "Companion", "dd-sdk-android-session-replay_release"})
public final class BatchesToSegmentsMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long FULL_SNAPSHOT_RECORD_TYPE = 10L;
    @NotNull
    public static final String RECORDS_KEY = "records";
    @NotNull
    private static final String RECORD_TYPE_KEY = "type";
    @NotNull
    public static final String TIMESTAMP_KEY = "timestamp";

    @Nullable
    public final Pair<MobileSegment, JsonObject> map(@NotNull List<byte[]> batchData) {
        Intrinsics.checkNotNullParameter(batchData, (String)"batchData");
        return this.groupBatchDataIntoSegments(batchData);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<MobileSegment, JsonObject> groupBatchDataIntoSegments(List<byte[]> batchData) {
        Object v0;
        void $this$reduceOrNull$iv;
        Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)batchData), (Function1)groupBatchDataIntoSegments.reducedEnrichedRecord.1.INSTANCE), (Function1)((Function1)new Function1<JsonObject, Pair<? extends SessionReplayRumContext, ? extends JsonArray>>(this){
            final /* synthetic */ BatchesToSegmentsMapper this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Pair<SessionReplayRumContext, JsonArray> invoke(@NotNull JsonObject it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JsonArray records = BatchesToSegmentsMapper.access$records(this.this$0, it);
                SessionReplayRumContext rumContext = BatchesToSegmentsMapper.access$rumContext(this.this$0, it);
                return records == null || rumContext == null || records.isEmpty() ? (Pair)null : new Pair((Object)rumContext, (Object)records);
            }
        }));
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void pair;
                Pair pair2 = (Pair)iterator$iv.next();
                Pair accumulator = (Pair)accumulator$iv;
                boolean bl = false;
                JsonArray records = (JsonArray)accumulator.getSecond();
                JsonArray newRecords = (JsonArray)pair.getSecond();
                records.addAll(newRecords);
                accumulator$iv = new Pair(accumulator.getFirst(), (Object)records);
            }
            v0 = accumulator$iv;
        }
        Pair pair = v0;
        if (pair == null) {
            return null;
        }
        Pair reducedEnrichedRecord2 = pair;
        return this.mapToSegment((SessionReplayRumContext)reducedEnrichedRecord2.getFirst(), (JsonArray)reducedEnrichedRecord2.getSecond());
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<MobileSegment, JsonObject> mapToSegment(SessionReplayRumContext rumContext, JsonArray records) {
        Long stopTimestamp;
        Long l;
        Long l2;
        void $this$fold$iv;
        Sequence $this$sortedBy$iv;
        Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)records)), (Function1)mapToSegment.orderedRecords.1.INSTANCE), (Function1)((Function1)new Function1<JsonObject, Pair<? extends JsonObject, ? extends Long>>(this){
            final /* synthetic */ BatchesToSegmentsMapper this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Pair<JsonObject, Long> invoke(@NotNull JsonObject it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Long timestamp = BatchesToSegmentsMapper.access$timestamp(this.this$0, it);
                return timestamp == null ? (Pair)null : new Pair((Object)it, (Object)timestamp);
            }
        }));
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Long)it.getSecond();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Long)it.getSecond()));
            }
        }), (Function1)mapToSegment.orderedRecords.4.INSTANCE);
        JsonArray initial$iv = new JsonArray();
        boolean $i$f$fold = false;
        JsonArray accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void jsonObject;
            JsonObject jsonObject2 = (JsonObject)element$iv;
            JsonArray acc = accumulator$iv;
            boolean bl = false;
            acc.add((JsonElement)jsonObject);
            accumulator$iv = acc;
        }
        JsonArray orderedRecords2 = accumulator$iv;
        if (orderedRecords2.isEmpty()) {
            return null;
        }
        JsonElement jsonElement = (JsonElement)CollectionsKt.firstOrNull((Iterable)((Iterable)orderedRecords2));
        if (jsonElement == null) {
            l2 = null;
        } else {
            JsonObject jsonObject = GsonExtKt.safeGetAsJsonObject(jsonElement);
            l2 = jsonObject == null ? null : this.timestamp(jsonObject);
        }
        Long startTimestamp = l2;
        JsonElement jsonElement2 = (JsonElement)CollectionsKt.lastOrNull((Iterable)((Iterable)orderedRecords2));
        if (jsonElement2 == null) {
            l = null;
        } else {
            JsonObject jsonObject = GsonExtKt.safeGetAsJsonObject(jsonElement2);
            l = stopTimestamp = jsonObject == null ? null : this.timestamp(jsonObject);
        }
        if (startTimestamp == null || stopTimestamp == null) {
            return null;
        }
        boolean hasFullSnapshotRecord = this.hasFullSnapshotRecord(orderedRecords2);
        MobileSegment segment = new MobileSegment(new MobileSegment.Application(rumContext.getApplicationId()), new MobileSegment.Session(rumContext.getSessionId()), new MobileSegment.View(rumContext.getViewId()), startTimestamp, stopTimestamp, orderedRecords2.size(), null, hasFullSnapshotRecord, MobileSegment.Source.ANDROID, CollectionsKt.emptyList());
        JsonObject jsonObject = GsonExtKt.safeGetAsJsonObject(segment.toJson());
        if (jsonObject == null) {
            return null;
        }
        JsonObject segmentAsJsonObject = jsonObject;
        segmentAsJsonObject.add(RECORDS_KEY, (JsonElement)orderedRecords2);
        return new Pair((Object)segment, (Object)segmentAsJsonObject);
    }

    private final boolean hasFullSnapshotRecord(JsonArray records) {
        Object v3;
        block3: {
            Iterable $this$firstOrNull$iv = (Iterable)records;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                JsonElement it = (JsonElement)element$iv;
                boolean bl2 = false;
                JsonPrimitive jsonPrimitive = it.getAsJsonObject().getAsJsonPrimitive(RECORD_TYPE_KEY);
                if (jsonPrimitive == null) {
                    bl = false;
                } else {
                    Long l = GsonExtKt.safeGetAsLong(jsonPrimitive);
                    long l2 = 10L;
                    bl = l != null && l == l2;
                }
                if (!bl) continue;
                v3 = element$iv;
                break block3;
            }
            v3 = null;
        }
        return v3 != null;
    }

    private final JsonArray records(JsonObject $this$records) {
        JsonElement jsonElement = $this$records.get(RECORDS_KEY);
        return jsonElement == null ? null : GsonExtKt.safeGetAsJsonArray(jsonElement);
    }

    private final Long timestamp(JsonObject $this$timestamp) {
        JsonPrimitive jsonPrimitive = $this$timestamp.getAsJsonPrimitive(TIMESTAMP_KEY);
        return jsonPrimitive == null ? null : GsonExtKt.safeGetAsLong(jsonPrimitive);
    }

    private final SessionReplayRumContext rumContext(JsonObject $this$rumContext) {
        String viewId;
        JsonElement jsonElement = $this$rumContext.get("application_id");
        String applicationId = jsonElement == null ? null : jsonElement.getAsString();
        JsonElement jsonElement2 = $this$rumContext.get("session_id");
        String sessionId = jsonElement2 == null ? null : jsonElement2.getAsString();
        JsonElement jsonElement3 = $this$rumContext.get("view_id");
        String string = viewId = jsonElement3 == null ? null : jsonElement3.getAsString();
        if (applicationId == null || sessionId == null || viewId == null) {
            return null;
        }
        return new SessionReplayRumContext(applicationId, sessionId, viewId);
    }

    public static final /* synthetic */ JsonArray access$records(BatchesToSegmentsMapper $this, JsonObject $receiver) {
        return $this.records($receiver);
    }

    public static final /* synthetic */ SessionReplayRumContext access$rumContext(BatchesToSegmentsMapper $this, JsonObject $receiver) {
        return $this.rumContext($receiver);
    }

    public static final /* synthetic */ Long access$timestamp(BatchesToSegmentsMapper $this, JsonObject $receiver) {
        return $this.timestamp($receiver);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/datadog/android/sessionreplay/net/BatchesToSegmentsMapper$Companion;", "", "()V", "FULL_SNAPSHOT_RECORD_TYPE", "", "RECORDS_KEY", "", "RECORD_TYPE_KEY", "TIMESTAMP_KEY", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

