/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.view.Window;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.datadog.android.sessionreplay.LifecycleCallback;
import com.datadog.android.sessionreplay.NoOpRecordCallback;
import com.datadog.android.sessionreplay.RecordCallback;
import com.datadog.android.sessionreplay.RecordWriter;
import com.datadog.android.sessionreplay.SessionReplayPrivacy;
import com.datadog.android.sessionreplay.processor.RecordedDataProcessor;
import com.datadog.android.sessionreplay.recorder.Recorder;
import com.datadog.android.sessionreplay.recorder.ScreenRecorder;
import com.datadog.android.sessionreplay.recorder.SnapshotProducer;
import com.datadog.android.sessionreplay.recorder.callback.RecorderFragmentLifecycleCallback;
import com.datadog.android.sessionreplay.utils.RumContextProvider;
import com.datadog.android.sessionreplay.utils.TimeProvider;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u001cH\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0016R\u0014\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006)"}, d2={"Lcom/datadog/android/sessionreplay/SessionReplayLifecycleCallback;", "Lcom/datadog/android/sessionreplay/LifecycleCallback;", "rumContextProvider", "Lcom/datadog/android/sessionreplay/utils/RumContextProvider;", "privacy", "Lcom/datadog/android/sessionreplay/SessionReplayPrivacy;", "recordWriter", "Lcom/datadog/android/sessionreplay/RecordWriter;", "timeProvider", "Lcom/datadog/android/sessionreplay/utils/TimeProvider;", "recordCallback", "Lcom/datadog/android/sessionreplay/RecordCallback;", "(Lcom/datadog/android/sessionreplay/utils/RumContextProvider;Lcom/datadog/android/sessionreplay/SessionReplayPrivacy;Lcom/datadog/android/sessionreplay/RecordWriter;Lcom/datadog/android/sessionreplay/utils/TimeProvider;Lcom/datadog/android/sessionreplay/RecordCallback;)V", "processorExecutorService", "Ljava/util/concurrent/ThreadPoolExecutor;", "getProcessorExecutorService$annotations", "()V", "recorder", "Lcom/datadog/android/sessionreplay/recorder/Recorder;", "getRecorder$dd_sdk_android_session_replay_release", "()Lcom/datadog/android/sessionreplay/recorder/Recorder;", "setRecorder$dd_sdk_android_session_replay_release", "(Lcom/datadog/android/sessionreplay/recorder/Recorder;)V", "onActivityCreated", "", "activity", "Landroid/app/Activity;", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "register", "appContext", "Landroid/app/Application;", "unregisterAndStopRecorders", "Companion", "dd-sdk-android-session-replay_release"})
public final class SessionReplayLifecycleCallback
implements LifecycleCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ThreadPoolExecutor processorExecutorService;
    @NotNull
    private Recorder recorder;
    private static final long THREAD_POOL_MAX_KEEP_ALIVE_MS = TimeUnit.SECONDS.toMillis(5L);
    private static final int CORE_DEFAULT_POOL_SIZE = 1;

    public SessionReplayLifecycleCallback(@NotNull RumContextProvider rumContextProvider, @NotNull SessionReplayPrivacy privacy, @NotNull RecordWriter recordWriter, @NotNull TimeProvider timeProvider, @NotNull RecordCallback recordCallback) {
        Intrinsics.checkNotNullParameter((Object)rumContextProvider, (String)"rumContextProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)privacy), (String)"privacy");
        Intrinsics.checkNotNullParameter((Object)recordWriter, (String)"recordWriter");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)recordCallback, (String)"recordCallback");
        this.processorExecutorService = new ThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors(), THREAD_POOL_MAX_KEEP_ALIVE_MS, TimeUnit.MILLISECONDS, new LinkedBlockingDeque());
        this.recorder = new ScreenRecorder(new RecordedDataProcessor(rumContextProvider, timeProvider, this.processorExecutorService, recordWriter, null, null, 48, null), new SnapshotProducer(privacy.mapper$dd_sdk_android_session_replay_release(), null, null, null, 14, null), timeProvider, recordCallback);
    }

    public /* synthetic */ SessionReplayLifecycleCallback(RumContextProvider rumContextProvider, SessionReplayPrivacy sessionReplayPrivacy, RecordWriter recordWriter, TimeProvider timeProvider, RecordCallback recordCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            recordCallback = new NoOpRecordCallback();
        }
        this(rumContextProvider, sessionReplayPrivacy, recordWriter, timeProvider, recordCallback);
    }

    private static /* synthetic */ void getProcessorExecutorService$annotations() {
    }

    @NotNull
    public final Recorder getRecorder$dd_sdk_android_session_replay_release() {
        return this.recorder;
    }

    public final void setRecorder$dd_sdk_android_session_replay_release(@NotNull Recorder recorder) {
        Intrinsics.checkNotNullParameter((Object)recorder, (String)"<set-?>");
        this.recorder = recorder;
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (activity instanceof FragmentActivity) {
            ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)new RecorderFragmentLifecycleCallback(this.recorder), true);
        }
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        if (window != null) {
            Window it = window;
            boolean bl = false;
            this.getRecorder$dd_sdk_android_session_replay_release().startRecording(CollectionsKt.listOf((Object)it), activity);
        }
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        if (window != null) {
            Window it = window;
            boolean bl = false;
            this.getRecorder$dd_sdk_android_session_replay_release().stopRecording(CollectionsKt.listOf((Object)it));
        }
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @Override
    public void register(@NotNull Application appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        appContext.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    @Override
    public void unregisterAndStopRecorders(@NotNull Application appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        appContext.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.recorder.stopRecording();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/sessionreplay/SessionReplayLifecycleCallback$Companion;", "", "()V", "CORE_DEFAULT_POOL_SIZE", "", "THREAD_POOL_MAX_KEEP_ALIVE_MS", "", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

