/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.telemetry.internal;

import androidx.annotation.AnyThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.api.storage.EventBatchWriter;
import com.datadog.android.api.storage.EventType;
import com.datadog.android.core.InternalSdkCore;
import com.datadog.android.core.sampling.RateBasedSampler;
import com.datadog.android.core.sampling.Sampler;
import com.datadog.android.rum.RumSessionListener;
import com.datadog.android.rum.configuration.VitalsUpdateFrequency;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.tracking.ActivityViewTrackingStrategy;
import com.datadog.android.rum.tracking.FragmentViewTrackingStrategy;
import com.datadog.android.rum.tracking.MixedViewTrackingStrategy;
import com.datadog.android.rum.tracking.NavigationViewTrackingStrategy;
import com.datadog.android.telemetry.internal.TelemetryCoreConfiguration;
import com.datadog.android.telemetry.internal.TelemetryEventExtKt;
import com.datadog.android.telemetry.internal.TelemetryEventHandler;
import com.datadog.android.telemetry.internal.TelemetryEventId;
import com.datadog.android.telemetry.internal.TelemetryEventIdKt;
import com.datadog.android.telemetry.internal.TelemetryType;
import com.datadog.android.telemetry.model.TelemetryConfigurationEvent;
import com.datadog.android.telemetry.model.TelemetryDebugEvent;
import com.datadog.android.telemetry.model.TelemetryErrorEvent;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 ;2\u00020\u0001:\u0002;<B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J8\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0016\u0010$\u001a\u0012\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010&\u0018\u00010%H\u0002JL\u0010'\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\b\u0010)\u001a\u0004\u0018\u00010#2\b\u0010*\u001a\u0004\u0018\u00010#2\u0016\u0010$\u001a\u0012\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010&\u0018\u00010%H\u0002J\u001e\u0010+\u001a\u00020,2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010-\u001a\b\u0012\u0004\u0012\u00020&0.H\u0007J\b\u0010/\u001a\u00020\u0014H\u0002J\u001e\u00100\u001a\u00020\u00142\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010&0%H\u0002J\u0018\u00102\u001a\u00020,2\u0006\u00103\u001a\u00020#2\u0006\u00104\u001a\u00020\u0014H\u0016J*\u00105\u001a\u0004\u0018\u00010#2\b\u00106\u001a\u0004\u0018\u0001072\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010&0%H\u0002J \u00108\u001a\u0004\u0018\u0001072\u0014\u00101\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010&0%H\u0002J\f\u00109\u001a\u00020:*\u00020\u001bH\u0002R\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/datadog/android/telemetry/internal/TelemetryEventHandler;", "Lcom/datadog/android/rum/RumSessionListener;", "sdkCore", "Lcom/datadog/android/core/InternalSdkCore;", "eventSampler", "Lcom/datadog/android/core/sampling/Sampler;", "configurationExtraSampler", "maxEventCountPerSession", "", "(Lcom/datadog/android/core/InternalSdkCore;Lcom/datadog/android/core/sampling/Sampler;Lcom/datadog/android/core/sampling/Sampler;I)V", "getConfigurationExtraSampler$dd_sdk_android_rum_release", "()Lcom/datadog/android/core/sampling/Sampler;", "eventIDsSeenInCurrentSession", "", "Lcom/datadog/android/telemetry/internal/TelemetryEventId;", "getEventSampler$dd_sdk_android_rum_release", "getSdkCore$dd_sdk_android_rum_release", "()Lcom/datadog/android/core/InternalSdkCore;", "totalEventsSeenInCurrentSession", "trackNetworkRequests", "", "canWrite", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$SendTelemetry;", "createConfigurationEvent", "Lcom/datadog/android/telemetry/model/TelemetryConfigurationEvent;", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "timestamp", "", "coreConfiguration", "Lcom/datadog/android/telemetry/internal/TelemetryCoreConfiguration;", "createDebugEvent", "Lcom/datadog/android/telemetry/model/TelemetryDebugEvent;", "message", "", "additionalProperties", "", "", "createErrorEvent", "Lcom/datadog/android/telemetry/model/TelemetryErrorEvent;", "stack", "kind", "handleEvent", "", "writer", "Lcom/datadog/android/api/storage/DataWriter;", "isGlobalTracerRegistered", "isOpenTelemetryRegistered", "traceContext", "onSessionStarted", "sessionId", "isDiscarded", "resolveOpenTelemetryApiVersion", "tracerApi", "Lcom/datadog/android/telemetry/internal/TelemetryEventHandler$TracerApi;", "resolveTracerApi", "rumContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "Companion", "TracerApi", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nTelemetryEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelemetryEventHandler.kt\ncom/datadog/android/telemetry/internal/TelemetryEventHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,395:1\n1#2:396\n*E\n"})
public final class TelemetryEventHandler
implements RumSessionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalSdkCore sdkCore;
    @NotNull
    private final Sampler eventSampler;
    @NotNull
    private final Sampler configurationExtraSampler;
    private final int maxEventCountPerSession;
    private boolean trackNetworkRequests;
    @NotNull
    private final Set<TelemetryEventId> eventIDsSeenInCurrentSession;
    private int totalEventsSeenInCurrentSession;
    public static final int MAX_EVENTS_PER_SESSION = 100;
    public static final float DEFAULT_CONFIGURATION_SAMPLE_RATE = 20.0f;
    @NotNull
    public static final String ALREADY_SEEN_EVENT_MESSAGE = "Already seen telemetry event with identity=%s, rejecting.";
    @NotNull
    public static final String MAX_EVENT_NUMBER_REACHED_MESSAGE = "Max number of telemetry events per session reached, rejecting.";
    @NotNull
    public static final String TELEMETRY_SERVICE_NAME = "dd-sdk-android";
    @NotNull
    public static final String IS_OPENTELEMETRY_ENABLED_CONTEXT_KEY = "is_opentelemetry_enabled";
    @NotNull
    public static final String OPENTELEMETRY_API_VERSION_CONTEXT_KEY = "opentelemetry_api_version";
    @NotNull
    public static final String SESSION_REPLAY_SAMPLE_RATE_KEY = "session_replay_sample_rate";
    @NotNull
    public static final String SESSION_REPLAY_PRIVACY_KEY = "session_replay_privacy";
    @NotNull
    public static final String SESSION_REPLAY_MANUAL_RECORDING_KEY = "session_replay_requires_manual_recording";

    public TelemetryEventHandler(@NotNull InternalSdkCore sdkCore, @NotNull Sampler eventSampler, @NotNull Sampler configurationExtraSampler, int maxEventCountPerSession) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)eventSampler, (String)"eventSampler");
        Intrinsics.checkNotNullParameter((Object)configurationExtraSampler, (String)"configurationExtraSampler");
        this.sdkCore = sdkCore;
        this.eventSampler = eventSampler;
        this.configurationExtraSampler = configurationExtraSampler;
        this.maxEventCountPerSession = maxEventCountPerSession;
        this.eventIDsSeenInCurrentSession = new LinkedHashSet();
    }

    public /* synthetic */ TelemetryEventHandler(InternalSdkCore internalSdkCore, Sampler sampler, Sampler sampler2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            sampler2 = (Sampler)new RateBasedSampler(20.0f);
        }
        if ((n2 & 8) != 0) {
            n = 100;
        }
        this(internalSdkCore, sampler, sampler2, n);
    }

    @NotNull
    public final InternalSdkCore getSdkCore$dd_sdk_android_rum_release() {
        return this.sdkCore;
    }

    @NotNull
    public final Sampler getEventSampler$dd_sdk_android_rum_release() {
        return this.eventSampler;
    }

    @NotNull
    public final Sampler getConfigurationExtraSampler$dd_sdk_android_rum_release() {
        return this.configurationExtraSampler;
    }

    @AnyThread
    public final void handleEvent(@NotNull RumRawEvent.SendTelemetry event, @NotNull DataWriter<Object> writer) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(writer, (String)"writer");
            if (!this.canWrite(event)) {
                return;
            }
            this.eventIDsSeenInCurrentSession.add(TelemetryEventIdKt.getIdentity(event));
            int n = this.totalEventsSeenInCurrentSession;
            this.totalEventsSeenInCurrentSession = n + 1;
            FeatureScope featureScope = this.sdkCore.getFeature("rum");
            if (featureScope == null) break block1;
            FeatureScope.DefaultImpls.withWriteContext$default((FeatureScope)featureScope, (boolean)false, (Function2)((Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(event, this, writer){
                final /* synthetic */ RumRawEvent.SendTelemetry $event;
                final /* synthetic */ TelemetryEventHandler this$0;
                final /* synthetic */ DataWriter<Object> $writer;
                {
                    this.$event = $event;
                    this.this$0 = $receiver;
                    this.$writer = $writer;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    Object object;
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    long timestamp = this.$event.getEventTime().getTimestamp() + datadogContext.getTime().getServerTimeOffsetMs();
                    switch (handleEvent.WhenMappings.$EnumSwitchMapping$0[this.$event.getType().ordinal()]) {
                        case 1: {
                            object = TelemetryEventHandler.access$createDebugEvent(this.this$0, datadogContext, timestamp, this.$event.getMessage(), this.$event.getAdditionalProperties());
                            break;
                        }
                        case 2: {
                            object = TelemetryEventHandler.access$createErrorEvent(this.this$0, datadogContext, timestamp, this.$event.getMessage(), this.$event.getStack(), this.$event.getKind(), this.$event.getAdditionalProperties());
                            break;
                        }
                        case 3: {
                            TelemetryCoreConfiguration coreConfiguration = this.$event.getCoreConfiguration();
                            if (coreConfiguration == null) {
                                object = TelemetryEventHandler.access$createErrorEvent(this.this$0, datadogContext, timestamp, "Trying to send configuration event with null config", null, null, null);
                                break;
                            }
                            object = TelemetryEventHandler.access$createConfigurationEvent(this.this$0, datadogContext, timestamp, coreConfiguration);
                            break;
                        }
                        case 4: {
                            TelemetryEventHandler.access$setTrackNetworkRequests$p(this.this$0, true);
                            object = null;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    TelemetryDebugEvent telemetryEvent = object;
                    if (telemetryEvent != null) {
                        this.$writer.write(eventBatchWriter, (Object)telemetryEvent, EventType.TELEMETRY);
                    }
                }
            }), (int)1, null);
        }
    }

    @Override
    public void onSessionStarted(@NotNull String sessionId, boolean isDiscarded) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        this.eventIDsSeenInCurrentSession.clear();
        this.totalEventsSeenInCurrentSession = 0;
    }

    private final boolean canWrite(RumRawEvent.SendTelemetry event) {
        if (!this.eventSampler.sample()) {
            return false;
        }
        if (event.getType() == TelemetryType.CONFIGURATION && !this.configurationExtraSampler.sample()) {
            return false;
        }
        TelemetryEventId eventIdentity = TelemetryEventIdKt.getIdentity(event);
        if (!event.isMetric() && this.eventIDsSeenInCurrentSession.contains(eventIdentity)) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)((Function0)new Function0<String>(eventIdentity){
                final /* synthetic */ TelemetryEventId $eventIdentity;
                {
                    this.$eventIdentity = $eventIdentity;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Already seen telemetry event with identity=%s, rejecting.";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$eventIdentity};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }), null, (boolean)false, null, (int)56, null);
            return false;
        }
        if (this.totalEventsSeenInCurrentSession >= this.maxEventCountPerSession) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)canWrite.2.INSTANCE, null, (boolean)false, null, (int)56, null);
            return false;
        }
        return true;
    }

    private final TelemetryDebugEvent createDebugEvent(DatadogContext datadogContext, long timestamp, String message, Map<String, ? extends Object> additionalProperties) {
        TelemetryDebugEvent.Action action;
        TelemetryDebugEvent.View view;
        RumContext rumContext = this.rumContext(datadogContext);
        Map map = additionalProperties;
        if (map == null || (map = MapsKt.toMutableMap(map)) == null) {
            map = new LinkedHashMap();
        }
        Map resolvedAdditionalProperties = map;
        TelemetryDebugEvent.Dd dd = new TelemetryDebugEvent.Dd();
        TelemetryDebugEvent.Source source = TelemetryEventExtKt.tryFromSource(TelemetryDebugEvent.Source.Companion, datadogContext.getSource(), this.sdkCore.getInternalLogger());
        if (source == null) {
            source = TelemetryDebugEvent.Source.ANDROID;
        }
        TelemetryDebugEvent.Source source2 = source;
        String string = datadogContext.getSdkVersion();
        TelemetryDebugEvent.Application application = new TelemetryDebugEvent.Application(rumContext.getApplicationId());
        TelemetryDebugEvent.Session session = new TelemetryDebugEvent.Session(rumContext.getSessionId());
        String string2 = rumContext.getViewId();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            view = new TelemetryDebugEvent.View(it);
        } else {
            view = null;
        }
        TelemetryDebugEvent.View view2 = view;
        String string3 = rumContext.getActionId();
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            action = new TelemetryDebugEvent.Action(it);
        } else {
            action = null;
        }
        TelemetryDebugEvent.Action action2 = action;
        TelemetryDebugEvent.Device device = new TelemetryDebugEvent.Device(datadogContext.getDeviceInfo().getArchitecture(), datadogContext.getDeviceInfo().getDeviceBrand(), datadogContext.getDeviceInfo().getDeviceModel());
        String string4 = datadogContext.getDeviceInfo().getDeviceBuildId();
        String string5 = datadogContext.getDeviceInfo().getOsVersion();
        String string6 = datadogContext.getDeviceInfo().getOsName();
        TelemetryDebugEvent.Os os = new TelemetryDebugEvent.Os(string4, string6, string5);
        TelemetryDebugEvent.Telemetry telemetry = new TelemetryDebugEvent.Telemetry(device, os, message, resolvedAdditionalProperties);
        return new TelemetryDebugEvent(dd, timestamp, TELEMETRY_SERVICE_NAME, source2, string, application, session, view2, action2, null, telemetry, 512, null);
    }

    private final TelemetryErrorEvent createErrorEvent(DatadogContext datadogContext, long timestamp, String message, String stack, String kind, Map<String, ? extends Object> additionalProperties) {
        TelemetryErrorEvent.Action action;
        TelemetryErrorEvent.View view;
        RumContext rumContext = this.rumContext(datadogContext);
        Map map = additionalProperties;
        if (map == null || (map = MapsKt.toMutableMap(map)) == null) {
            map = new LinkedHashMap();
        }
        Map resolvedAdditionalProperties = map;
        TelemetryErrorEvent.Dd dd = new TelemetryErrorEvent.Dd();
        TelemetryErrorEvent.Source source = TelemetryEventExtKt.tryFromSource(TelemetryErrorEvent.Source.Companion, datadogContext.getSource(), this.sdkCore.getInternalLogger());
        if (source == null) {
            source = TelemetryErrorEvent.Source.ANDROID;
        }
        TelemetryErrorEvent.Source source2 = source;
        String string = datadogContext.getSdkVersion();
        TelemetryErrorEvent.Application application = new TelemetryErrorEvent.Application(rumContext.getApplicationId());
        TelemetryErrorEvent.Session session = new TelemetryErrorEvent.Session(rumContext.getSessionId());
        String string2 = rumContext.getViewId();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            view = new TelemetryErrorEvent.View(it);
        } else {
            view = null;
        }
        TelemetryErrorEvent.View view2 = view;
        String string3 = rumContext.getActionId();
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            action = new TelemetryErrorEvent.Action(it);
        } else {
            action = null;
        }
        TelemetryErrorEvent.Action action2 = action;
        TelemetryErrorEvent.Error error = stack != null || kind != null ? new TelemetryErrorEvent.Error(stack, kind) : null;
        TelemetryErrorEvent.Device device = new TelemetryErrorEvent.Device(datadogContext.getDeviceInfo().getArchitecture(), datadogContext.getDeviceInfo().getDeviceBrand(), datadogContext.getDeviceInfo().getDeviceModel());
        String string4 = datadogContext.getDeviceInfo().getDeviceBuildId();
        String string5 = datadogContext.getDeviceInfo().getOsVersion();
        String string6 = datadogContext.getDeviceInfo().getOsName();
        TelemetryErrorEvent.Os os = new TelemetryErrorEvent.Os(string4, string6, string5);
        TelemetryErrorEvent.Telemetry telemetry = new TelemetryErrorEvent.Telemetry(device, os, message, error, resolvedAdditionalProperties);
        return new TelemetryErrorEvent(dd, timestamp, TELEMETRY_SERVICE_NAME, source2, string, application, session, view2, action2, null, telemetry, 512, null);
    }

    private final TelemetryConfigurationEvent createConfigurationEvent(DatadogContext datadogContext, long timestamp, TelemetryCoreConfiguration coreConfiguration) {
        TelemetryConfigurationEvent.Action action;
        TelemetryConfigurationEvent.View view;
        TelemetryConfigurationEvent.View view2;
        String it;
        TelemetryConfigurationEvent.Dd dd;
        long l;
        String string;
        TelemetryConfigurationEvent.Source source;
        String string2;
        TelemetryConfigurationEvent.Application application;
        TelemetryConfigurationEvent.Session session;
        String string3;
        Object object;
        RumFeature.Configuration rumConfig;
        FeatureScope traceFeature = this.sdkCore.getFeature("tracing");
        Map sessionReplayFeatureContext = this.sdkCore.getFeatureContext("session-replay");
        Object v = sessionReplayFeatureContext.get(SESSION_REPLAY_SAMPLE_RATE_KEY);
        Long sessionReplaySampleRate = v instanceof Long ? (Long)v : null;
        Object v2 = sessionReplayFeatureContext.get(SESSION_REPLAY_MANUAL_RECORDING_KEY);
        Boolean startSessionReplayManually = v2 instanceof Boolean ? (Boolean)v2 : null;
        Object v3 = sessionReplayFeatureContext.get(SESSION_REPLAY_PRIVACY_KEY);
        String sessionReplayPrivacy = v3 instanceof String ? (String)v3 : null;
        FeatureScope featureScope = this.sdkCore.getFeature("rum");
        RumFeature.Configuration configuration = rumConfig = featureScope != null && (object = (RumFeature)featureScope.unwrap()) != null ? ((RumFeature)object).getConfiguration$dd_sdk_android_rum_release() : null;
        Object object2 = object = configuration != null ? configuration.getViewTrackingStrategy() : null;
        TelemetryConfigurationEvent.ViewTrackingStrategy viewTrackingStrategy = object instanceof ActivityViewTrackingStrategy ? TelemetryConfigurationEvent.ViewTrackingStrategy.ACTIVITYVIEWTRACKINGSTRATEGY : (object instanceof FragmentViewTrackingStrategy ? TelemetryConfigurationEvent.ViewTrackingStrategy.FRAGMENTVIEWTRACKINGSTRATEGY : (object instanceof MixedViewTrackingStrategy ? TelemetryConfigurationEvent.ViewTrackingStrategy.MIXEDVIEWTRACKINGSTRATEGY : (object instanceof NavigationViewTrackingStrategy ? TelemetryConfigurationEvent.ViewTrackingStrategy.NAVIGATIONVIEWTRACKINGSTRATEGY : null)));
        RumContext rumContext = this.rumContext(datadogContext);
        Map traceContext = this.sdkCore.getFeatureContext("tracing");
        TracerApi tracerApi = this.resolveTracerApi(traceContext);
        String openTelemetryApiVersion = this.resolveOpenTelemetryApiVersion(tracerApi, traceContext);
        boolean useTracing = traceFeature != null && tracerApi != null;
        TelemetryConfigurationEvent.Dd dd2 = new TelemetryConfigurationEvent.Dd();
        long l2 = timestamp;
        String string4 = TELEMETRY_SERVICE_NAME;
        TelemetryConfigurationEvent.Source source2 = TelemetryEventExtKt.tryFromSource(TelemetryConfigurationEvent.Source.Companion, datadogContext.getSource(), this.sdkCore.getInternalLogger());
        if (source2 == null) {
            source2 = TelemetryConfigurationEvent.Source.ANDROID;
        }
        String string5 = datadogContext.getSdkVersion();
        TelemetryConfigurationEvent.Application application2 = new TelemetryConfigurationEvent.Application(rumContext.getApplicationId());
        TelemetryConfigurationEvent.Session session2 = new TelemetryConfigurationEvent.Session(rumContext.getSessionId());
        String string6 = rumContext.getViewId();
        if (string6 != null) {
            string3 = string6;
            session = session2;
            application = application2;
            string2 = string5;
            source = source2;
            string = string4;
            l = l2;
            dd = dd2;
            boolean bl = false;
            view2 = new TelemetryConfigurationEvent.View(it);
            dd2 = dd;
            l2 = l;
            string4 = string;
            source2 = source;
            string5 = string2;
            application2 = application;
            session2 = session;
            view = view2;
        } else {
            view = null;
        }
        String string7 = rumContext.getActionId();
        if (string7 != null) {
            it = string7;
            view2 = view;
            session = session2;
            application = application2;
            string2 = string5;
            source = source2;
            string = string4;
            l = l2;
            dd = dd2;
            boolean bl = false;
            TelemetryConfigurationEvent.Action action2 = new TelemetryConfigurationEvent.Action(it);
            dd2 = dd;
            l2 = l;
            string4 = string;
            source2 = source;
            string5 = string2;
            application2 = application;
            session2 = session;
            view = view2;
            action = action2;
        } else {
            action = null;
        }
        Object object3 = datadogContext.getDeviceInfo().getDeviceBuildId();
        Object object4 = datadogContext.getDeviceInfo().getOsVersion();
        string3 = datadogContext.getDeviceInfo().getOsName();
        TelemetryConfigurationEvent.Os os = new TelemetryConfigurationEvent.Os((String)object3, string3, (String)object4);
        RumFeature.Configuration configuration2 = rumConfig;
        object3 = configuration2 != null ? Long.valueOf((long)configuration2.getSampleRate()) : null;
        RumFeature.Configuration configuration3 = rumConfig;
        object4 = configuration3 != null ? Long.valueOf((long)configuration3.getTelemetrySampleRate()) : null;
        boolean bl = coreConfiguration.getUseProxy();
        RumFeature.Configuration configuration4 = rumConfig;
        Boolean bl2 = configuration4 != null ? Boolean.valueOf(configuration4.getTrackFrustrations()) : null;
        boolean bl3 = coreConfiguration.getUseLocalEncryption();
        RumFeature.Configuration configuration5 = rumConfig;
        Boolean bl4 = configuration5 != null ? Boolean.valueOf(configuration5.getBackgroundEventTracking()) : null;
        RumFeature.Configuration configuration6 = rumConfig;
        boolean bl5 = (configuration6 != null ? Boolean.valueOf(configuration6.getUserActionTracking()) : null) != null;
        boolean bl6 = coreConfiguration.getTrackErrors();
        RumFeature.Configuration configuration7 = rumConfig;
        boolean bl7 = (configuration7 != null ? configuration7.getLongTaskTrackingStrategy() : null) != null;
        long l3 = coreConfiguration.getBatchSize();
        long l4 = coreConfiguration.getBatchUploadFrequency();
        Object object5 = rumConfig;
        Long l5 = object5 != null && (object5 = ((RumFeature.Configuration)object5).getVitalsMonitorUpdateFrequency()) != null ? Long.valueOf(((VitalsUpdateFrequency)((Object)object5)).getPeriodInMs$dd_sdk_android_rum_release()) : null;
        TracerApi tracerApi2 = tracerApi;
        String string8 = tracerApi2 != null ? tracerApi2.name() : null;
        boolean bl8 = this.trackNetworkRequests;
        long l6 = coreConfiguration.getBatchProcessingLevel();
        TelemetryConfigurationEvent.Telemetry telemetry = new TelemetryConfigurationEvent.Telemetry(new TelemetryConfigurationEvent.Device(datadogContext.getDeviceInfo().getArchitecture(), datadogContext.getDeviceInfo().getDeviceBrand(), datadogContext.getDeviceInfo().getDeviceModel()), os, new TelemetryConfigurationEvent.Configuration((Long)object3, (Long)object4, null, null, null, null, null, null, sessionReplaySampleRate, null, startSessionReplayManually, bl, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, sessionReplayPrivacy, null, null, null, null, bl2, null, bl5, null, null, null, null, bl3, viewTrackingStrategy, bl4, l5, bl6, bl8, useTracing, null, null, bl7, null, null, null, null, l3, l4, l6, null, null, null, null, null, null, null, string8, openTelemetryApiVersion, -134221060, 2132721786, 0, null), null, 8, null);
        List<String> list = null;
        TelemetryConfigurationEvent.Action action3 = action;
        TelemetryConfigurationEvent.View view3 = view;
        TelemetryConfigurationEvent.Session session3 = session2;
        TelemetryConfigurationEvent.Application application3 = application2;
        String string9 = string5;
        TelemetryConfigurationEvent.Source source3 = source2;
        String string10 = string4;
        long l7 = l2;
        TelemetryConfigurationEvent.Dd dd3 = dd2;
        return new TelemetryConfigurationEvent(dd3, l7, string10, source3, string9, application3, session3, view3, action3, list, telemetry);
    }

    private final boolean isGlobalTracerRegistered() {
        try {
            boolean bl;
            Class<?> globalTracerClass = Class.forName("io.opentracing.util.GlobalTracer");
            try {
                Object object = globalTracerClass.getMethod("isRegistered", new Class[0]).invoke(null, new Object[0]);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                bl = (Boolean)object;
            }
            catch (Throwable t) {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.TELEMETRY, (Function0)isGlobalTracerRegistered.1.INSTANCE, (Throwable)t, (boolean)false, null, (int)48, null);
                bl = false;
            }
            return bl;
        }
        catch (Throwable t) {
            boolean bl = false;
            return bl;
        }
    }

    private final boolean isOpenTelemetryRegistered(Map<String, ? extends Object> traceContext) {
        Object object = traceContext.get(IS_OPENTELEMETRY_ENABLED_CONTEXT_KEY);
        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
        return bl != null ? bl : false;
    }

    private final TracerApi resolveTracerApi(Map<String, ? extends Object> traceContext) {
        return this.isOpenTelemetryRegistered(traceContext) ? TracerApi.OpenTelemetry : (this.isGlobalTracerRegistered() ? TracerApi.OpenTracing : null);
    }

    private final String resolveOpenTelemetryApiVersion(TracerApi tracerApi, Map<String, ? extends Object> traceContext) {
        Object object;
        return tracerApi == TracerApi.OpenTelemetry ? ((object = traceContext.get(OPENTELEMETRY_API_VERSION_CONTEXT_KEY)) instanceof String ? (String)object : null) : null;
    }

    private final RumContext rumContext(DatadogContext $this$rumContext) {
        Map map = (Map)$this$rumContext.getFeaturesContext().get("rum");
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Map rumContext = map;
        return RumContext.Companion.fromFeatureContext(rumContext);
    }

    public static final /* synthetic */ TelemetryDebugEvent access$createDebugEvent(TelemetryEventHandler $this, DatadogContext datadogContext, long timestamp, String message, Map additionalProperties) {
        return $this.createDebugEvent(datadogContext, timestamp, message, additionalProperties);
    }

    public static final /* synthetic */ TelemetryErrorEvent access$createErrorEvent(TelemetryEventHandler $this, DatadogContext datadogContext, long timestamp, String message, String stack, String kind, Map additionalProperties) {
        return $this.createErrorEvent(datadogContext, timestamp, message, stack, kind, additionalProperties);
    }

    public static final /* synthetic */ TelemetryConfigurationEvent access$createConfigurationEvent(TelemetryEventHandler $this, DatadogContext datadogContext, long timestamp, TelemetryCoreConfiguration coreConfiguration) {
        return $this.createConfigurationEvent(datadogContext, timestamp, coreConfiguration);
    }

    public static final /* synthetic */ void access$setTrackNetworkRequests$p(TelemetryEventHandler $this, boolean bl) {
        $this.trackNetworkRequests = bl;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/datadog/android/telemetry/internal/TelemetryEventHandler$Companion;", "", "()V", "ALREADY_SEEN_EVENT_MESSAGE", "", "DEFAULT_CONFIGURATION_SAMPLE_RATE", "", "IS_OPENTELEMETRY_ENABLED_CONTEXT_KEY", "MAX_EVENTS_PER_SESSION", "", "MAX_EVENT_NUMBER_REACHED_MESSAGE", "OPENTELEMETRY_API_VERSION_CONTEXT_KEY", "SESSION_REPLAY_MANUAL_RECORDING_KEY", "SESSION_REPLAY_PRIVACY_KEY", "SESSION_REPLAY_SAMPLE_RATE_KEY", "TELEMETRY_SERVICE_NAME", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/telemetry/internal/TelemetryEventHandler$TracerApi;", "", "(Ljava/lang/String;I)V", "OpenTelemetry", "OpenTracing", "dd-sdk-android-rum_release"})
    public static final class TracerApi
    extends Enum<TracerApi> {
        public static final /* enum */ TracerApi OpenTelemetry = new TracerApi();
        public static final /* enum */ TracerApi OpenTracing = new TracerApi();
        private static final /* synthetic */ TracerApi[] $VALUES;

        public static TracerApi[] values() {
            return (TracerApi[])$VALUES.clone();
        }

        public static TracerApi valueOf(String value) {
            return Enum.valueOf(TracerApi.class, value);
        }

        static {
            $VALUES = tracerApiArray = new TracerApi[]{TracerApi.OpenTelemetry, TracerApi.OpenTracing};
        }
    }
}

