/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.tracking;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.MainThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.SdkCore;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.rum.GlobalRumMonitor;
import com.datadog.android.rum.RumMonitor;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.tracking.ActivityLifecycleTrackingStrategy;
import com.datadog.android.rum.tracking.TrackingStrategy;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0004J \u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u000fH\u0004J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000fH\u0017J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\u0018\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u000fH\u0017J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J\u0018\u0010%\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0012\u0010)\u001a\u00020\u001a2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J)\u0010*\u001a\u0004\u0018\u0001H+\"\u0004\b\u0000\u0010+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H+0-H\u0004\u00a2\u0006\u0002\u0010.R\u0014\u0010\u0004\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00060"}, d2={"Lcom/datadog/android/rum/tracking/ActivityLifecycleTrackingStrategy;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "Lcom/datadog/android/rum/tracking/TrackingStrategy;", "()V", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "getInternalLogger$dd_sdk_android_rum_release", "()Lcom/datadog/android/api/InternalLogger;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "getSdkCore", "()Lcom/datadog/android/api/feature/FeatureSdkCore;", "setSdkCore", "(Lcom/datadog/android/api/feature/FeatureSdkCore;)V", "safeExtras", "Landroid/os/Bundle;", "Landroid/content/Intent;", "getSafeExtras", "(Landroid/content/Intent;)Landroid/os/Bundle;", "convertToRumAttributes", "", "", "", "intent", "bundle", "onActivityCreated", "", "activity", "Landroid/app/Activity;", "savedInstanceState", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "register", "Lcom/datadog/android/api/SdkCore;", "context", "Landroid/content/Context;", "unregister", "withSdkCore", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nActivityLifecycleTrackingStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActivityLifecycleTrackingStrategy.kt\ncom/datadog/android/rum/tracking/ActivityLifecycleTrackingStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n1855#2,2:214\n1855#2,2:216\n*S KotlinDebug\n*F\n+ 1 ActivityLifecycleTrackingStrategy.kt\ncom/datadog/android/rum/tracking/ActivityLifecycleTrackingStrategy\n*L\n134#1:214,2\n154#1:216,2\n*E\n"})
public abstract class ActivityLifecycleTrackingStrategy
implements Application.ActivityLifecycleCallbacks,
TrackingStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    protected FeatureSdkCore sdkCore;
    @NotNull
    public static final String ARGUMENT_TAG = "view.arguments";
    @NotNull
    public static final String INTENT_ACTION_TAG = "view.intent.action";
    @NotNull
    public static final String INTENT_URI_TAG = "view.intent.uri";
    @NotNull
    public static final String EXTRA_SYNTHETICS_TEST_ID = "_dd.synthetics.test_id";
    @NotNull
    public static final String EXTRA_SYNTHETICS_RESULT_ID = "_dd.synthetics.result_id";

    @NotNull
    protected final FeatureSdkCore getSdkCore() {
        FeatureSdkCore featureSdkCore = this.sdkCore;
        if (featureSdkCore != null) {
            return featureSdkCore;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"sdkCore");
        return null;
    }

    protected final void setSdkCore(@NotNull FeatureSdkCore featureSdkCore) {
        Intrinsics.checkNotNullParameter((Object)featureSdkCore, (String)"<set-?>");
        this.sdkCore = featureSdkCore;
    }

    @NotNull
    public final InternalLogger getInternalLogger$dd_sdk_android_rum_release() {
        return this.sdkCore != null ? this.getSdkCore().getInternalLogger() : InternalLogger.Companion.getUNBOUND();
    }

    @Override
    public void register(@NotNull SdkCore sdkCore, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context instanceof Application) {
            this.setSdkCore((FeatureSdkCore)sdkCore);
            ((Application)context).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        } else {
            InternalLogger.DefaultImpls.log$default((InternalLogger)((FeatureSdkCore)sdkCore).getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)register.1.INSTANCE, null, (boolean)false, null, (int)56, null);
        }
    }

    @Override
    public void unregister(@Nullable Context context) {
        if (context instanceof Application) {
            ((Application)context).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    @MainThread
    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @MainThread
    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @MainThread
    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @MainThread
    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
    }

    @MainThread
    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @MainThread
    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Bundle extras;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intent intent = activity.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
        Bundle bundle = extras = this.getSafeExtras(intent);
        String testId = bundle != null ? bundle.getString(EXTRA_SYNTHETICS_TEST_ID) : null;
        Bundle bundle2 = extras;
        String resultId = bundle2 != null ? bundle2.getString(EXTRA_SYNTHETICS_RESULT_ID) : null;
        Object object = testId;
        if (!(object == null || StringsKt.isBlank((CharSequence)object)) && !((object = (CharSequence)resultId) == null || StringsKt.isBlank((CharSequence)object))) {
            RumMonitor rumMonitor2 = GlobalRumMonitor.get((SdkCore)this.getSdkCore());
            Object object2 = object = rumMonitor2 instanceof AdvancedRumMonitor ? (AdvancedRumMonitor)rumMonitor2 : null;
            if (object != null) {
                object.setSyntheticsAttribute(testId, resultId);
            }
        }
    }

    @MainThread
    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @NotNull
    protected final Map<String, Object> convertToRumAttributes(@Nullable Intent intent) {
        Map attributes;
        block4: {
            String it;
            if (intent == null) {
                return MapsKt.emptyMap();
            }
            attributes = new LinkedHashMap();
            String string = intent.getAction();
            if (string != null) {
                it = string;
                boolean bl = false;
                attributes.put(INTENT_ACTION_TAG, it);
            }
            String string2 = intent.getDataString();
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                attributes.put(INTENT_URI_TAG, it);
            }
            Bundle bundle = this.getSafeExtras(intent);
            if (bundle == null) break block4;
            Bundle bundle2 = bundle;
            boolean bl = false;
            Set set = bundle2.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"bundle.keySet()");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it2 = (String)element$iv;
                boolean bl2 = false;
                attributes.put("view.arguments." + it2, bundle2.get(it2));
            }
        }
        return attributes;
    }

    @NotNull
    protected final Map<String, Object> convertToRumAttributes(@Nullable Bundle bundle) {
        if (bundle == null) {
            return MapsKt.emptyMap();
        }
        Map attributes = new LinkedHashMap();
        Set set = bundle.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"bundle.keySet()");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            attributes.put("view.arguments." + it, bundle.get(it));
        }
        return attributes;
    }

    @Nullable
    protected final <T> T withSdkCore(@NotNull Function1<? super FeatureSdkCore, ? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (this.sdkCore != null) {
            object = block.invoke((Object)this.getSdkCore());
        } else {
            InternalLogger.DefaultImpls.log$default((InternalLogger)InternalLogger.Companion.getUNBOUND(), (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)withSdkCore.2.INSTANCE, null, (boolean)false, null, (int)56, null);
            object = null;
        }
        return (T)object;
    }

    private final Bundle getSafeExtras(Intent $this$safeExtras) {
        Bundle bundle;
        try {
            bundle = $this$safeExtras.getExtras();
        }
        catch (Exception e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.getInternalLogger$dd_sdk_android_rum_release(), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)safeExtras.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            bundle = null;
        }
        return bundle;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/datadog/android/rum/tracking/ActivityLifecycleTrackingStrategy$Companion;", "", "()V", "ARGUMENT_TAG", "", "EXTRA_SYNTHETICS_RESULT_ID", "EXTRA_SYNTHETICS_TEST_ID", "INTENT_ACTION_TAG", "INTENT_URI_TAG", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

