/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal.domain.scope;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.SdkCore;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.context.NetworkInfo;
import com.datadog.android.api.context.UserInfo;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.core.InternalSdkCore;
import com.datadog.android.core.internal.net.FirstPartyHostHeaderTypeResolver;
import com.datadog.android.core.internal.utils.ThrowableExtKt;
import com.datadog.android.rum.GlobalRumMonitor;
import com.datadog.android.rum.RumErrorSource;
import com.datadog.android.rum.RumResourceKind;
import com.datadog.android.rum.RumResourceMethod;
import com.datadog.android.rum.internal.FeaturesContextResolver;
import com.datadog.android.rum.internal.domain.RumContext;
import com.datadog.android.rum.internal.domain.Time;
import com.datadog.android.rum.internal.domain.event.ResourceTiming;
import com.datadog.android.rum.internal.domain.scope.ExternalResourceTimingsKt;
import com.datadog.android.rum.internal.domain.scope.RumEventExtKt;
import com.datadog.android.rum.internal.domain.scope.RumRawEvent;
import com.datadog.android.rum.internal.domain.scope.RumScope;
import com.datadog.android.rum.internal.monitor.AdvancedRumMonitor;
import com.datadog.android.rum.internal.monitor.StorageEvent;
import com.datadog.android.rum.internal.utils.RuntimeUtilsKt;
import com.datadog.android.rum.internal.utils.SdkCoreExtKt;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.ResourceEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 i2\u00020\u0001:\u0001iBk\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010B\u001a\u00020\"H\u0016J \u0010C\u001a\u0004\u0018\u00010\u00012\u0006\u0010D\u001a\u00020E2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000e0GH\u0017J\b\u0010H\u001a\u000204H\u0016J\u001e\u0010I\u001a\u00020J2\u0006\u0010D\u001a\u00020K2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000e0GH\u0003J\u001e\u0010L\u001a\u00020J2\u0006\u0010D\u001a\u00020M2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000e0GH\u0003J\u001e\u0010N\u001a\u00020J2\u0006\u0010D\u001a\u00020O2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000e0GH\u0003J\u001e\u0010P\u001a\u00020J2\u0006\u0010D\u001a\u00020Q2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000e0GH\u0003J\u0010\u0010R\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\n\u0010S\u001a\u0004\u0018\u00010TH\u0002J2\u0010U\u001a\u0004\u0018\u00010V2\b\u0010W\u001a\u0004\u0018\u00010\u00062\b\u0010X\u001a\u0004\u0018\u00010\u00062\b\u0010Y\u001a\u0004\u0018\u00010\u00062\b\u0010Z\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010[\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J\n\u0010\\\u001a\u0004\u0018\u00010]H\u0002JS\u0010^\u001a\u00020J2\u0006\u0010_\u001a\u00020\u00062\u0006\u0010`\u001a\u00020a2\b\u00108\u001a\u0004\u0018\u00010\u00102\b\u0010b\u001a\u0004\u0018\u00010\u00062\b\u0010c\u001a\u0004\u0018\u00010\u00062\b\u0010d\u001a\u0004\u0018\u00010e2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000e0GH\u0002\u00a2\u0006\u0002\u0010fJ?\u0010g\u001a\u00020J2\u0006\u0010%\u001a\u00020&2\b\u00108\u001a\u0004\u0018\u00010\u00102\b\u00105\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000b2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u000e0GH\u0002\u00a2\u0006\u0002\u0010hR\"\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010$R\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u000e\u00103\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u00105\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00106R\u000e\u00107\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u00108\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00106R\u001a\u00109\u001a\u000204X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0010\u0010>\u001a\u0004\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010$R\u000e\u0010A\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumResourceScope;", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "parentScope", "sdkCore", "Lcom/datadog/android/core/InternalSdkCore;", "url", "", "method", "Lcom/datadog/android/rum/RumResourceMethod;", "key", "eventTime", "Lcom/datadog/android/rum/internal/domain/Time;", "initialAttributes", "", "", "serverTimeOffsetInMs", "", "firstPartyHostHeaderTypeResolver", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "featuresContextResolver", "Lcom/datadog/android/rum/internal/FeaturesContextResolver;", "sampleRate", "", "(Lcom/datadog/android/rum/internal/domain/scope/RumScope;Lcom/datadog/android/core/InternalSdkCore;Ljava/lang/String;Lcom/datadog/android/rum/RumResourceMethod;Ljava/lang/String;Lcom/datadog/android/rum/internal/domain/Time;Ljava/util/Map;JLcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;Lcom/datadog/android/rum/internal/FeaturesContextResolver;F)V", "attributes", "", "getAttributes$dd_sdk_android_rum_release", "()Ljava/util/Map;", "eventTimestamp", "getEventTimestamp$dd_sdk_android_rum_release", "()J", "getFirstPartyHostHeaderTypeResolver$dd_sdk_android_rum_release", "()Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "initialContext", "Lcom/datadog/android/rum/internal/domain/RumContext;", "getKey$dd_sdk_android_rum_release", "()Ljava/lang/String;", "kind", "Lcom/datadog/android/rum/RumResourceKind;", "getMethod$dd_sdk_android_rum_release", "()Lcom/datadog/android/rum/RumResourceMethod;", "networkInfo", "Lcom/datadog/android/api/context/NetworkInfo;", "getParentScope$dd_sdk_android_rum_release", "()Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "resourceId", "getResourceId$dd_sdk_android_rum_release", "getSampleRate$dd_sdk_android_rum_release", "()F", "getSdkCore$dd_sdk_android_rum_release", "()Lcom/datadog/android/core/InternalSdkCore;", "sent", "", "size", "Ljava/lang/Long;", "startedNanos", "statusCode", "stopped", "getStopped$dd_sdk_android_rum_release", "()Z", "setStopped$dd_sdk_android_rum_release", "(Z)V", "timing", "Lcom/datadog/android/rum/internal/domain/event/ResourceTiming;", "getUrl$dd_sdk_android_rum_release", "waitForTiming", "getRumContext", "handleEvent", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent;", "writer", "Lcom/datadog/android/api/storage/DataWriter;", "isActive", "onAddResourceTiming", "", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$AddResourceTiming;", "onStopResource", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StopResource;", "onStopResourceWithError", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StopResourceWithError;", "onStopResourceWithStackTrace", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StopResourceWithStackTrace;", "resolveDomain", "resolveErrorProvider", "Lcom/datadog/android/rum/model/ErrorEvent$Provider;", "resolveGraphQLAttributes", "Lcom/datadog/android/rum/model/ResourceEvent$Graphql;", "operationType", "operationName", "payload", "variables", "resolveResourceDuration", "resolveResourceProvider", "Lcom/datadog/android/rum/model/ResourceEvent$Provider;", "sendError", "message", "source", "Lcom/datadog/android/rum/RumErrorSource;", "stackTrace", "errorType", "errorCategory", "Lcom/datadog/android/rum/model/ErrorEvent$Category;", "(Ljava/lang/String;Lcom/datadog/android/rum/RumErrorSource;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;Lcom/datadog/android/rum/model/ErrorEvent$Category;Lcom/datadog/android/api/storage/DataWriter;)V", "sendResource", "(Lcom/datadog/android/rum/RumResourceKind;Ljava/lang/Long;Ljava/lang/Long;Lcom/datadog/android/rum/internal/domain/Time;Lcom/datadog/android/api/storage/DataWriter;)V", "Companion", "dd-sdk-android-rum_release"})
public final class RumResourceScope
implements RumScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RumScope parentScope;
    @NotNull
    private final InternalSdkCore sdkCore;
    @NotNull
    private final String url;
    @NotNull
    private final RumResourceMethod method;
    @NotNull
    private final String key;
    @NotNull
    private final FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver;
    @NotNull
    private final FeaturesContextResolver featuresContextResolver;
    private final float sampleRate;
    @NotNull
    private final String resourceId;
    @NotNull
    private final Map<String, Object> attributes;
    @Nullable
    private ResourceTiming timing;
    @NotNull
    private final RumContext initialContext;
    private final long eventTimestamp;
    private final long startedNanos;
    @NotNull
    private final NetworkInfo networkInfo;
    private boolean sent;
    private boolean waitForTiming;
    private boolean stopped;
    @NotNull
    private RumResourceKind kind;
    @Nullable
    private Long statusCode;
    @Nullable
    private Long size;
    @NotNull
    public static final String NEGATIVE_DURATION_WARNING_MESSAGE = "The computed duration for your resource: %s was 0 or negative. In order to keep the resource event we forced it to 1ns.";

    /*
     * WARNING - void declaration
     */
    public RumResourceScope(@NotNull RumScope parentScope, @NotNull InternalSdkCore sdkCore, @NotNull String url, @NotNull RumResourceMethod method, @NotNull String key, @NotNull Time eventTime, @NotNull Map<String, ? extends Object> initialAttributes, long serverTimeOffsetInMs, @NotNull FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver, @NotNull FeaturesContextResolver featuresContextResolver, float sampleRate) {
        void $this$attributes_u24lambda_u240;
        Map map;
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        Intrinsics.checkNotNullParameter(initialAttributes, (String)"initialAttributes");
        Intrinsics.checkNotNullParameter((Object)firstPartyHostHeaderTypeResolver, (String)"firstPartyHostHeaderTypeResolver");
        Intrinsics.checkNotNullParameter((Object)featuresContextResolver, (String)"featuresContextResolver");
        this.parentScope = parentScope;
        this.sdkCore = sdkCore;
        this.url = url;
        this.method = method;
        this.key = key;
        this.firstPartyHostHeaderTypeResolver = firstPartyHostHeaderTypeResolver;
        this.featuresContextResolver = featuresContextResolver;
        this.sampleRate = sampleRate;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.resourceId = string;
        Map map2 = map = MapsKt.toMutableMap(initialAttributes);
        RumResourceScope rumResourceScope = this;
        boolean bl = false;
        $this$attributes_u24lambda_u240.putAll(GlobalRumMonitor.get((SdkCore)this.sdkCore).getAttributes());
        rumResourceScope.attributes = map;
        this.initialContext = this.parentScope.getRumContext();
        this.eventTimestamp = eventTime.getTimestamp() + serverTimeOffsetInMs;
        this.startedNanos = eventTime.getNanoTime();
        this.networkInfo = this.sdkCore.getNetworkInfo();
        this.kind = RumResourceKind.UNKNOWN;
    }

    @NotNull
    public final RumScope getParentScope$dd_sdk_android_rum_release() {
        return this.parentScope;
    }

    @NotNull
    public final InternalSdkCore getSdkCore$dd_sdk_android_rum_release() {
        return this.sdkCore;
    }

    @NotNull
    public final String getUrl$dd_sdk_android_rum_release() {
        return this.url;
    }

    @NotNull
    public final RumResourceMethod getMethod$dd_sdk_android_rum_release() {
        return this.method;
    }

    @NotNull
    public final String getKey$dd_sdk_android_rum_release() {
        return this.key;
    }

    @NotNull
    public final FirstPartyHostHeaderTypeResolver getFirstPartyHostHeaderTypeResolver$dd_sdk_android_rum_release() {
        return this.firstPartyHostHeaderTypeResolver;
    }

    public final float getSampleRate$dd_sdk_android_rum_release() {
        return this.sampleRate;
    }

    @NotNull
    public final String getResourceId$dd_sdk_android_rum_release() {
        return this.resourceId;
    }

    @NotNull
    public final Map<String, Object> getAttributes$dd_sdk_android_rum_release() {
        return this.attributes;
    }

    public final long getEventTimestamp$dd_sdk_android_rum_release() {
        return this.eventTimestamp;
    }

    public final boolean getStopped$dd_sdk_android_rum_release() {
        return this.stopped;
    }

    public final void setStopped$dd_sdk_android_rum_release(boolean bl) {
        this.stopped = bl;
    }

    @Override
    @WorkerThread
    @Nullable
    public RumScope handleEvent(@NotNull RumRawEvent event, @NotNull DataWriter<Object> writer) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        RumRawEvent rumRawEvent = event;
        if (rumRawEvent instanceof RumRawEvent.WaitForResourceTiming) {
            if (Intrinsics.areEqual((Object)this.key, (Object)((RumRawEvent.WaitForResourceTiming)event).getKey())) {
                this.waitForTiming = true;
            }
        } else if (rumRawEvent instanceof RumRawEvent.AddResourceTiming) {
            this.onAddResourceTiming((RumRawEvent.AddResourceTiming)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.StopResource) {
            this.onStopResource((RumRawEvent.StopResource)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.StopResourceWithError) {
            this.onStopResourceWithError((RumRawEvent.StopResourceWithError)event, writer);
        } else if (rumRawEvent instanceof RumRawEvent.StopResourceWithStackTrace) {
            this.onStopResourceWithStackTrace((RumRawEvent.StopResourceWithStackTrace)event, writer);
        }
        return this.sent ? null : (RumScope)this;
    }

    @Override
    @NotNull
    public RumContext getRumContext() {
        return this.initialContext;
    }

    @Override
    public boolean isActive() {
        return !this.stopped;
    }

    @WorkerThread
    private final void onStopResource(RumRawEvent.StopResource event, DataWriter<Object> writer) {
        if (!Intrinsics.areEqual((Object)this.key, (Object)event.getKey())) {
            return;
        }
        this.stopped = true;
        this.attributes.putAll(event.getAttributes());
        this.kind = event.getKind();
        this.statusCode = event.getStatusCode();
        this.size = event.getSize();
        if (!this.waitForTiming || this.timing != null) {
            this.sendResource(this.kind, event.getStatusCode(), event.getSize(), event.getEventTime(), writer);
        }
    }

    @WorkerThread
    private final void onAddResourceTiming(RumRawEvent.AddResourceTiming event, DataWriter<Object> writer) {
        if (!Intrinsics.areEqual((Object)this.key, (Object)event.getKey())) {
            return;
        }
        this.timing = event.getTiming();
        if (this.stopped && !this.sent) {
            this.sendResource(this.kind, this.statusCode, this.size, event.getEventTime(), writer);
        }
    }

    @WorkerThread
    private final void onStopResourceWithError(RumRawEvent.StopResourceWithError event, DataWriter<Object> writer) {
        if (!Intrinsics.areEqual((Object)this.key, (Object)event.getKey())) {
            return;
        }
        this.attributes.putAll(event.getAttributes());
        this.sendError(event.getMessage(), event.getSource(), event.getStatusCode(), ThrowableExtKt.loggableStackTrace((Throwable)event.getThrowable()), event.getThrowable().getClass().getCanonicalName(), ErrorEvent.Category.EXCEPTION, writer);
    }

    @WorkerThread
    private final void onStopResourceWithStackTrace(RumRawEvent.StopResourceWithStackTrace event, DataWriter<Object> writer) {
        if (!Intrinsics.areEqual((Object)this.key, (Object)event.getKey())) {
            return;
        }
        this.attributes.putAll(event.getAttributes());
        ErrorEvent.Category errorCategory = ((CharSequence)event.getStackTrace()).length() > 0 ? ErrorEvent.Category.EXCEPTION : null;
        this.sendError(event.getMessage(), event.getSource(), event.getStatusCode(), event.getStackTrace(), event.getErrorType(), errorCategory, writer);
    }

    private final void sendResource(RumResourceKind kind, Long statusCode, Long size, Time eventTime, DataWriter<Object> writer) {
        Object object;
        this.attributes.putAll(GlobalRumMonitor.get((SdkCore)this.sdkCore).getAttributes());
        Object object2 = this.attributes.remove("_dd.trace_id");
        String traceId = object2 != null ? object2.toString() : null;
        Object object3 = this.attributes.remove("_dd.span_id");
        String spanId = object3 != null ? object3.toString() : null;
        Object object4 = this.attributes.remove("_dd.rule_psr");
        Number rulePsr = object4 instanceof Number ? (Number)((Number)object4) : (Number)null;
        RumContext rumContext = this.getRumContext();
        CharSequence charSequence = rumContext.getSyntheticsTestId();
        ResourceEvent.Synthetics syntheticsAttribute = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)rumContext.getSyntheticsResultId()) == null || StringsKt.isBlank((CharSequence)charSequence) ? null : new ResourceEvent.Synthetics(rumContext.getSyntheticsTestId(), rumContext.getSyntheticsResultId(), null, 4, null);
        ResourceEvent.ResourceEventSessionType sessionType = syntheticsAttribute == null ? ResourceEvent.ResourceEventSessionType.USER : ResourceEvent.ResourceEventSessionType.SYNTHETICS;
        ResourceTiming resourceTiming = this.timing;
        if (resourceTiming == null) {
            object = this.attributes.remove("_dd.resource_timings");
            resourceTiming = ExternalResourceTimingsKt.extractResourceTiming(object instanceof Map ? (Map)object : null);
        }
        ResourceTiming finalTiming = resourceTiming;
        object = this.attributes.remove("_dd.graphql.operation_type");
        String string = object instanceof String ? (String)object : null;
        object = this.attributes.remove("_dd.graphql.operation_name");
        String string2 = object instanceof String ? (String)object : null;
        object = this.attributes.remove("_dd.graphql.payload");
        String string3 = object instanceof String ? (String)object : null;
        object = this.attributes.remove("_dd.graphql.variables");
        ResourceEvent.Graphql graphql = this.resolveGraphQLAttributes(string, string2, string3, object instanceof String ? (String)object : null);
        Map eventAttributes = MapsKt.toMutableMap(this.attributes);
        SdkCoreExtKt.newRumEventWriteOperation$default((FeatureSdkCore)this.sdkCore, writer, null, (Function1)new Function1<DatadogContext, Object>(this, rumContext, eventTime, kind, finalTiming, statusCode, size, graphql, sessionType, (Map<String, Object>)eventAttributes, spanId, traceId, rulePsr, syntheticsAttribute){
            final /* synthetic */ RumResourceScope this$0;
            final /* synthetic */ RumContext $rumContext;
            final /* synthetic */ Time $eventTime;
            final /* synthetic */ RumResourceKind $kind;
            final /* synthetic */ ResourceTiming $finalTiming;
            final /* synthetic */ Long $statusCode;
            final /* synthetic */ Long $size;
            final /* synthetic */ ResourceEvent.Graphql $graphql;
            final /* synthetic */ ResourceEvent.ResourceEventSessionType $sessionType;
            final /* synthetic */ Map<String, Object> $eventAttributes;
            final /* synthetic */ String $spanId;
            final /* synthetic */ String $traceId;
            final /* synthetic */ Number $rulePsr;
            final /* synthetic */ ResourceEvent.Synthetics $syntheticsAttribute;
            {
                this.this$0 = $receiver;
                this.$rumContext = $rumContext;
                this.$eventTime = $eventTime;
                this.$kind = $kind;
                this.$finalTiming = $finalTiming;
                this.$statusCode = $statusCode;
                this.$size = $size;
                this.$graphql = $graphql;
                this.$sessionType = $sessionType;
                this.$eventAttributes = $eventAttributes;
                this.$spanId = $spanId;
                this.$traceId = $traceId;
                this.$rulePsr = $rulePsr;
                this.$syntheticsAttribute = $syntheticsAttribute;
                super(1);
            }

            @NotNull
            public final Object invoke(@NotNull DatadogContext datadogContext) {
                String string;
                Object object;
                Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                UserInfo user = datadogContext.getUserInfo();
                FeaturesContextResolver featuresContextResolver = RumResourceScope.access$getFeaturesContextResolver$p(this.this$0);
                String string2 = this.$rumContext.getViewId();
                if (string2 == null) {
                    string2 = "";
                }
                boolean hasReplay = featuresContextResolver.resolveViewHasReplay(datadogContext, string2);
                long duration = RumResourceScope.access$resolveResourceDuration(this.this$0, this.$eventTime);
                long l = this.this$0.getEventTimestamp$dd_sdk_android_rum_release();
                String string3 = this.this$0.getResourceId$dd_sdk_android_rum_release();
                Object object2 = RumEventExtKt.toSchemaType(this.$kind);
                Object object3 = this.this$0.getUrl$dd_sdk_android_rum_release();
                Object object4 = RumEventExtKt.toResourceMethod(this.this$0.getMethod$dd_sdk_android_rum_release());
                ResourceTiming resourceTiming = this.$finalTiming;
                ResourceEvent.Dns dns = resourceTiming != null ? RumEventExtKt.dns(resourceTiming) : null;
                ResourceTiming resourceTiming2 = this.$finalTiming;
                Object object5 = resourceTiming2 != null ? RumEventExtKt.connect(resourceTiming2) : null;
                ResourceTiming resourceTiming3 = this.$finalTiming;
                Object object6 = resourceTiming3 != null ? RumEventExtKt.ssl(resourceTiming3) : null;
                ResourceTiming resourceTiming4 = this.$finalTiming;
                Object object7 = resourceTiming4 != null ? RumEventExtKt.firstByte(resourceTiming4) : null;
                ResourceTiming resourceTiming5 = this.$finalTiming;
                Object object8 = resourceTiming5 != null ? RumEventExtKt.download(resourceTiming5) : null;
                Object object9 = RumResourceScope.access$resolveResourceProvider(this.this$0);
                ResourceEvent.Resource resource = new ResourceEvent.Resource(string3, (ResourceEvent.ResourceType)((Object)object2), (ResourceEvent.Method)((Object)object4), (String)object3, this.$statusCode, duration, this.$size, null, dns, (ResourceEvent.Connect)object5, (ResourceEvent.Ssl)object6, (ResourceEvent.FirstByte)object7, (ResourceEvent.Download)object8, (ResourceEvent.Provider)object9, this.$graphql, 128, null);
                String string4 = this.$rumContext.getActionId();
                if (string4 != null) {
                    String it = string4;
                    boolean bl = false;
                    object = new ResourceEvent.Action(CollectionsKt.listOf((Object)it));
                } else {
                    object = string3 = null;
                }
                if ((string = this.$rumContext.getViewId()) == null) {
                    string = "";
                }
                object3 = string;
                object4 = this.$rumContext.getViewName();
                String string5 = this.$rumContext.getViewUrl();
                if (string5 == null) {
                    string5 = "";
                }
                Object object10 = string5;
                object2 = new ResourceEvent.ResourceEventView((String)object3, null, (String)object10, (String)object4, 2, null);
                object3 = RuntimeUtilsKt.hasUserData(user) ? new ResourceEvent.Usr(user.getId(), user.getName(), user.getEmail(), MapsKt.toMutableMap((Map)user.getAdditionalProperties())) : null;
                object4 = RumEventExtKt.toResourceConnectivity(RumResourceScope.access$getNetworkInfo$p(this.this$0));
                object10 = new ResourceEvent.Application(this.$rumContext.getApplicationId());
                object5 = new ResourceEvent.ResourceEventSession(this.$rumContext.getSessionId(), this.$sessionType, hasReplay);
                object6 = RumEventExtKt.tryFromSource(ResourceEvent.ResourceEventSource.Companion, datadogContext.getSource(), this.this$0.getSdkCore$dd_sdk_android_rum_release().getInternalLogger());
                object7 = new ResourceEvent.Os(datadogContext.getDeviceInfo().getOsName(), datadogContext.getDeviceInfo().getOsVersion(), null, datadogContext.getDeviceInfo().getOsMajorVersion(), 4, null);
                object8 = new ResourceEvent.Device(RumEventExtKt.toResourceSchemaType(datadogContext.getDeviceInfo().getDeviceType()), datadogContext.getDeviceInfo().getDeviceName(), datadogContext.getDeviceInfo().getDeviceModel(), datadogContext.getDeviceInfo().getDeviceBrand(), datadogContext.getDeviceInfo().getArchitecture());
                object9 = new ResourceEvent.Context(this.$eventAttributes);
                Object object11 = new ResourceEvent.DdSession(null, RumEventExtKt.toResourceSessionPrecondition(this.$rumContext.getSessionStartReason()), 1, null);
                Object object12 = new ResourceEvent.Configuration(Float.valueOf(this.this$0.getSampleRate$dd_sdk_android_rum_release()), null, 2, null);
                ResourceEvent.Dd dd = new ResourceEvent.Dd((ResourceEvent.DdSession)object11, (ResourceEvent.Configuration)object12, null, this.$spanId, this.$traceId, this.$rulePsr, null, 68, null);
                object11 = datadogContext.getService();
                object12 = datadogContext.getVersion();
                return new ResourceEvent(l, (ResourceEvent.Application)object10, (String)object11, (String)object12, null, null, (ResourceEvent.ResourceEventSession)object5, (ResourceEvent.ResourceEventSource)((Object)object6), (ResourceEvent.ResourceEventView)object2, (ResourceEvent.Usr)object3, (ResourceEvent.Connectivity)object4, null, this.$syntheticsAttribute, null, (ResourceEvent.Os)object7, (ResourceEvent.Device)object8, dd, (ResourceEvent.Context)object9, (ResourceEvent.Action)((Object)string3), null, resource, 534576, null);
            }
        }, 2, null).onError((Function1<? super AdvancedRumMonitor, Unit>)((Function1)new Function1<AdvancedRumMonitor, Unit>(rumContext){
            final /* synthetic */ RumContext $rumContext;
            {
                this.$rumContext = $rumContext;
                super(1);
            }

            public final void invoke(@NotNull AdvancedRumMonitor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = this.$rumContext.getViewId();
                if (string == null) {
                    string = "";
                }
                it.eventDropped(string, StorageEvent.Resource.INSTANCE);
            }
        })).onSuccess((Function1<? super AdvancedRumMonitor, Unit>)((Function1)new Function1<AdvancedRumMonitor, Unit>(rumContext){
            final /* synthetic */ RumContext $rumContext;
            {
                this.$rumContext = $rumContext;
                super(1);
            }

            public final void invoke(@NotNull AdvancedRumMonitor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = this.$rumContext.getViewId();
                if (string == null) {
                    string = "";
                }
                it.eventSent(string, StorageEvent.Resource.INSTANCE);
            }
        })).submit();
        this.sent = true;
    }

    private final long resolveResourceDuration(Time eventTime) {
        long l;
        long duration = eventTime.getNanoTime() - this.startedNanos;
        if (duration <= 0L) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ RumResourceScope this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "The computed duration for your resource: %s was 0 or negative. In order to keep the resource event we forced it to 1ns.";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.this$0.getUrl$dd_sdk_android_rum_release()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }), null, (boolean)false, null, (int)56, null);
            l = 1L;
        } else {
            l = duration;
        }
        return l;
    }

    private final ResourceEvent.Provider resolveResourceProvider() {
        return this.firstPartyHostHeaderTypeResolver.isFirstPartyUrl(this.url) ? new ResourceEvent.Provider(this.resolveDomain(this.url), null, ResourceEvent.ProviderType.FIRST_PARTY, 2, null) : null;
    }

    private final void sendError(String message, RumErrorSource source, Long statusCode, String stackTrace, String errorType, ErrorEvent.Category errorCategory, DataWriter<Object> writer) {
        this.attributes.putAll(GlobalRumMonitor.get((SdkCore)this.sdkCore).getAttributes());
        Object object = this.attributes.remove("_dd.error.fingerprint");
        String errorFingerprint = object instanceof String ? (String)object : null;
        RumContext rumContext = this.getRumContext();
        Map eventAttributes = MapsKt.toMutableMap(this.attributes);
        CharSequence charSequence = rumContext.getSyntheticsTestId();
        ErrorEvent.Synthetics syntheticsAttribute = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)rumContext.getSyntheticsResultId()) == null || StringsKt.isBlank((CharSequence)charSequence) ? null : new ErrorEvent.Synthetics(rumContext.getSyntheticsTestId(), rumContext.getSyntheticsResultId(), null, 4, null);
        ErrorEvent.ErrorEventSessionType sessionType = syntheticsAttribute == null ? ErrorEvent.ErrorEventSessionType.USER : ErrorEvent.ErrorEventSessionType.SYNTHETICS;
        SdkCoreExtKt.newRumEventWriteOperation$default((FeatureSdkCore)this.sdkCore, writer, null, (Function1)new Function1<DatadogContext, Object>(this, rumContext, source, statusCode, message, stackTrace, errorFingerprint, errorType, errorCategory, sessionType, (Map<String, Object>)eventAttributes, syntheticsAttribute){
            final /* synthetic */ RumResourceScope this$0;
            final /* synthetic */ RumContext $rumContext;
            final /* synthetic */ RumErrorSource $source;
            final /* synthetic */ Long $statusCode;
            final /* synthetic */ String $message;
            final /* synthetic */ String $stackTrace;
            final /* synthetic */ String $errorFingerprint;
            final /* synthetic */ String $errorType;
            final /* synthetic */ ErrorEvent.Category $errorCategory;
            final /* synthetic */ ErrorEvent.ErrorEventSessionType $sessionType;
            final /* synthetic */ Map<String, Object> $eventAttributes;
            final /* synthetic */ ErrorEvent.Synthetics $syntheticsAttribute;
            {
                this.this$0 = $receiver;
                this.$rumContext = $rumContext;
                this.$source = $source;
                this.$statusCode = $statusCode;
                this.$message = $message;
                this.$stackTrace = $stackTrace;
                this.$errorFingerprint = $errorFingerprint;
                this.$errorType = $errorType;
                this.$errorCategory = $errorCategory;
                this.$sessionType = $sessionType;
                this.$eventAttributes = $eventAttributes;
                this.$syntheticsAttribute = $syntheticsAttribute;
                super(1);
            }

            @NotNull
            public final Object invoke(@NotNull DatadogContext datadogContext) {
                String string;
                Object object;
                Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                UserInfo user = datadogContext.getUserInfo();
                FeaturesContextResolver featuresContextResolver = RumResourceScope.access$getFeaturesContextResolver$p(this.this$0);
                String string2 = this.$rumContext.getViewId();
                if (string2 == null) {
                    string2 = "";
                }
                boolean hasReplay = featuresContextResolver.resolveViewHasReplay(datadogContext, string2);
                String string3 = datadogContext.getAppBuildId();
                long l = this.this$0.getEventTimestamp$dd_sdk_android_rum_release();
                ErrorEvent.ErrorSource errorSource = RumEventExtKt.toSchemaSource(this.$source);
                Object object2 = this.this$0.getUrl$dd_sdk_android_rum_release();
                Object object3 = RumEventExtKt.toErrorMethod(this.this$0.getMethod$dd_sdk_android_rum_release());
                Long l2 = this.$statusCode;
                long l3 = l2 != null ? l2 : 0L;
                Object object4 = RumResourceScope.access$resolveErrorProvider(this.this$0);
                Object object5 = new ErrorEvent.Resource((ErrorEvent.Method)((Object)object3), l3, (String)object2, (ErrorEvent.Provider)object4);
                object2 = ErrorEvent.SourceType.ANDROID;
                ErrorEvent.Error error = new ErrorEvent.Error(null, this.$message, errorSource, this.$stackTrace, null, false, this.$errorFingerprint, this.$errorType, this.$errorCategory, null, null, (ErrorEvent.SourceType)((Object)object2), (ErrorEvent.Resource)object5, null, null, null, null, null, 255505, null);
                String string4 = this.$rumContext.getActionId();
                if (string4 != null) {
                    String it = string4;
                    boolean bl = false;
                    object = new ErrorEvent.Action(CollectionsKt.listOf((Object)it));
                } else {
                    object = errorSource = null;
                }
                if ((string = this.$rumContext.getViewId()) == null) {
                    string = "";
                }
                object2 = string;
                object3 = this.$rumContext.getViewName();
                String string5 = this.$rumContext.getViewUrl();
                if (string5 == null) {
                    string5 = "";
                }
                Object object6 = string5;
                object5 = new ErrorEvent.ErrorEventView((String)object2, null, (String)object6, (String)object3, null, 18, null);
                object2 = RuntimeUtilsKt.hasUserData(user) ? new ErrorEvent.Usr(user.getId(), user.getName(), user.getEmail(), MapsKt.toMutableMap((Map)user.getAdditionalProperties())) : null;
                object3 = RumEventExtKt.toErrorConnectivity(RumResourceScope.access$getNetworkInfo$p(this.this$0));
                object6 = new ErrorEvent.Application(this.$rumContext.getApplicationId());
                ErrorEvent.ErrorEventSession errorEventSession = new ErrorEvent.ErrorEventSession(this.$rumContext.getSessionId(), this.$sessionType, hasReplay);
                object4 = RumEventExtKt.tryFromSource(ErrorEvent.ErrorEventSource.Companion, datadogContext.getSource(), this.this$0.getSdkCore$dd_sdk_android_rum_release().getInternalLogger());
                ErrorEvent.Os os = new ErrorEvent.Os(datadogContext.getDeviceInfo().getOsName(), datadogContext.getDeviceInfo().getOsVersion(), null, datadogContext.getDeviceInfo().getOsMajorVersion(), 4, null);
                ErrorEvent.Device device = new ErrorEvent.Device(RumEventExtKt.toErrorSchemaType(datadogContext.getDeviceInfo().getDeviceType()), datadogContext.getDeviceInfo().getDeviceName(), datadogContext.getDeviceInfo().getDeviceModel(), datadogContext.getDeviceInfo().getDeviceBrand(), datadogContext.getDeviceInfo().getArchitecture());
                ErrorEvent.Context context = new ErrorEvent.Context(this.$eventAttributes);
                ErrorEvent.Dd dd = new ErrorEvent.Dd(new ErrorEvent.DdSession(null, RumEventExtKt.toErrorSessionPrecondition(this.$rumContext.getSessionStartReason()), 1, null), new ErrorEvent.Configuration(Float.valueOf(this.this$0.getSampleRate$dd_sdk_android_rum_release()), null, 2, null), null, 4, null);
                String string6 = datadogContext.getService();
                String string7 = datadogContext.getVersion();
                return new ErrorEvent(l, (ErrorEvent.Application)object6, string6, string7, null, string3, errorEventSession, (ErrorEvent.ErrorEventSource)((Object)object4), (ErrorEvent.ErrorEventView)object5, (ErrorEvent.Usr)object2, (ErrorEvent.Connectivity)object3, null, this.$syntheticsAttribute, null, os, device, dd, context, (ErrorEvent.Action)((Object)errorSource), null, error, null, 2631696, null);
            }
        }, 2, null).onError((Function1<? super AdvancedRumMonitor, Unit>)((Function1)new Function1<AdvancedRumMonitor, Unit>(rumContext){
            final /* synthetic */ RumContext $rumContext;
            {
                this.$rumContext = $rumContext;
                super(1);
            }

            public final void invoke(@NotNull AdvancedRumMonitor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = this.$rumContext.getViewId();
                if (string == null) {
                    string = "";
                }
                it.eventDropped(string, StorageEvent.Error.INSTANCE);
            }
        })).onSuccess((Function1<? super AdvancedRumMonitor, Unit>)((Function1)new Function1<AdvancedRumMonitor, Unit>(rumContext){
            final /* synthetic */ RumContext $rumContext;
            {
                this.$rumContext = $rumContext;
                super(1);
            }

            public final void invoke(@NotNull AdvancedRumMonitor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = this.$rumContext.getViewId();
                if (string == null) {
                    string = "";
                }
                it.eventSent(string, StorageEvent.Error.INSTANCE);
            }
        })).submit();
        this.sent = true;
    }

    private final ErrorEvent.Provider resolveErrorProvider() {
        return this.firstPartyHostHeaderTypeResolver.isFirstPartyUrl(this.url) ? new ErrorEvent.Provider(this.resolveDomain(this.url), null, ErrorEvent.ProviderType.FIRST_PARTY, 2, null) : null;
    }

    private final String resolveDomain(String url) {
        String string;
        try {
            String string2 = new URL(url).getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            URL(url).host\n        }");
            string = string2;
        }
        catch (MalformedURLException e) {
            string = url;
        }
        return string;
    }

    private final ResourceEvent.Graphql resolveGraphQLAttributes(String operationType, String operationName, String payload, String variables) {
        Object object = operationType;
        if (object != null && (object = RumEventExtKt.toOperationType(object, this.sdkCore.getInternalLogger())) != null) {
            Object it = object;
            boolean bl = false;
            return new ResourceEvent.Graphql((ResourceEvent.OperationType)((Object)it), operationName, payload, variables);
        }
        return null;
    }

    public static final /* synthetic */ FeaturesContextResolver access$getFeaturesContextResolver$p(RumResourceScope $this) {
        return $this.featuresContextResolver;
    }

    public static final /* synthetic */ long access$resolveResourceDuration(RumResourceScope $this, Time eventTime) {
        return $this.resolveResourceDuration(eventTime);
    }

    public static final /* synthetic */ ResourceEvent.Provider access$resolveResourceProvider(RumResourceScope $this) {
        return $this.resolveResourceProvider();
    }

    public static final /* synthetic */ NetworkInfo access$getNetworkInfo$p(RumResourceScope $this) {
        return $this.networkInfo;
    }

    public static final /* synthetic */ ErrorEvent.Provider access$resolveErrorProvider(RumResourceScope $this) {
        return $this.resolveErrorProvider();
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/rum/internal/domain/scope/RumResourceScope$Companion;", "", "()V", "NEGATIVE_DURATION_WARNING_MESSAGE", "", "fromEvent", "Lcom/datadog/android/rum/internal/domain/scope/RumScope;", "parentScope", "sdkCore", "Lcom/datadog/android/core/InternalSdkCore;", "event", "Lcom/datadog/android/rum/internal/domain/scope/RumRawEvent$StartResource;", "firstPartyHostHeaderTypeResolver", "Lcom/datadog/android/core/internal/net/FirstPartyHostHeaderTypeResolver;", "timestampOffset", "", "featuresContextResolver", "Lcom/datadog/android/rum/internal/FeaturesContextResolver;", "sampleRate", "", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RumScope fromEvent(@NotNull RumScope parentScope, @NotNull InternalSdkCore sdkCore, @NotNull RumRawEvent.StartResource event, @NotNull FirstPartyHostHeaderTypeResolver firstPartyHostHeaderTypeResolver, long timestampOffset, @NotNull FeaturesContextResolver featuresContextResolver, float sampleRate) {
            Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
            Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)firstPartyHostHeaderTypeResolver, (String)"firstPartyHostHeaderTypeResolver");
            Intrinsics.checkNotNullParameter((Object)featuresContextResolver, (String)"featuresContextResolver");
            return new RumResourceScope(parentScope, sdkCore, event.getUrl(), event.getMethod(), event.getKey(), event.getEventTime(), event.getAttributes(), timestampOffset, firstPartyHostHeaderTypeResolver, featuresContextResolver, sampleRate);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

