/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum.internal;

import android.app.ApplicationExitInfo;
import androidx.annotation.RequiresApi;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.api.storage.EventBatchWriter;
import com.datadog.android.api.storage.EventType;
import com.datadog.android.core.InternalSdkCore;
import com.datadog.android.core.feature.event.ThreadDump;
import com.datadog.android.core.internal.persistence.Deserializer;
import com.datadog.android.rum.internal.DatadogLateCrashReporter;
import com.datadog.android.rum.internal.LateCrashReporter;
import com.datadog.android.rum.internal.anr.ANRException;
import com.datadog.android.rum.internal.anr.AndroidTraceParser;
import com.datadog.android.rum.internal.domain.event.RumEventDeserializer;
import com.datadog.android.rum.internal.domain.scope.RumEventExtKt;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.ViewEvent;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 <2\u00020\u0001:\u0001<B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00062\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070#H\u0017J&\u0010$\u001a\u00020\u001e2\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070#H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00100\u00112\u0006\u0010\u001f\u001a\u00020 H\u0003Jg\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u0001012\u0006\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020\u00152\u000e\u00105\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00112\u0006\u00106\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u00107J\u0010\u00108\u001a\u00020\r2\u0006\u00109\u001a\u00020\rH\u0002J\u0016\u0010:\u001a\u00020,*\u00020;2\b\u0010+\u001a\u0004\u0018\u00010\u0015H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000eR \u0010\u000f\u001a\u0004\u0018\u00010\u0010*\b\u0012\u0004\u0012\u00020\u00100\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\u00020\u001a*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006="}, d2={"Lcom/datadog/android/rum/internal/DatadogLateCrashReporter;", "Lcom/datadog/android/rum/internal/LateCrashReporter;", "sdkCore", "Lcom/datadog/android/core/InternalSdkCore;", "rumEventDeserializer", "Lcom/datadog/android/core/internal/persistence/Deserializer;", "Lcom/google/gson/JsonObject;", "", "androidTraceParser", "Lcom/datadog/android/rum/internal/anr/AndroidTraceParser;", "(Lcom/datadog/android/core/InternalSdkCore;Lcom/datadog/android/core/internal/persistence/Deserializer;Lcom/datadog/android/rum/internal/anr/AndroidTraceParser;)V", "isWithinSessionAvailability", "", "Lcom/datadog/android/rum/model/ViewEvent;", "(Lcom/datadog/android/rum/model/ViewEvent;)Z", "mainThread", "Lcom/datadog/android/core/feature/event/ThreadDump;", "", "getMainThread", "(Ljava/util/List;)Lcom/datadog/android/core/feature/event/ThreadDump;", "rumSessionId", "", "Lcom/datadog/android/api/context/DatadogContext;", "getRumSessionId", "(Lcom/datadog/android/api/context/DatadogContext;)Ljava/lang/String;", "sampleRate", "", "getSampleRate", "(Lcom/datadog/android/rum/model/ViewEvent;)F", "handleAnrCrash", "", "anrExitInfo", "Landroid/app/ApplicationExitInfo;", "lastRumViewEventJson", "rumWriter", "Lcom/datadog/android/api/storage/DataWriter;", "handleNdkCrashEvent", "event", "", "readThreadsDump", "resolveErrorEventFromViewEvent", "Lcom/datadog/android/rum/model/ErrorEvent;", "datadogContext", "sourceType", "Lcom/datadog/android/rum/model/ErrorEvent$SourceType;", "category", "Lcom/datadog/android/rum/model/ErrorEvent$Category;", "errorLogMessage", "timestamp", "", "timeSinceAppStartMs", "stacktrace", "errorType", "threadDumps", "viewEvent", "(Lcom/datadog/android/api/context/DatadogContext;Lcom/datadog/android/rum/model/ErrorEvent$SourceType;Lcom/datadog/android/rum/model/ErrorEvent$Category;Ljava/lang/String;JLjava/lang/Long;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lcom/datadog/android/rum/model/ViewEvent;)Lcom/datadog/android/rum/model/ErrorEvent;", "updateViewEvent", "lastViewEvent", "tryFromSource", "Lcom/datadog/android/rum/model/ErrorEvent$SourceType$Companion;", "Companion", "dd-sdk-android-rum_release"})
@SourceDebugExtension(value={"SMAP\nDatadogLateCrashReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatadogLateCrashReporter.kt\ncom/datadog/android/rum/internal/DatadogLateCrashReporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,343:1\n1549#2:344\n1620#2,3:345\n1549#2:348\n1620#2,3:349\n288#2,2:352\n*S KotlinDebug\n*F\n+ 1 DatadogLateCrashReporter.kt\ncom/datadog/android/rum/internal/DatadogLateCrashReporter\n*L\n176#1:344\n176#1:345,3\n248#1:348\n248#1:349,3\n302#1:352,2\n*E\n"})
public final class DatadogLateCrashReporter
implements LateCrashReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalSdkCore sdkCore;
    @NotNull
    private final Deserializer<JsonObject, Object> rumEventDeserializer;
    @NotNull
    private final AndroidTraceParser androidTraceParser;
    @NotNull
    public static final String INFO_RUM_FEATURE_NOT_REGISTERED = "RUM feature is not registered, won't report NDK crash info as RUM error.";
    @NotNull
    public static final String NDK_CRASH_EVENT_MISSING_MANDATORY_FIELDS = "RUM feature received a NDK crash event where one or more mandatory (timestamp, signalName, stacktrace, message, lastViewEvent) fields are either missing or have wrong type.";
    @NotNull
    public static final String MISSING_ANR_TRACE = "Last known exit reason has no trace information attached, cannot report fatal ANR.";
    private static final long VIEW_EVENT_AVAILABILITY_TIME_THRESHOLD = TimeUnit.HOURS.toMillis(4L);

    public DatadogLateCrashReporter(@NotNull InternalSdkCore sdkCore, @NotNull Deserializer<JsonObject, Object> rumEventDeserializer, @NotNull AndroidTraceParser androidTraceParser) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter(rumEventDeserializer, (String)"rumEventDeserializer");
        Intrinsics.checkNotNullParameter((Object)androidTraceParser, (String)"androidTraceParser");
        this.sdkCore = sdkCore;
        this.rumEventDeserializer = rumEventDeserializer;
        this.androidTraceParser = androidTraceParser;
    }

    public /* synthetic */ DatadogLateCrashReporter(InternalSdkCore internalSdkCore, Deserializer deserializer, AndroidTraceParser androidTraceParser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            deserializer = new RumEventDeserializer(internalSdkCore.getInternalLogger());
        }
        if ((n & 4) != 0) {
            androidTraceParser = new AndroidTraceParser(internalSdkCore.getInternalLogger());
        }
        this(internalSdkCore, (Deserializer<JsonObject, Object>)deserializer, androidTraceParser);
    }

    @Override
    public void handleNdkCrashEvent(@NotNull Map<?, ?> event, @NotNull DataWriter<Object> rumWriter) {
        ViewEvent lastViewEvent;
        ViewEvent viewEvent;
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Intrinsics.checkNotNullParameter(rumWriter, (String)"rumWriter");
        FeatureScope rumFeature2 = this.sdkCore.getFeature("rum");
        if (rumFeature2 == null) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.INFO, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)handleNdkCrashEvent.1.INSTANCE, null, (boolean)false, null, (int)56, null);
            return;
        }
        Object obj = event.get("sourceType");
        String sourceType = obj instanceof String ? (String)obj : null;
        Object obj2 = event.get("timestamp");
        Long timestamp = obj2 instanceof Long ? (Long)obj2 : null;
        Object obj3 = event.get("timeSinceAppStartMs");
        Long timeSinceAppStartMs = obj3 instanceof Long ? (Long)obj3 : null;
        Object obj4 = event.get("signalName");
        String signalName = obj4 instanceof String ? (String)obj4 : null;
        Object obj5 = event.get("stacktrace");
        String stacktrace = obj5 instanceof String ? (String)obj5 : null;
        Object obj6 = event.get("message");
        String errorLogMessage = obj6 instanceof String ? (String)obj6 : null;
        Object obj7 = event.get("lastViewEvent");
        JsonObject jsonObject = obj7 instanceof JsonObject ? (JsonObject)obj7 : null;
        if (jsonObject != null) {
            JsonObject it = jsonObject;
            boolean bl = false;
            Object object = this.rumEventDeserializer.deserialize((Object)it);
            viewEvent = object instanceof ViewEvent ? (ViewEvent)object : null;
        } else {
            viewEvent = lastViewEvent = null;
        }
        if (timestamp == null || signalName == null || stacktrace == null || errorLogMessage == null || lastViewEvent == null) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)handleNdkCrashEvent.2.INSTANCE, null, (boolean)false, null, (int)56, null);
            return;
        }
        FeatureScope.DefaultImpls.withWriteContext$default((FeatureScope)rumFeature2, (boolean)false, (Function2)((Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(this, sourceType, errorLogMessage, timestamp, timeSinceAppStartMs, stacktrace, signalName, lastViewEvent, rumWriter){
            final /* synthetic */ DatadogLateCrashReporter this$0;
            final /* synthetic */ String $sourceType;
            final /* synthetic */ String $errorLogMessage;
            final /* synthetic */ Long $timestamp;
            final /* synthetic */ Long $timeSinceAppStartMs;
            final /* synthetic */ String $stacktrace;
            final /* synthetic */ String $signalName;
            final /* synthetic */ ViewEvent $lastViewEvent;
            final /* synthetic */ DataWriter<Object> $rumWriter;
            {
                this.this$0 = $receiver;
                this.$sourceType = $sourceType;
                this.$errorLogMessage = $errorLogMessage;
                this.$timestamp = $timestamp;
                this.$timeSinceAppStartMs = $timeSinceAppStartMs;
                this.$stacktrace = $stacktrace;
                this.$signalName = $signalName;
                this.$lastViewEvent = $lastViewEvent;
                this.$rumWriter = $rumWriter;
                super(2);
            }

            public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                ErrorEvent toSendErrorEvent = DatadogLateCrashReporter.access$resolveErrorEventFromViewEvent(this.this$0, datadogContext, DatadogLateCrashReporter.access$tryFromSource(this.this$0, ErrorEvent.SourceType.Companion, this.$sourceType), ErrorEvent.Category.EXCEPTION, this.$errorLogMessage, this.$timestamp, this.$timeSinceAppStartMs, this.$stacktrace, this.$signalName, null, this.$lastViewEvent);
                this.$rumWriter.write(eventBatchWriter, (Object)toSendErrorEvent, EventType.CRASH);
                if (DatadogLateCrashReporter.access$isWithinSessionAvailability(this.this$0, this.$lastViewEvent)) {
                    ViewEvent updatedViewEvent = DatadogLateCrashReporter.access$updateViewEvent(this.this$0, this.$lastViewEvent);
                    this.$rumWriter.write(eventBatchWriter, (Object)updatedViewEvent, EventType.CRASH);
                }
            }
        }), (int)1, null);
    }

    @Override
    @RequiresApi(value=30)
    public void handleAnrCrash(@NotNull ApplicationExitInfo anrExitInfo, @NotNull JsonObject lastRumViewEventJson, @NotNull DataWriter<Object> rumWriter) {
        Intrinsics.checkNotNullParameter((Object)anrExitInfo, (String)"anrExitInfo");
        Intrinsics.checkNotNullParameter((Object)lastRumViewEventJson, (String)"lastRumViewEventJson");
        Intrinsics.checkNotNullParameter(rumWriter, (String)"rumWriter");
        Object object = this.rumEventDeserializer.deserialize((Object)lastRumViewEventJson);
        ViewEvent viewEvent = object instanceof ViewEvent ? (ViewEvent)object : null;
        if (viewEvent == null) {
            return;
        }
        ViewEvent lastViewEvent = viewEvent;
        long lastKnownViewStartedAt = lastViewEvent.getDate();
        if (anrExitInfo.getTimestamp() > lastKnownViewStartedAt) {
            FeatureScope rumFeature2 = this.sdkCore.getFeature("rum");
            if (rumFeature2 == null) {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)handleAnrCrash.1.INSTANCE, null, (boolean)false, null, (int)56, null);
                return;
            }
            FeatureScope.DefaultImpls.withWriteContext$default((FeatureScope)rumFeature2, (boolean)false, (Function2)((Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(lastViewEvent, this, anrExitInfo, rumWriter){
                final /* synthetic */ ViewEvent $lastViewEvent;
                final /* synthetic */ DatadogLateCrashReporter this$0;
                final /* synthetic */ ApplicationExitInfo $anrExitInfo;
                final /* synthetic */ DataWriter<Object> $rumWriter;
                {
                    this.$lastViewEvent = $lastViewEvent;
                    this.this$0 = $receiver;
                    this.$anrExitInfo = $anrExitInfo;
                    this.$rumWriter = $rumWriter;
                    super(2);
                }

                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    String string;
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    if (Intrinsics.areEqual((Object)this.$lastViewEvent.getSession().getId(), (Object)DatadogLateCrashReporter.access$getRumSessionId(this.this$0, datadogContext))) {
                        return;
                    }
                    Long lastFatalAnrSent = DatadogLateCrashReporter.access$getSdkCore$p(this.this$0).getLastFatalAnrSent();
                    Long l = lastFatalAnrSent;
                    if (l != null && this.$anrExitInfo.getTimestamp() == l.longValue()) {
                        return;
                    }
                    List threadDumps = DatadogLateCrashReporter.access$readThreadsDump(this.this$0, this.$anrExitInfo);
                    if (threadDumps.isEmpty()) {
                        return;
                    }
                    long l2 = this.$anrExitInfo.getTimestamp();
                    ThreadDump threadDump = DatadogLateCrashReporter.access$getMainThread(this.this$0, threadDumps);
                    String string2 = threadDump != null ? threadDump.getStack() : null;
                    if (string2 == null) {
                        string2 = "";
                    }
                    if ((string = ANRException.class.getCanonicalName()) == null) {
                        string = "";
                    }
                    ErrorEvent toSendErrorEvent = DatadogLateCrashReporter.access$resolveErrorEventFromViewEvent(this.this$0, datadogContext, ErrorEvent.SourceType.ANDROID, ErrorEvent.Category.ANR, "Application Not Responding", l2, null, string2, string, threadDumps, this.$lastViewEvent);
                    this.$rumWriter.write(eventBatchWriter, (Object)toSendErrorEvent, EventType.CRASH);
                    if (DatadogLateCrashReporter.access$isWithinSessionAvailability(this.this$0, this.$lastViewEvent)) {
                        ViewEvent updatedViewEvent = DatadogLateCrashReporter.access$updateViewEvent(this.this$0, this.$lastViewEvent);
                        this.$rumWriter.write(eventBatchWriter, (Object)updatedViewEvent, EventType.CRASH);
                    }
                    DatadogLateCrashReporter.access$getSdkCore$p(this.this$0).writeLastFatalAnrSent(this.$anrExitInfo.getTimestamp());
                }
            }), (int)1, null);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ErrorEvent resolveErrorEventFromViewEvent(DatadogContext datadogContext, ErrorEvent.SourceType sourceType, ErrorEvent.Category category, String errorLogMessage, long timestamp, Long timeSinceAppStartMs, String stacktrace, String errorType, List<ThreadDump> threadDumps, ViewEvent viewEvent) {
        v0 = viewEvent.getConnectivity();
        if (v0 != null) {
            it = v0;
            $i$a$-let-DatadogLateCrashReporter$resolveErrorEventFromViewEvent$connectivity$1 = false;
            connectivityStatus = ErrorEvent.Status.valueOf(it.getStatus().name());
            v1 = it.getInterfaces();
            if (v1 != null) {
                $this$map$iv = v1;
                $i$f$map = false;
                var20_17 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var25_23 /* !! */  = (ViewEvent.Interface)item$iv$iv;
                    var26_24 = destination$iv$iv;
                    $i$a$-map-DatadogLateCrashReporter$resolveErrorEventFromViewEvent$connectivity$1$connectivityInterfaces$1 = false;
                    var26_24.add(ErrorEvent.Interface.valueOf(it.name()));
                }
                v2 = (List)destination$iv$iv;
            } else {
                v2 = null;
            }
            connectivityInterfaces = v2;
            v3 = it.getCellular();
            v4 = it.getCellular();
            cellular = new ErrorEvent.Cellular(v3 != null ? v3.getTechnology() : null, v4 != null ? v4.getCarrierName() : null);
            v5 = new ErrorEvent.Connectivity(connectivityStatus, connectivityInterfaces, null, cellular, 4, null);
        } else {
            v5 = connectivity = null;
        }
        if ((v6 = viewEvent.getContext()) == null || (v6 = v6.getAdditionalProperties()) == null) {
            v6 = additionalProperties = (Map)new LinkedHashMap<K, V>();
        }
        if ((v7 = viewEvent.getUsr()) == null || (v7 = v7.getAdditionalProperties()) == null) {
            v7 = new LinkedHashMap<K, V>();
        }
        additionalUserProperties = v7;
        v8 = user = viewEvent.getUsr();
        if ((v8 != null ? v8.getId() : null) != null) ** GOTO lbl-1000
        v9 = user;
        if ((v9 != null ? v9.getName() : null) != null) ** GOTO lbl-1000
        v10 = user;
        if ((v10 != null ? v10.getEmail() : null) != null || additionalUserProperties.isEmpty() == false) lbl-1000:
        // 3 sources

        {
            v11 = true;
        } else {
            v11 = false;
        }
        hasUserInfo = v11;
        deviceInfo = datadogContext.getDeviceInfo();
        var18_15 = timestamp + datadogContext.getTime().getServerTimeOffsetMs();
        var20_17 = datadogContext.getAppBuildId();
        var21_18 = new ErrorEvent.Application(viewEvent.getApplication().getId());
        var22_20 = viewEvent.getService();
        var23_21 = new ErrorEvent.ErrorEventSession(viewEvent.getSession().getId(), ErrorEvent.ErrorEventSessionType.USER, null, 4, null);
        v12 /* !! */  = viewEvent.getSource();
        if (v12 /* !! */  != null && (v12 /* !! */  = v12 /* !! */ .toJson()) != null && (v12 /* !! */  = v12 /* !! */ .getAsString()) != null) {
            it /* !! */  = v12 /* !! */ ;
            $i$a$-let-DatadogLateCrashReporter$resolveErrorEventFromViewEvent$1 = false;
            v13 = RumEventExtKt.tryFromSource(ErrorEvent.ErrorEventSource.Companion, (String)it /* !! */ , this.sdkCore.getInternalLogger());
        } else {
            v13 = null;
        }
        var24_22 = v13;
        var26_24 = viewEvent.getView().getId();
        var27_26 = viewEvent.getView().getName();
        var28_27 = viewEvent.getView().getReferrer();
        var29_28 = viewEvent.getView().getUrl();
        var25_23 /* !! */  = new ErrorEvent.ErrorEventView((String)var26_24, (String)var28_27, (String)var29_28, (String)var27_26, null, 16, null);
        if (!hasUserInfo) {
            v14 = null;
        } else {
            v15 = user;
            v16 = user;
            v17 = user;
            v14 = new ErrorEvent.Usr(v15 != null ? v15.getId() : null, v16 != null ? v16.getName() : null, v17 != null ? v17.getEmail() : null, (Map<String, Object>)additionalUserProperties);
        }
        var26_24 = v14;
        var27_26 = new ErrorEvent.Os(deviceInfo.getOsName(), deviceInfo.getOsVersion(), null, deviceInfo.getOsMajorVersion(), 4, null);
        var28_27 = new ErrorEvent.Device(RumEventExtKt.toErrorSchemaType(deviceInfo.getDeviceType()), deviceInfo.getDeviceName(), deviceInfo.getDeviceModel(), deviceInfo.getDeviceBrand(), deviceInfo.getArchitecture());
        var29_28 = new ErrorEvent.Dd(new ErrorEvent.DdSession(null, null, 3, null), new ErrorEvent.Configuration(Float.valueOf(this.getSampleRate(viewEvent)), null, 2, null), null, 4, null);
        var30_33 = new ErrorEvent.Context((Map<String, Object>)additionalProperties);
        var32_34 /* !! */  = ErrorEvent.ErrorSource.SOURCE;
        v18 = threadDumps;
        if (v18 != null) {
            $this$map$iv = v18;
            $i$f$map = false;
            var36_37 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var41_42 = (ThreadDump)item$iv$iv;
                var43_44 = destination$iv$iv;
                $i$a$-map-DatadogLateCrashReporter$resolveErrorEventFromViewEvent$2 = false;
                var43_44.add(new ErrorEvent.Thread(it.getName(), it.getCrashed(), it.getStack(), it.getState()));
            }
            v19 = (List)destination$iv$iv;
        } else {
            v19 = null;
        }
        var33_45 = v19;
        var31_46 = new ErrorEvent.Error(null, errorLogMessage, var32_34 /* !! */ , stacktrace, null, true, null, errorType, category, null, null, sourceType, null, var33_45, null, null, null, timeSinceAppStartMs, 120401, null);
        var32_34 /* !! */  = viewEvent.getVersion();
        return new ErrorEvent(var18_15, var21_18, var22_20, (String)var32_34 /* !! */ , null, (String)var20_17, var23_21, var24_22, (ErrorEvent.ErrorEventView)var25_23 /* !! */ , (ErrorEvent.Usr)var26_24, connectivity, null, null, null, (ErrorEvent.Os)var27_26, (ErrorEvent.Device)var28_27, (ErrorEvent.Dd)var29_28, var30_33, null, null, var31_46, null, 2897936, null);
    }

    @RequiresApi(value=30)
    private final List<ThreadDump> readThreadsDump(ApplicationExitInfo anrExitInfo) {
        InputStream traceInputStream = anrExitInfo.getTraceInputStream();
        if (traceInputStream == null) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)readThreadsDump.1.INSTANCE, null, (boolean)false, null, (int)56, null);
            return CollectionsKt.emptyList();
        }
        return this.androidTraceParser.parse$dd_sdk_android_rum_release(traceInputStream);
    }

    private final ViewEvent updateViewEvent(ViewEvent lastViewEvent) {
        ViewEvent.Crash currentCrash = lastViewEvent.getView().getCrash();
        ViewEvent.Crash crash = currentCrash;
        if (crash == null || (crash = crash.copy(currentCrash.getCount() + 1L)) == null) {
            crash = new ViewEvent.Crash(1L);
        }
        ViewEvent.Crash newCrash = crash;
        return ViewEvent.copy$default(lastViewEvent, 0L, null, null, null, null, null, null, null, ViewEvent.ViewEventView.copy$default(lastViewEvent.getView(), null, null, null, null, null, null, 0L, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, null, null, newCrash, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -142606337, 1023, null), null, null, null, null, null, null, null, ViewEvent.Dd.copy$default(lastViewEvent.getDd(), null, null, null, lastViewEvent.getDd().getDocumentVersion() + 1L, null, null, 55, null), null, null, null, null, 0x1EFEFF, null);
    }

    private final float getSampleRate(ViewEvent $this$sampleRate) {
        Object object = $this$sampleRate.getDd().getConfiguration();
        return object != null && (object = ((ViewEvent.Configuration)object).getSessionSampleRate()) != null ? ((Number)object).floatValue() : 0.0f;
    }

    private final boolean isWithinSessionAvailability(ViewEvent $this$isWithinSessionAvailability) {
        long now = System.currentTimeMillis();
        long sessionsTimeDifference = now - $this$isWithinSessionAvailability.getDate();
        return sessionsTimeDifference < VIEW_EVENT_AVAILABILITY_TIME_THRESHOLD;
    }

    private final ThreadDump getMainThread(List<ThreadDump> $this$mainThread) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$mainThread;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ThreadDump it = (ThreadDump)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"main")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final ErrorEvent.SourceType tryFromSource(ErrorEvent.SourceType.Companion $this$tryFromSource, String sourceType) {
        ErrorEvent.SourceType sourceType2;
        if (sourceType != null) {
            ErrorEvent.SourceType sourceType3;
            try {
                sourceType3 = ErrorEvent.SourceType.Companion.fromJson(sourceType);
            }
            catch (NoSuchElementException e) {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.TELEMETRY, (Function0)((Function0)new Function0<String>(sourceType){
                    final /* synthetic */ String $sourceType;
                    {
                        this.$sourceType = $sourceType;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Error parsing source type from NDK crash event: " + this.$sourceType;
                    }
                }), (Throwable)e, (boolean)false, null, (int)48, null);
                sourceType3 = ErrorEvent.SourceType.NDK;
            }
            sourceType2 = sourceType3;
        } else {
            sourceType2 = ErrorEvent.SourceType.NDK;
        }
        return sourceType2;
    }

    private final String getRumSessionId(DatadogContext $this$rumSessionId) {
        Object v;
        Map map = (Map)$this$rumSessionId.getFeaturesContext().get("rum");
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        return (v = map.get("session_id")) instanceof String ? (String)v : null;
    }

    public static final /* synthetic */ ErrorEvent access$resolveErrorEventFromViewEvent(DatadogLateCrashReporter $this, DatadogContext datadogContext, ErrorEvent.SourceType sourceType, ErrorEvent.Category category, String errorLogMessage, long timestamp, Long timeSinceAppStartMs, String stacktrace, String errorType, List threadDumps, ViewEvent viewEvent) {
        return $this.resolveErrorEventFromViewEvent(datadogContext, sourceType, category, errorLogMessage, timestamp, timeSinceAppStartMs, stacktrace, errorType, threadDumps, viewEvent);
    }

    public static final /* synthetic */ ErrorEvent.SourceType access$tryFromSource(DatadogLateCrashReporter $this, ErrorEvent.SourceType.Companion $receiver, String sourceType) {
        return $this.tryFromSource($receiver, sourceType);
    }

    public static final /* synthetic */ boolean access$isWithinSessionAvailability(DatadogLateCrashReporter $this, ViewEvent $receiver) {
        return $this.isWithinSessionAvailability($receiver);
    }

    public static final /* synthetic */ ViewEvent access$updateViewEvent(DatadogLateCrashReporter $this, ViewEvent lastViewEvent) {
        return $this.updateViewEvent(lastViewEvent);
    }

    public static final /* synthetic */ String access$getRumSessionId(DatadogLateCrashReporter $this, DatadogContext $receiver) {
        return $this.getRumSessionId($receiver);
    }

    public static final /* synthetic */ InternalSdkCore access$getSdkCore$p(DatadogLateCrashReporter $this) {
        return $this.sdkCore;
    }

    public static final /* synthetic */ List access$readThreadsDump(DatadogLateCrashReporter $this, ApplicationExitInfo anrExitInfo) {
        return $this.readThreadsDump(anrExitInfo);
    }

    public static final /* synthetic */ ThreadDump access$getMainThread(DatadogLateCrashReporter $this, List $receiver) {
        return $this.getMainThread($receiver);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/rum/internal/DatadogLateCrashReporter$Companion;", "", "()V", "INFO_RUM_FEATURE_NOT_REGISTERED", "", "MISSING_ANR_TRACE", "NDK_CRASH_EVENT_MISSING_MANDATORY_FIELDS", "VIEW_EVENT_AVAILABILITY_TIME_THRESHOLD", "", "getVIEW_EVENT_AVAILABILITY_TIME_THRESHOLD$dd_sdk_android_rum_release", "()J", "dd-sdk-android-rum_release"})
    public static final class Companion {
        private Companion() {
        }

        public final long getVIEW_EVENT_AVAILABILITY_TIME_THRESHOLD$dd_sdk_android_rum_release() {
            return VIEW_EVENT_AVAILABILITY_TIME_THRESHOLD;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

