/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.rum;

import androidx.annotation.FloatRange;
import com.datadog.android.event.EventMapper;
import com.datadog.android.rum.RumSessionListener;
import com.datadog.android.rum.configuration.VitalsUpdateFrequency;
import com.datadog.android.rum.event.ViewEventMapper;
import com.datadog.android.rum.internal.RumFeature;
import com.datadog.android.rum.internal.instrumentation.MainLooperLongTaskStrategy;
import com.datadog.android.rum.internal.tracking.NoOpInteractionPredicate;
import com.datadog.android.rum.model.ActionEvent;
import com.datadog.android.rum.model.ErrorEvent;
import com.datadog.android.rum.model.LongTaskEvent;
import com.datadog.android.rum.model.ResourceEvent;
import com.datadog.android.rum.tracking.InteractionPredicate;
import com.datadog.android.rum.tracking.ViewAttributesProvider;
import com.datadog.android.rum.tracking.ViewTrackingStrategy;
import com.datadog.android.telemetry.model.TelemetryConfigurationEvent;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0016B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\fJ\u000e\u0010\r\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u000eJ\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/datadog/android/rum/RumConfiguration;", "", "applicationId", "", "featureConfiguration", "Lcom/datadog/android/rum/internal/RumFeature$Configuration;", "(Ljava/lang/String;Lcom/datadog/android/rum/internal/RumFeature$Configuration;)V", "getApplicationId$dd_sdk_android_rum_release", "()Ljava/lang/String;", "getFeatureConfiguration$dd_sdk_android_rum_release", "()Lcom/datadog/android/rum/internal/RumFeature$Configuration;", "component1", "component1$dd_sdk_android_rum_release", "component2", "component2$dd_sdk_android_rum_release", "copy", "equals", "", "other", "hashCode", "", "toString", "Builder", "dd-sdk-android-rum_release"})
public final class RumConfiguration {
    @NotNull
    private final String applicationId;
    @NotNull
    private final RumFeature.Configuration featureConfiguration;

    public RumConfiguration(@NotNull String applicationId, @NotNull RumFeature.Configuration featureConfiguration) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)featureConfiguration, (String)"featureConfiguration");
        this.applicationId = applicationId;
        this.featureConfiguration = featureConfiguration;
    }

    @NotNull
    public final String getApplicationId$dd_sdk_android_rum_release() {
        return this.applicationId;
    }

    @NotNull
    public final RumFeature.Configuration getFeatureConfiguration$dd_sdk_android_rum_release() {
        return this.featureConfiguration;
    }

    @NotNull
    public final String component1$dd_sdk_android_rum_release() {
        return this.applicationId;
    }

    @NotNull
    public final RumFeature.Configuration component2$dd_sdk_android_rum_release() {
        return this.featureConfiguration;
    }

    @NotNull
    public final RumConfiguration copy(@NotNull String applicationId, @NotNull RumFeature.Configuration featureConfiguration) {
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)featureConfiguration, (String)"featureConfiguration");
        return new RumConfiguration(applicationId, featureConfiguration);
    }

    public static /* synthetic */ RumConfiguration copy$default(RumConfiguration rumConfiguration, String string, RumFeature.Configuration configuration, int n, Object object) {
        if ((n & 1) != 0) {
            string = rumConfiguration.applicationId;
        }
        if ((n & 2) != 0) {
            configuration = rumConfiguration.featureConfiguration;
        }
        return rumConfiguration.copy(string, configuration);
    }

    @NotNull
    public String toString() {
        return "RumConfiguration(applicationId=" + this.applicationId + ", featureConfiguration=" + this.featureConfiguration + ")";
    }

    public int hashCode() {
        int result = this.applicationId.hashCode();
        result = result * 31 + this.featureConfiguration.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RumConfiguration)) {
            return false;
        }
        RumConfiguration rumConfiguration = (RumConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.applicationId, (Object)rumConfiguration.applicationId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.featureConfiguration, (Object)rumConfiguration.featureConfiguration);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0000J\u0014\u0010\n\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ!\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0014\u0010\u0012\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00130\fJ\u0014\u0010\u0014\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00150\fJ\u0014\u0010\u0016\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00170\fJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00002\b\b\u0001\u0010\u001c\u001a\u00020\u001dJ\u001b\u0010\u001e\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u001f0\fH\u0000\u00a2\u0006\u0002\b J\u0010\u0010!\u001a\u00020\u00002\b\b\u0001\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)J\u0012\u0010+\u001a\u00020\u00002\b\b\u0002\u0010,\u001a\u00020-H\u0007J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)J'\u0010/\u001a\u00020\u00002\u000e\b\u0002\u00100\u001a\b\u0012\u0004\u0012\u000202012\b\b\u0002\u00103\u001a\u000204H\u0007\u00a2\u0006\u0002\u00105J\u000e\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u0003J\u0010\u00108\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010:R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/datadog/android/rum/RumConfiguration$Builder;", "", "applicationId", "", "(Ljava/lang/String;)V", "rumConfig", "Lcom/datadog/android/rum/internal/RumFeature$Configuration;", "build", "Lcom/datadog/android/rum/RumConfiguration;", "disableUserInteractionTracking", "setActionEventMapper", "eventMapper", "Lcom/datadog/android/event/EventMapper;", "Lcom/datadog/android/rum/model/ActionEvent;", "setAdditionalConfiguration", "additionalConfig", "", "setAdditionalConfiguration$dd_sdk_android_rum_release", "setErrorEventMapper", "Lcom/datadog/android/rum/model/ErrorEvent;", "setLongTaskEventMapper", "Lcom/datadog/android/rum/model/LongTaskEvent;", "setResourceEventMapper", "Lcom/datadog/android/rum/model/ResourceEvent;", "setSessionListener", "sessionListener", "Lcom/datadog/android/rum/RumSessionListener;", "setSessionSampleRate", "sampleRate", "", "setTelemetryConfigurationEventMapper", "Lcom/datadog/android/telemetry/model/TelemetryConfigurationEvent;", "setTelemetryConfigurationEventMapper$dd_sdk_android_rum_release", "setTelemetrySampleRate", "setViewEventMapper", "Lcom/datadog/android/rum/event/ViewEventMapper;", "setVitalsUpdateFrequency", "frequency", "Lcom/datadog/android/rum/configuration/VitalsUpdateFrequency;", "trackBackgroundEvents", "enabled", "", "trackFrustrations", "trackLongTasks", "longTaskThresholdMs", "", "trackNonFatalAnrs", "trackUserInteractions", "touchTargetExtraAttributesProviders", "", "Lcom/datadog/android/rum/tracking/ViewAttributesProvider;", "interactionPredicate", "Lcom/datadog/android/rum/tracking/InteractionPredicate;", "([Lcom/datadog/android/rum/tracking/ViewAttributesProvider;Lcom/datadog/android/rum/tracking/InteractionPredicate;)Lcom/datadog/android/rum/RumConfiguration$Builder;", "useCustomEndpoint", "endpoint", "useViewTrackingStrategy", "strategy", "Lcom/datadog/android/rum/tracking/ViewTrackingStrategy;", "dd-sdk-android-rum_release"})
    @SourceDebugExtension(value={"SMAP\nRumConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RumConfiguration.kt\ncom/datadog/android/rum/RumConfiguration$Builder\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,305:1\n26#2:306\n*S KotlinDebug\n*F\n+ 1 RumConfiguration.kt\ncom/datadog/android/rum/RumConfiguration$Builder\n*L\n81#1:306\n*E\n"})
    public static final class Builder {
        @NotNull
        private final String applicationId;
        @NotNull
        private RumFeature.Configuration rumConfig;

        public Builder(@NotNull String applicationId) {
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            this.applicationId = applicationId;
            this.rumConfig = RumFeature.Companion.getDEFAULT_RUM_CONFIG$dd_sdk_android_rum_release();
        }

        @NotNull
        public final Builder setSessionSampleRate(@FloatRange(from=0.0, to=100.0) float sampleRate) {
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, sampleRate, 0.0f, 0.0f, false, null, null, null, null, null, null, null, null, null, null, false, false, false, null, null, null, 0x1FFFFD, null);
            return this;
        }

        @NotNull
        public final Builder setTelemetrySampleRate(@FloatRange(from=0.0, to=100.0) float sampleRate) {
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, sampleRate, 0.0f, false, null, null, null, null, null, null, null, null, null, null, false, false, false, null, null, null, 0x1FFFFB, null);
            return this;
        }

        @JvmOverloads
        @NotNull
        public final Builder trackUserInteractions(@NotNull ViewAttributesProvider[] touchTargetExtraAttributesProviders, @NotNull InteractionPredicate interactionPredicate) {
            Intrinsics.checkNotNullParameter((Object)touchTargetExtraAttributesProviders, (String)"touchTargetExtraAttributesProviders");
            Intrinsics.checkNotNullParameter((Object)interactionPredicate, (String)"interactionPredicate");
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, 0.0f, 0.0f, false, ArraysKt.toList((Object[])touchTargetExtraAttributesProviders), interactionPredicate, null, null, null, null, null, null, null, null, false, false, false, null, null, null, 0x1FFF9F, null);
            return this;
        }

        public static /* synthetic */ Builder trackUserInteractions$default(Builder builder, ViewAttributesProvider[] viewAttributesProviderArray, InteractionPredicate interactionPredicate, int n, Object object) {
            if ((n & 1) != 0) {
                boolean $i$f$emptyArray = false;
                viewAttributesProviderArray = new ViewAttributesProvider[]{};
            }
            if ((n & 2) != 0) {
                interactionPredicate = new NoOpInteractionPredicate();
            }
            return builder.trackUserInteractions(viewAttributesProviderArray, interactionPredicate);
        }

        @NotNull
        public final Builder disableUserInteractionTracking() {
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, 0.0f, 0.0f, false, null, null, null, null, null, null, null, null, null, null, false, false, false, null, null, null, 0x1FFFEF, null);
            return this;
        }

        @NotNull
        public final Builder useViewTrackingStrategy(@Nullable ViewTrackingStrategy strategy) {
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, 0.0f, 0.0f, false, null, null, strategy, null, null, null, null, null, null, null, false, false, false, null, null, null, 0x1FFF7F, null);
            return this;
        }

        @JvmOverloads
        @NotNull
        public final Builder trackLongTasks(long longTaskThresholdMs) {
            MainLooperLongTaskStrategy strategy = longTaskThresholdMs > 0L ? new MainLooperLongTaskStrategy(longTaskThresholdMs) : null;
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, 0.0f, 0.0f, false, null, null, null, strategy, null, null, null, null, null, null, false, false, false, null, null, null, 0x1FFEFF, null);
            return this;
        }

        public static /* synthetic */ Builder trackLongTasks$default(Builder builder, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = 100L;
            }
            return builder.trackLongTasks(l);
        }

        @NotNull
        public final Builder trackNonFatalAnrs(boolean enabled) {
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, 0.0f, 0.0f, false, null, null, null, null, null, null, null, null, null, null, false, false, enabled, null, null, null, 0x1DFFFF, null);
            return this;
        }

        @NotNull
        public final Builder setViewEventMapper(@NotNull ViewEventMapper eventMapper) {
            Intrinsics.checkNotNullParameter((Object)eventMapper, (String)"eventMapper");
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, 0.0f, 0.0f, false, null, null, null, null, eventMapper, null, null, null, null, null, false, false, false, null, null, null, 0x1FFDFF, null);
            return this;
        }

        @NotNull
        public final Builder setResourceEventMapper(@NotNull EventMapper<ResourceEvent> eventMapper) {
            Intrinsics.checkNotNullParameter(eventMapper, (String)"eventMapper");
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, 0.0f, 0.0f, false, null, null, null, null, null, null, eventMapper, null, null, null, false, false, false, null, null, null, 0x1FF7FF, null);
            return this;
        }

        @NotNull
        public final Builder setActionEventMapper(@NotNull EventMapper<ActionEvent> eventMapper) {
            Intrinsics.checkNotNullParameter(eventMapper, (String)"eventMapper");
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, 0.0f, 0.0f, false, null, null, null, null, null, null, null, eventMapper, null, null, false, false, false, null, null, null, 0x1FEFFF, null);
            return this;
        }

        @NotNull
        public final Builder setErrorEventMapper(@NotNull EventMapper<ErrorEvent> eventMapper) {
            Intrinsics.checkNotNullParameter(eventMapper, (String)"eventMapper");
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, 0.0f, 0.0f, false, null, null, null, null, null, eventMapper, null, null, null, null, false, false, false, null, null, null, 0x1FFBFF, null);
            return this;
        }

        @NotNull
        public final Builder setLongTaskEventMapper(@NotNull EventMapper<LongTaskEvent> eventMapper) {
            Intrinsics.checkNotNullParameter(eventMapper, (String)"eventMapper");
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, 0.0f, 0.0f, false, null, null, null, null, null, null, null, null, eventMapper, null, false, false, false, null, null, null, 0x1FDFFF, null);
            return this;
        }

        @NotNull
        public final Builder trackBackgroundEvents(boolean enabled) {
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, 0.0f, 0.0f, false, null, null, null, null, null, null, null, null, null, null, enabled, false, false, null, null, null, 0x1F7FFF, null);
            return this;
        }

        @NotNull
        public final Builder trackFrustrations(boolean enabled) {
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, 0.0f, 0.0f, false, null, null, null, null, null, null, null, null, null, null, false, enabled, false, null, null, null, 0x1EFFFF, null);
            return this;
        }

        @NotNull
        public final Builder setVitalsUpdateFrequency(@NotNull VitalsUpdateFrequency frequency) {
            Intrinsics.checkNotNullParameter((Object)((Object)frequency), (String)"frequency");
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, 0.0f, 0.0f, false, null, null, null, null, null, null, null, null, null, null, false, false, false, frequency, null, null, 0x1BFFFF, null);
            return this;
        }

        @NotNull
        public final Builder useCustomEndpoint(@NotNull String endpoint) {
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, endpoint, 0.0f, 0.0f, 0.0f, false, null, null, null, null, null, null, null, null, null, null, false, false, false, null, null, null, 0x1FFFFE, null);
            return this;
        }

        @NotNull
        public final Builder setSessionListener(@NotNull RumSessionListener sessionListener) {
            Intrinsics.checkNotNullParameter((Object)sessionListener, (String)"sessionListener");
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, 0.0f, 0.0f, false, null, null, null, null, null, null, null, null, null, null, false, false, false, null, sessionListener, null, 0x17FFFF, null);
            return this;
        }

        @NotNull
        public final RumConfiguration build() {
            Float f;
            Object object = this.rumConfig.getAdditionalConfig().get("_dd.telemetry.configuration_sample_rate");
            if (object != null) {
                Object it = object;
                boolean bl = false;
                f = it instanceof Number ? Float.valueOf(((Number)it).floatValue()) : null;
            } else {
                f = null;
            }
            Float telemetryConfigurationSampleRate = f;
            RumFeature.Configuration configuration = this.rumConfig;
            String string = this.applicationId;
            boolean bl = false;
            RumFeature.Configuration configuration2 = telemetryConfigurationSampleRate != null ? RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, 0.0f, telemetryConfigurationSampleRate.floatValue(), false, null, null, null, null, null, null, null, null, null, null, false, false, false, null, null, null, 0x1FFFF7, null) : this.rumConfig;
            String string2 = string;
            return new RumConfiguration(string2, configuration2);
        }

        @NotNull
        public final Builder setTelemetryConfigurationEventMapper$dd_sdk_android_rum_release(@NotNull EventMapper<TelemetryConfigurationEvent> eventMapper) {
            Intrinsics.checkNotNullParameter(eventMapper, (String)"eventMapper");
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, 0.0f, 0.0f, false, null, null, null, null, null, null, null, null, null, eventMapper, false, false, false, null, null, null, 0x1FBFFF, null);
            return this;
        }

        @NotNull
        public final Builder setAdditionalConfiguration$dd_sdk_android_rum_release(@NotNull Map<String, ? extends Object> additionalConfig) {
            Intrinsics.checkNotNullParameter(additionalConfig, (String)"additionalConfig");
            this.rumConfig = RumFeature.Configuration.copy$default(this.rumConfig, null, 0.0f, 0.0f, 0.0f, false, null, null, null, null, null, null, null, null, null, null, false, false, false, null, null, additionalConfig, 1048575, null);
            return this;
        }

        @JvmOverloads
        @NotNull
        public final Builder trackUserInteractions(@NotNull ViewAttributesProvider[] touchTargetExtraAttributesProviders) {
            Intrinsics.checkNotNullParameter((Object)touchTargetExtraAttributesProviders, (String)"touchTargetExtraAttributesProviders");
            return Builder.trackUserInteractions$default(this, touchTargetExtraAttributesProviders, null, 2, null);
        }

        @JvmOverloads
        @NotNull
        public final Builder trackUserInteractions() {
            return Builder.trackUserInteractions$default(this, null, null, 3, null);
        }

        @JvmOverloads
        @NotNull
        public final Builder trackLongTasks() {
            return Builder.trackLongTasks$default(this, 0L, 1, null);
        }
    }
}

