/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.log;

import androidx.annotation.FloatRange;
import com.datadog.android.Datadog;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.SdkCore;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.api.storage.DataWriter;
import com.datadog.android.core.internal.utils.MapUtilsKt;
import com.datadog.android.core.sampling.RateBasedSampler;
import com.datadog.android.core.sampling.Sampler;
import com.datadog.android.log.Logger;
import com.datadog.android.log.internal.LogsFeature;
import com.datadog.android.log.internal.domain.DatadogLogGenerator;
import com.datadog.android.log.internal.logger.CombinedLogHandler;
import com.datadog.android.log.internal.logger.DatadogLogHandler;
import com.datadog.android.log.internal.logger.LogHandler;
import com.datadog.android.log.internal.logger.LogcatLogHandler;
import com.datadog.android.log.internal.logger.NoOpLogHandler;
import com.datadog.android.log.model.LogEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 72\u00020\u0001:\u000267B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0007J\u0016\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J4\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00072\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001aH\u0007J4\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00072\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001aH\u0007J4\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00072\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001aH\u0007J]\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\u00072\b\u0010!\u001a\u0004\u0018\u00010\u00072\b\u0010\"\u001a\u0004\u0018\u00010\u00072\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001a2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0002\u00a2\u0006\u0002\u0010&JK\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001a2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0000\u00a2\u0006\u0004\b'\u0010(JN\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\u00072\b\u0010!\u001a\u0004\u0018\u00010\u00072\b\u0010\"\u001a\u0004\u0018\u00010\u00072\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001aH\u0007J<\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00072\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001aH\u0007J\u000e\u0010+\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010,\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0007J\u0010\u0010-\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u000e\u0010.\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u001c\u0010/\u001a\u00020\u00102\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020201H\u0002J4\u00103\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00072\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001aH\u0007J4\u00104\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00072\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001aH\u0007J4\u00105\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00072\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001aH\u0007R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0004R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00068"}, d2={"Lcom/datadog/android/log/Logger;", "", "handler", "Lcom/datadog/android/log/internal/logger/LogHandler;", "(Lcom/datadog/android/log/internal/logger/LogHandler;)V", "attributes", "Ljava/util/concurrent/ConcurrentHashMap;", "", "getHandler$dd_sdk_android_logs_release", "()Lcom/datadog/android/log/internal/logger/LogHandler;", "setHandler$dd_sdk_android_logs_release", "tags", "Ljava/util/concurrent/CopyOnWriteArraySet;", "getTags$dd_sdk_android_logs_release", "()Ljava/util/concurrent/CopyOnWriteArraySet;", "addAttribute", "", "key", "value", "addTag", "tag", "addTagInternal", "d", "message", "throwable", "", "", "e", "i", "internalLog", "level", "", "errorKind", "errorMessage", "errorStacktrace", "localAttributes", "timestamp", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Long;)V", "internalLog$dd_sdk_android_logs_release", "(ILjava/lang/String;Ljava/lang/Throwable;Ljava/util/Map;Ljava/lang/Long;)V", "log", "priority", "removeAttribute", "removeTag", "removeTagInternal", "removeTagsWithKey", "safelyRemoveTagsWithKey", "keyFilter", "Lkotlin/Function1;", "", "v", "w", "wtf", "Builder", "Companion", "dd-sdk-android-logs_release"})
@SourceDebugExtension(value={"SMAP\nLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logger.kt\ncom/datadog/android/log/Logger\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,524:1\n37#2,2:525\n3792#3:527\n4307#3,2:528\n*S KotlinDebug\n*F\n+ 1 Logger.kt\ncom/datadog/android/log/Logger\n*L\n506#1:525,2\n506#1:527\n506#1:528,2\n*E\n"})
public final class Logger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LogHandler handler;
    @NotNull
    private final ConcurrentHashMap<String, Object> attributes;
    @NotNull
    private final CopyOnWriteArraySet<String> tags;
    public static final float DEFAULT_SAMPLE_RATE = 100.0f;
    @NotNull
    public static final String SDK_NOT_INITIALIZED_WARNING_MESSAGE = "You're trying to create a Logger instance, but the SDK was not yet initialized. This Logger will not be able to send any messages. Please initialize the Datadog SDK first before creating a new Logger instance.";

    public Logger(@NotNull LogHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handler = handler;
        this.attributes = new ConcurrentHashMap();
        this.tags = new CopyOnWriteArraySet();
    }

    @NotNull
    public final LogHandler getHandler$dd_sdk_android_logs_release() {
        return this.handler;
    }

    public final void setHandler$dd_sdk_android_logs_release(@NotNull LogHandler logHandler) {
        Intrinsics.checkNotNullParameter((Object)logHandler, (String)"<set-?>");
        this.handler = logHandler;
    }

    @NotNull
    public final CopyOnWriteArraySet<String> getTags$dd_sdk_android_logs_release() {
        return this.tags;
    }

    @JvmOverloads
    public final void v(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_logs_release$default(this, 2, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void v$default(Logger logger, String string, Throwable throwable, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        logger.v(string, throwable, map2);
    }

    @JvmOverloads
    public final void d(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_logs_release$default(this, 3, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void d$default(Logger logger, String string, Throwable throwable, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        logger.d(string, throwable, map2);
    }

    @JvmOverloads
    public final void i(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_logs_release$default(this, 4, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void i$default(Logger logger, String string, Throwable throwable, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        logger.i(string, throwable, map2);
    }

    @JvmOverloads
    public final void w(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_logs_release$default(this, 5, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void w$default(Logger logger, String string, Throwable throwable, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        logger.w(string, throwable, map2);
    }

    @JvmOverloads
    public final void e(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_logs_release$default(this, 6, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void e$default(Logger logger, String string, Throwable throwable, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        logger.e(string, throwable, map2);
    }

    @JvmOverloads
    public final void wtf(@NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_logs_release$default(this, 7, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void wtf$default(Logger logger, String string, Throwable throwable, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        logger.wtf(string, throwable, map2);
    }

    @JvmOverloads
    public final void log(int priority, @NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$dd_sdk_android_logs_release$default(this, priority, message, throwable, attributes, null, 16, null);
    }

    public static /* synthetic */ void log$default(Logger logger, int n, String string, Throwable throwable, Map map2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            throwable = null;
        }
        if ((n2 & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        logger.log(n, string, throwable, map2);
    }

    @JvmOverloads
    public final void log(int priority, @NotNull String message, @Nullable String errorKind, @Nullable String errorMessage, @Nullable String errorStacktrace, @NotNull Map<String, ? extends Object> attributes) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        Logger.internalLog$default(this, priority, message, errorKind, errorMessage, errorStacktrace, attributes, null, 64, null);
    }

    public static /* synthetic */ void log$default(Logger logger, int n, String string, String string2, String string3, String string4, Map map2, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            map2 = MapsKt.emptyMap();
        }
        logger.log(n, string, string2, string3, string4, map2);
    }

    public final void addAttribute(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value == null) {
            ((Map)this.attributes).put(key, MapUtilsKt.getNULL_MAP_VALUE());
        } else {
            ((Map)this.attributes).put(key, value);
        }
    }

    public final void removeAttribute(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.attributes.remove(key);
    }

    public final void addTag(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.addTagInternal(key + ":" + value);
    }

    public final void addTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.addTagInternal(tag);
    }

    public final void removeTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.removeTagInternal(tag);
    }

    public final void removeTagsWithKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String prefix = key + ":";
        this.safelyRemoveTagsWithKey((Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(prefix){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StringsKt.startsWith$default((String)it, (String)this.$prefix, (boolean)false, (int)2, null);
            }
        }));
    }

    public final void internalLog$dd_sdk_android_logs_release(int level, @NotNull String message, @Nullable Throwable throwable, @NotNull Map<String, ? extends Object> localAttributes, @Nullable Long timestamp) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(localAttributes, (String)"localAttributes");
        Map combinedAttributes = new LinkedHashMap();
        combinedAttributes.putAll((Map)this.attributes);
        combinedAttributes.putAll(localAttributes);
        HashSet tagsSnapshot = new HashSet(this.tags);
        this.handler.handleLog(level, message, throwable, combinedAttributes, tagsSnapshot, timestamp);
    }

    public static /* synthetic */ void internalLog$dd_sdk_android_logs_release$default(Logger logger, int n, String string, Throwable throwable, Map map2, Long l, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            l = null;
        }
        logger.internalLog$dd_sdk_android_logs_release(n, string, throwable, map2, l);
    }

    private final void internalLog(int level, String message, String errorKind, String errorMessage, String errorStacktrace, Map<String, ? extends Object> localAttributes, Long timestamp) {
        Map combinedAttributes = new LinkedHashMap();
        combinedAttributes.putAll((Map)this.attributes);
        combinedAttributes.putAll(localAttributes);
        HashSet tagsSnapshot = new HashSet(this.tags);
        this.handler.handleLog(level, message, errorKind, errorMessage, errorStacktrace, combinedAttributes, tagsSnapshot, timestamp);
    }

    static /* synthetic */ void internalLog$default(Logger logger, int n, String string, String string2, String string3, String string4, Map map2, Long l, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            l = null;
        }
        logger.internalLog(n, string, string2, string3, string4, map2, l);
    }

    private final void addTagInternal(String tag) {
        this.tags.add(tag);
    }

    private final void removeTagInternal(String tag) {
        this.tags.remove(tag);
    }

    /*
     * WARNING - void declaration
     */
    private final void safelyRemoveTagsWithKey(Function1<? super String, Boolean> keyFilter) {
        void $this$filterTo$iv$iv;
        String[] $this$toTypedArray$iv = (String[])this.tags;
        boolean $i$f$toTypedArray = false;
        String[] thisCollection$iv = $this$toTypedArray$iv;
        String[] $this$filter$iv = thisCollection$iv.toArray(new String[0]);
        boolean $i$f$filter = false;
        thisCollection$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)keyFilter.invoke((Object)element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toRemove = (List)destination$iv$iv;
        this.tags.removeAll(toRemove);
    }

    @JvmOverloads
    public final void v(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.v$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void v(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.v$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void d(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.d$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void d(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.d$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void i(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.i$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void i(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.i$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void w(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.w$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void w(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.w$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void e(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.e$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void e(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.e$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void wtf(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.wtf$default(this, message, throwable, null, 4, null);
    }

    @JvmOverloads
    public final void wtf(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.wtf$default(this, message, null, null, 6, null);
    }

    @JvmOverloads
    public final void log(int priority, @NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.log$default(this, priority, message, throwable, null, 8, null);
    }

    @JvmOverloads
    public final void log(int priority, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.log$default(this, priority, message, null, null, 12, null);
    }

    @JvmOverloads
    public final void log(int priority, @NotNull String message, @Nullable String errorKind, @Nullable String errorMessage, @Nullable String errorStacktrace) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.log$default(this, priority, message, errorKind, errorMessage, errorStacktrace, null, 32, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0012\u0010\u0018\u001a\u00020\u00152\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0006J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0006J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\nJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\fJ\u0010\u0010\"\u001a\u00020\u00002\b\b\u0001\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/datadog/android/log/Logger$Builder;", "", "sdkCore", "Lcom/datadog/android/api/SdkCore;", "(Lcom/datadog/android/api/SdkCore;)V", "bundleWithRumEnabled", "", "bundleWithTraceEnabled", "logcatLogsEnabled", "loggerName", "", "minDatadogLogsPriority", "", "networkInfoEnabled", "sampleRate", "", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "serviceName", "build", "Lcom/datadog/android/log/Logger;", "buildDatadogHandler", "Lcom/datadog/android/log/internal/logger/LogHandler;", "logsFeature", "Lcom/datadog/android/log/internal/LogsFeature;", "buildLogcatHandler", "setBundleWithRumEnabled", "enabled", "setBundleWithTraceEnabled", "setLogcatLogsEnabled", "setName", "name", "setNetworkInfoEnabled", "setRemoteLogThreshold", "minLogThreshold", "setRemoteSampleRate", "setService", "service", "dd-sdk-android-logs_release"})
    public static final class Builder {
        @NotNull
        private final FeatureSdkCore sdkCore;
        @Nullable
        private String serviceName;
        @Nullable
        private String loggerName;
        private boolean logcatLogsEnabled;
        private boolean networkInfoEnabled;
        private boolean bundleWithTraceEnabled;
        private boolean bundleWithRumEnabled;
        private float sampleRate;
        private int minDatadogLogsPriority;

        @JvmOverloads
        public Builder(@NotNull SdkCore sdkCore) {
            Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
            this.sdkCore = (FeatureSdkCore)sdkCore;
            this.bundleWithTraceEnabled = true;
            this.bundleWithRumEnabled = true;
            this.sampleRate = 100.0f;
            this.minDatadogLogsPriority = -1;
        }

        public /* synthetic */ Builder(SdkCore sdkCore, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                sdkCore = Datadog.getInstance$default(null, (int)1, null);
            }
            this(sdkCore);
        }

        @NotNull
        public final Logger build() {
            LogHandler logHandler;
            FeatureScope featureScope = this.sdkCore.getFeature("logs");
            LogsFeature logsFeature = featureScope != null ? (LogsFeature)featureScope.unwrap() : null;
            boolean datadogLogsEnabled = this.sampleRate > 0.0f;
            if (datadogLogsEnabled && this.logcatLogsEnabled) {
                LogHandler[] logHandlerArray = new LogHandler[]{this.buildDatadogHandler(this.sdkCore, logsFeature), this.buildLogcatHandler((SdkCore)this.sdkCore)};
                logHandler = new CombinedLogHandler(logHandlerArray);
            } else {
                logHandler = datadogLogsEnabled ? this.buildDatadogHandler(this.sdkCore, logsFeature) : (this.logcatLogsEnabled ? this.buildLogcatHandler((SdkCore)this.sdkCore) : (LogHandler)new NoOpLogHandler());
            }
            LogHandler handler = logHandler;
            return new Logger(handler);
        }

        @NotNull
        public final Builder setService(@NotNull String service) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            this.serviceName = service;
            return this;
        }

        @NotNull
        public final Builder setRemoteLogThreshold(int minLogThreshold) {
            this.minDatadogLogsPriority = minLogThreshold;
            return this;
        }

        @NotNull
        public final Builder setLogcatLogsEnabled(boolean enabled) {
            this.logcatLogsEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setNetworkInfoEnabled(boolean enabled) {
            this.networkInfoEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.loggerName = name;
            return this;
        }

        @NotNull
        public final Builder setBundleWithTraceEnabled(boolean enabled) {
            this.bundleWithTraceEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setBundleWithRumEnabled(boolean enabled) {
            this.bundleWithRumEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setRemoteSampleRate(@FloatRange(from=0.0, to=100.0) float sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        private final LogHandler buildLogcatHandler(SdkCore sdkCore) {
            String string = this.serviceName;
            if (string == null) {
                SdkCore sdkCore2 = sdkCore;
                string = sdkCore2 != null ? sdkCore2.getService() : null;
                if (string == null) {
                    string = "unknown";
                }
            }
            return new LogcatLogHandler(string, true, false, 4, null);
        }

        private final LogHandler buildDatadogHandler(FeatureSdkCore sdkCore, LogsFeature logsFeature) {
            String string;
            String string2;
            if (logsFeature == null) {
                InternalLogger.DefaultImpls.log$default((InternalLogger)sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)buildDatadogHandler.1.INSTANCE, null, (boolean)false, null, (int)56, null);
                return new NoOpLogHandler();
            }
            String string3 = this.loggerName;
            if (string3 == null) {
                string3 = string2 = logsFeature.getPackageName$dd_sdk_android_logs_release();
            }
            if ((string = this.serviceName) == null) {
                string = sdkCore.getService();
            }
            DatadogLogGenerator datadogLogGenerator = new DatadogLogGenerator(string);
            DataWriter<LogEvent> dataWriter = logsFeature.getDataWriter$dd_sdk_android_logs_release();
            int n = this.minDatadogLogsPriority;
            boolean bl = this.bundleWithTraceEnabled;
            boolean bl2 = this.bundleWithRumEnabled;
            RateBasedSampler rateBasedSampler = new RateBasedSampler(this.sampleRate);
            boolean bl3 = this.networkInfoEnabled;
            return new DatadogLogHandler(string2, datadogLogGenerator, sdkCore, dataWriter, bl3, bl, bl2, (Sampler)rateBasedSampler, n);
        }

        @JvmOverloads
        public Builder() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/log/Logger$Companion;", "", "()V", "DEFAULT_SAMPLE_RATE", "", "SDK_NOT_INITIALIZED_WARNING_MESSAGE", "", "dd-sdk-android-logs_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

