/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence.file.advanced;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.persistence.file.FileMover;
import com.datadog.android.core.internal.persistence.file.advanced.DataMigrationOperation;
import com.datadog.android.core.internal.persistence.file.advanced.WipeDataMigrationOperation;
import com.datadog.android.core.internal.utils.MiscUtilsKt;
import java.io.File;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/datadog/android/core/internal/persistence/file/advanced/WipeDataMigrationOperation;", "Lcom/datadog/android/core/internal/persistence/file/advanced/DataMigrationOperation;", "targetDir", "Ljava/io/File;", "fileMover", "Lcom/datadog/android/core/internal/persistence/file/FileMover;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Ljava/io/File;Lcom/datadog/android/core/internal/persistence/file/FileMover;Lcom/datadog/android/api/InternalLogger;)V", "getFileMover$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/persistence/file/FileMover;", "getInternalLogger$dd_sdk_android_core_release", "()Lcom/datadog/android/api/InternalLogger;", "getTargetDir$dd_sdk_android_core_release", "()Ljava/io/File;", "run", "", "Companion", "dd-sdk-android-core_release"})
public final class WipeDataMigrationOperation
implements DataMigrationOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final File targetDir;
    @NotNull
    private final FileMover fileMover;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    public static final String WARN_NULL_DIR = "Can't wipe data from a null directory";
    private static final int MAX_RETRY = 3;
    private static final long RETRY_DELAY_NS = TimeUnit.MILLISECONDS.toNanos(500L);

    public WipeDataMigrationOperation(@Nullable File targetDir, @NotNull FileMover fileMover, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)fileMover, (String)"fileMover");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.targetDir = targetDir;
        this.fileMover = fileMover;
        this.internalLogger = internalLogger;
    }

    @Nullable
    public final File getTargetDir$dd_sdk_android_core_release() {
        return this.targetDir;
    }

    @NotNull
    public final FileMover getFileMover$dd_sdk_android_core_release() {
        return this.fileMover;
    }

    @NotNull
    public final InternalLogger getInternalLogger$dd_sdk_android_core_release() {
        return this.internalLogger;
    }

    @Override
    @WorkerThread
    public void run() {
        if (this.targetDir == null) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.MAINTAINER, (Function0)run.1.INSTANCE, null, false, null, 56, null);
        } else {
            MiscUtilsKt.retryWithDelay(3, RETRY_DELAY_NS, this.internalLogger, (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
                final /* synthetic */ WipeDataMigrationOperation this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    return this.this$0.getFileMover$dd_sdk_android_core_release().delete(this.this$0.getTargetDir$dd_sdk_android_core_release());
                }
            }));
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/datadog/android/core/internal/persistence/file/advanced/WipeDataMigrationOperation$Companion;", "", "()V", "MAX_RETRY", "", "RETRY_DELAY_NS", "", "WARN_NULL_DIR", "", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

