/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.configuration;

import com.datadog.android.DatadogSite;
import com.datadog.android.core.configuration.BackPressureMitigation;
import com.datadog.android.core.configuration.BackPressureStrategy;
import com.datadog.android.core.configuration.BatchProcessingLevel;
import com.datadog.android.core.configuration.BatchSize;
import com.datadog.android.core.configuration.Configuration;
import com.datadog.android.core.configuration.HostsSanitizer;
import com.datadog.android.core.configuration.UploadFrequency;
import com.datadog.android.core.persistence.PersistenceStrategy;
import com.datadog.android.security.Encryption;
import com.datadog.android.trace.TracingHeaderType;
import java.net.Proxy;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import okhttp3.Authenticator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u001e\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 .2\u00020\u0001:\u0003-./BM\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0019\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u001aJ\u000e\u0010\u001b\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u001cJ\u000e\u0010\u001d\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u001eJ\u000e\u0010\u001f\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b J\u0010\u0010!\u001a\u0004\u0018\u00010\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\"J\u000e\u0010#\u001a\u00020\nH\u00c0\u0003\u00a2\u0006\u0002\b$J\u001a\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\fH\u00c0\u0003\u00a2\u0006\u0002\b&J]\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\fH\u00c6\u0001J\u0013\u0010(\u001a\u00020\n2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\u0005H\u00d6\u0001R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0014\u0010\u0007\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011\u00a8\u00060"}, d2={"Lcom/datadog/android/core/configuration/Configuration;", "", "coreConfig", "Lcom/datadog/android/core/configuration/Configuration$Core;", "clientToken", "", "env", "variant", "service", "crashReportsEnabled", "", "additionalConfig", "", "(Lcom/datadog/android/core/configuration/Configuration$Core;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/util/Map;)V", "getAdditionalConfig$dd_sdk_android_core_release", "()Ljava/util/Map;", "getClientToken$dd_sdk_android_core_release", "()Ljava/lang/String;", "getCoreConfig$dd_sdk_android_core_release", "()Lcom/datadog/android/core/configuration/Configuration$Core;", "getCrashReportsEnabled$dd_sdk_android_core_release", "()Z", "getEnv$dd_sdk_android_core_release", "getService$dd_sdk_android_core_release", "getVariant$dd_sdk_android_core_release", "component1", "component1$dd_sdk_android_core_release", "component2", "component2$dd_sdk_android_core_release", "component3", "component3$dd_sdk_android_core_release", "component4", "component4$dd_sdk_android_core_release", "component5", "component5$dd_sdk_android_core_release", "component6", "component6$dd_sdk_android_core_release", "component7", "component7$dd_sdk_android_core_release", "copy", "equals", "other", "hashCode", "", "toString", "Builder", "Companion", "Core", "dd-sdk-android-core_release"})
public final class Configuration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Core coreConfig;
    @NotNull
    private final String clientToken;
    @NotNull
    private final String env;
    @NotNull
    private final String variant;
    @Nullable
    private final String service;
    private final boolean crashReportsEnabled;
    @NotNull
    private final Map<String, Object> additionalConfig;
    @NotNull
    private static final String NO_VARIANT = "";
    private static final int DEFAULT_BACKPRESSURE_THRESHOLD = 1024;
    @NotNull
    private static final BackPressureStrategy DEFAULT_BACKPRESSURE_STRATEGY = new BackPressureStrategy(1024, (Function0<Unit>)((Function0)Companion.DEFAULT_BACKPRESSURE_STRATEGY.1.INSTANCE), (Function1<Object, Unit>)((Function1)Companion.DEFAULT_BACKPRESSURE_STRATEGY.2.INSTANCE), BackPressureMitigation.IGNORE_NEWEST);
    @NotNull
    private static final Core DEFAULT_CORE_CONFIG = new Core(false, false, MapsKt.emptyMap(), BatchSize.MEDIUM, UploadFrequency.AVERAGE, null, Authenticator.NONE, null, DatadogSite.US1, BatchProcessingLevel.MEDIUM, null, DEFAULT_BACKPRESSURE_STRATEGY);
    @NotNull
    public static final String NETWORK_REQUESTS_TRACKING_FEATURE_NAME = "Network requests";

    public Configuration(@NotNull Core coreConfig, @NotNull String clientToken, @NotNull String env, @NotNull String variant, @Nullable String service, boolean crashReportsEnabled, @NotNull Map<String, ? extends Object> additionalConfig) {
        Intrinsics.checkNotNullParameter((Object)coreConfig, (String)"coreConfig");
        Intrinsics.checkNotNullParameter((Object)clientToken, (String)"clientToken");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(additionalConfig, (String)"additionalConfig");
        this.coreConfig = coreConfig;
        this.clientToken = clientToken;
        this.env = env;
        this.variant = variant;
        this.service = service;
        this.crashReportsEnabled = crashReportsEnabled;
        this.additionalConfig = additionalConfig;
    }

    @NotNull
    public final Core getCoreConfig$dd_sdk_android_core_release() {
        return this.coreConfig;
    }

    @NotNull
    public final String getClientToken$dd_sdk_android_core_release() {
        return this.clientToken;
    }

    @NotNull
    public final String getEnv$dd_sdk_android_core_release() {
        return this.env;
    }

    @NotNull
    public final String getVariant$dd_sdk_android_core_release() {
        return this.variant;
    }

    @Nullable
    public final String getService$dd_sdk_android_core_release() {
        return this.service;
    }

    public final boolean getCrashReportsEnabled$dd_sdk_android_core_release() {
        return this.crashReportsEnabled;
    }

    @NotNull
    public final Map<String, Object> getAdditionalConfig$dd_sdk_android_core_release() {
        return this.additionalConfig;
    }

    @NotNull
    public final Core component1$dd_sdk_android_core_release() {
        return this.coreConfig;
    }

    @NotNull
    public final String component2$dd_sdk_android_core_release() {
        return this.clientToken;
    }

    @NotNull
    public final String component3$dd_sdk_android_core_release() {
        return this.env;
    }

    @NotNull
    public final String component4$dd_sdk_android_core_release() {
        return this.variant;
    }

    @Nullable
    public final String component5$dd_sdk_android_core_release() {
        return this.service;
    }

    public final boolean component6$dd_sdk_android_core_release() {
        return this.crashReportsEnabled;
    }

    @NotNull
    public final Map<String, Object> component7$dd_sdk_android_core_release() {
        return this.additionalConfig;
    }

    @NotNull
    public final Configuration copy(@NotNull Core coreConfig, @NotNull String clientToken, @NotNull String env, @NotNull String variant, @Nullable String service, boolean crashReportsEnabled, @NotNull Map<String, ? extends Object> additionalConfig) {
        Intrinsics.checkNotNullParameter((Object)coreConfig, (String)"coreConfig");
        Intrinsics.checkNotNullParameter((Object)clientToken, (String)"clientToken");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(additionalConfig, (String)"additionalConfig");
        return new Configuration(coreConfig, clientToken, env, variant, service, crashReportsEnabled, additionalConfig);
    }

    public static /* synthetic */ Configuration copy$default(Configuration configuration, Core core, String string, String string2, String string3, String string4, boolean bl, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            core = configuration.coreConfig;
        }
        if ((n & 2) != 0) {
            string = configuration.clientToken;
        }
        if ((n & 4) != 0) {
            string2 = configuration.env;
        }
        if ((n & 8) != 0) {
            string3 = configuration.variant;
        }
        if ((n & 0x10) != 0) {
            string4 = configuration.service;
        }
        if ((n & 0x20) != 0) {
            bl = configuration.crashReportsEnabled;
        }
        if ((n & 0x40) != 0) {
            map = configuration.additionalConfig;
        }
        return configuration.copy(core, string, string2, string3, string4, bl, map);
    }

    @NotNull
    public String toString() {
        return "Configuration(coreConfig=" + this.coreConfig + ", clientToken=" + this.clientToken + ", env=" + this.env + ", variant=" + this.variant + ", service=" + this.service + ", crashReportsEnabled=" + this.crashReportsEnabled + ", additionalConfig=" + this.additionalConfig + ")";
    }

    public int hashCode() {
        int result = this.coreConfig.hashCode();
        result = result * 31 + this.clientToken.hashCode();
        result = result * 31 + this.env.hashCode();
        result = result * 31 + this.variant.hashCode();
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        int n = this.crashReportsEnabled ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + ((Object)this.additionalConfig).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Configuration)) {
            return false;
        }
        Configuration configuration = (Configuration)other;
        if (!Intrinsics.areEqual((Object)this.coreConfig, (Object)configuration.coreConfig)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clientToken, (Object)configuration.clientToken)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.env, (Object)configuration.env)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.variant, (Object)configuration.variant)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.service, (Object)configuration.service)) {
            return false;
        }
        if (this.crashReportsEnabled != configuration.crashReportsEnabled) {
            return false;
        }
        return Intrinsics.areEqual(this.additionalConfig, configuration.additionalConfig);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u0014\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u001a\u0010\u0018\u001a\u00020\u00002\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\tJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%J\u0014\u0010&\u001a\u00020\u00002\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030(J \u0010)\u001a\u00020\u00002\u0018\u0010*\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0+0\tJ\u0010\u0010-\u001a\u00020\u00002\b\u0010.\u001a\u0004\u0018\u00010/J\u0018\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u000104J\u000e\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\rJ\u000e\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020<R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/datadog/android/core/configuration/Configuration$Builder;", "", "clientToken", "", "env", "variant", "service", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "additionalConfig", "", "coreConfig", "Lcom/datadog/android/core/configuration/Configuration$Core;", "crashReportsEnabled", "", "hostsSanitizer", "Lcom/datadog/android/core/configuration/HostsSanitizer;", "getHostsSanitizer$dd_sdk_android_core_release", "()Lcom/datadog/android/core/configuration/HostsSanitizer;", "setHostsSanitizer$dd_sdk_android_core_release", "(Lcom/datadog/android/core/configuration/HostsSanitizer;)V", "allowClearTextHttp", "allowClearTextHttp$dd_sdk_android_core_release", "build", "Lcom/datadog/android/core/configuration/Configuration;", "setAdditionalConfiguration", "setBackpressureStrategy", "backpressureStrategy", "Lcom/datadog/android/core/configuration/BackPressureStrategy;", "setBatchProcessingLevel", "batchProcessingLevel", "Lcom/datadog/android/core/configuration/BatchProcessingLevel;", "setBatchSize", "batchSize", "Lcom/datadog/android/core/configuration/BatchSize;", "setCrashReportsEnabled", "setEncryption", "dataEncryption", "Lcom/datadog/android/security/Encryption;", "setFirstPartyHosts", "hosts", "", "setFirstPartyHostsWithHeaderType", "hostsWithHeaderType", "", "Lcom/datadog/android/trace/TracingHeaderType;", "setPersistenceStrategyFactory", "persistenceStrategyFactory", "Lcom/datadog/android/core/persistence/PersistenceStrategy$Factory;", "setProxy", "proxy", "Ljava/net/Proxy;", "authenticator", "Lokhttp3/Authenticator;", "setUploadFrequency", "uploadFrequency", "Lcom/datadog/android/core/configuration/UploadFrequency;", "setUseDeveloperModeWhenDebuggable", "developerModeEnabled", "useSite", "site", "Lcom/datadog/android/DatadogSite;", "dd-sdk-android-core_release"})
    @SourceDebugExtension(value={"SMAP\nConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Configuration.kt\ncom/datadog/android/core/configuration/Configuration$Builder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,306:1\n1271#2,2:307\n1285#2,4:309\n467#3,7:313\n*S KotlinDebug\n*F\n+ 1 Configuration.kt\ncom/datadog/android/core/configuration/Configuration$Builder\n*L\n122#1:307,2\n122#1:309,4\n149#1:313,7\n*E\n"})
    public static final class Builder {
        @NotNull
        private final String clientToken;
        @NotNull
        private final String env;
        @NotNull
        private final String variant;
        @Nullable
        private final String service;
        @NotNull
        private Map<String, ? extends Object> additionalConfig;
        @NotNull
        private Core coreConfig;
        private boolean crashReportsEnabled;
        @NotNull
        private HostsSanitizer hostsSanitizer;

        @JvmOverloads
        public Builder(@NotNull String clientToken, @NotNull String env, @NotNull String variant, @Nullable String service) {
            Intrinsics.checkNotNullParameter((Object)clientToken, (String)"clientToken");
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            this.clientToken = clientToken;
            this.env = env;
            this.variant = variant;
            this.service = service;
            this.additionalConfig = MapsKt.emptyMap();
            this.coreConfig = Companion.getDEFAULT_CORE_CONFIG$dd_sdk_android_core_release();
            this.crashReportsEnabled = true;
            this.hostsSanitizer = new HostsSanitizer();
        }

        public /* synthetic */ Builder(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = Configuration.NO_VARIANT;
            }
            if ((n & 8) != 0) {
                string4 = null;
            }
            this(string, string2, string3, string4);
        }

        @NotNull
        public final HostsSanitizer getHostsSanitizer$dd_sdk_android_core_release() {
            return this.hostsSanitizer;
        }

        public final void setHostsSanitizer$dd_sdk_android_core_release(@NotNull HostsSanitizer hostsSanitizer) {
            Intrinsics.checkNotNullParameter((Object)hostsSanitizer, (String)"<set-?>");
            this.hostsSanitizer = hostsSanitizer;
        }

        @NotNull
        public final Configuration build() {
            return new Configuration(this.coreConfig, this.clientToken, this.env, this.variant, this.service, this.crashReportsEnabled, this.additionalConfig);
        }

        @NotNull
        public final Builder setUseDeveloperModeWhenDebuggable(boolean developerModeEnabled) {
            this.coreConfig = Core.copy$default(this.coreConfig, false, developerModeEnabled, null, null, null, null, null, null, null, null, null, null, 4093, null);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder setFirstPartyHosts(@NotNull List<String> hosts) {
            Map map;
            void $this$associateWith$iv;
            Intrinsics.checkNotNullParameter(hosts, (String)"hosts");
            List<String> sanitizedHosts = this.hostsSanitizer.sanitizeHosts(hosts, Configuration.NETWORK_REQUESTS_TRACKING_FEATURE_NAME);
            Iterable iterable = sanitizedHosts;
            boolean bl = false;
            boolean bl2 = false;
            Core core = this.coreConfig;
            Builder builder = this;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String string = (String)element$iv$iv;
                Object t = element$iv$iv;
                map = result$iv;
                boolean bl3 = false;
                TracingHeaderType[] tracingHeaderTypeArray = new TracingHeaderType[]{TracingHeaderType.DATADOG, TracingHeaderType.TRACECONTEXT};
                Set set = SetsKt.setOf((Object[])tracingHeaderTypeArray);
                map.put(t, set);
            }
            map = result$iv;
            builder.coreConfig = Core.copy$default(core, bl2, bl, map, null, null, null, null, null, null, null, null, null, 4091, null);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Builder setFirstPartyHostsWithHeaderType(@NotNull Map<String, ? extends Set<? extends TracingHeaderType>> hostsWithHeaderType) {
            void $this$filterKeys$iv;
            Intrinsics.checkNotNullParameter(hostsWithHeaderType, (String)"hostsWithHeaderType");
            List<String> sanitizedHosts = this.hostsSanitizer.sanitizeHosts(CollectionsKt.toList((Iterable)hostsWithHeaderType.keySet()), Configuration.NETWORK_REQUESTS_TRACKING_FEATURE_NAME);
            Map<String, ? extends Set<? extends TracingHeaderType>> map = hostsWithHeaderType;
            boolean bl = false;
            boolean bl2 = false;
            Core core = this.coreConfig;
            Builder builder = this;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                String it = (String)entry$iv.getKey();
                boolean bl3 = false;
                if (!sanitizedHosts.contains(it)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map map2 = result$iv;
            builder.coreConfig = Core.copy$default(core, bl2, bl, map2, null, null, null, null, null, null, null, null, null, 4091, null);
            return this;
        }

        @NotNull
        public final Builder useSite(@NotNull DatadogSite site) {
            Intrinsics.checkNotNullParameter((Object)((Object)site), (String)"site");
            this.coreConfig = Core.copy$default(this.coreConfig, false, false, null, null, null, null, null, null, site, null, null, null, 3838, null);
            return this;
        }

        @NotNull
        public final Builder setBatchSize(@NotNull BatchSize batchSize) {
            Intrinsics.checkNotNullParameter((Object)((Object)batchSize), (String)"batchSize");
            this.coreConfig = Core.copy$default(this.coreConfig, false, false, null, batchSize, null, null, null, null, null, null, null, null, 4087, null);
            return this;
        }

        @NotNull
        public final Builder setUploadFrequency(@NotNull UploadFrequency uploadFrequency) {
            Intrinsics.checkNotNullParameter((Object)((Object)uploadFrequency), (String)"uploadFrequency");
            this.coreConfig = Core.copy$default(this.coreConfig, false, false, null, null, uploadFrequency, null, null, null, null, null, null, null, 4079, null);
            return this;
        }

        @NotNull
        public final Builder setBatchProcessingLevel(@NotNull BatchProcessingLevel batchProcessingLevel) {
            Intrinsics.checkNotNullParameter((Object)((Object)batchProcessingLevel), (String)"batchProcessingLevel");
            this.coreConfig = Core.copy$default(this.coreConfig, false, false, null, null, null, null, null, null, null, batchProcessingLevel, null, null, 3583, null);
            return this;
        }

        @NotNull
        public final Builder setAdditionalConfiguration(@NotNull Map<String, ? extends Object> additionalConfig) {
            Builder builder;
            Intrinsics.checkNotNullParameter(additionalConfig, (String)"additionalConfig");
            Builder $this$setAdditionalConfiguration_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$setAdditionalConfiguration_u24lambda_u242.additionalConfig = additionalConfig;
            return builder;
        }

        @NotNull
        public final Builder setProxy(@NotNull Proxy proxy, @Nullable Authenticator authenticator) {
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            Authenticator authenticator2 = authenticator;
            if (authenticator2 == null) {
                authenticator2 = Authenticator.NONE;
            }
            this.coreConfig = Core.copy$default(this.coreConfig, false, false, null, null, null, proxy, authenticator2, null, null, null, null, null, 3999, null);
            return this;
        }

        @NotNull
        public final Builder setEncryption(@NotNull Encryption dataEncryption) {
            Intrinsics.checkNotNullParameter((Object)dataEncryption, (String)"dataEncryption");
            this.coreConfig = Core.copy$default(this.coreConfig, false, false, null, null, null, null, null, dataEncryption, null, null, null, null, 3967, null);
            return this;
        }

        @NotNull
        public final Builder setPersistenceStrategyFactory(@Nullable PersistenceStrategy.Factory persistenceStrategyFactory) {
            this.coreConfig = Core.copy$default(this.coreConfig, false, false, null, null, null, null, null, null, null, null, persistenceStrategyFactory, null, 3071, null);
            return this;
        }

        @NotNull
        public final Builder setCrashReportsEnabled(boolean crashReportsEnabled) {
            this.crashReportsEnabled = crashReportsEnabled;
            return this;
        }

        @NotNull
        public final Builder setBackpressureStrategy(@NotNull BackPressureStrategy backpressureStrategy) {
            Intrinsics.checkNotNullParameter((Object)backpressureStrategy, (String)"backpressureStrategy");
            this.coreConfig = Core.copy$default(this.coreConfig, false, false, null, null, null, null, null, null, null, null, null, backpressureStrategy, 2047, null);
            return this;
        }

        @NotNull
        public final Builder allowClearTextHttp$dd_sdk_android_core_release() {
            this.coreConfig = Core.copy$default(this.coreConfig, true, false, null, null, null, null, null, null, null, null, null, null, 4094, null);
            return this;
        }

        @JvmOverloads
        public Builder(@NotNull String clientToken, @NotNull String env, @NotNull String variant) {
            Intrinsics.checkNotNullParameter((Object)clientToken, (String)"clientToken");
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            this(clientToken, env, variant, null, 8, null);
        }

        @JvmOverloads
        public Builder(@NotNull String clientToken, @NotNull String env) {
            Intrinsics.checkNotNullParameter((Object)clientToken, (String)"clientToken");
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            this(clientToken, env, null, null, 12, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/datadog/android/core/configuration/Configuration$Companion;", "", "()V", "DEFAULT_BACKPRESSURE_STRATEGY", "Lcom/datadog/android/core/configuration/BackPressureStrategy;", "getDEFAULT_BACKPRESSURE_STRATEGY$dd_sdk_android_core_release", "()Lcom/datadog/android/core/configuration/BackPressureStrategy;", "DEFAULT_BACKPRESSURE_THRESHOLD", "", "DEFAULT_CORE_CONFIG", "Lcom/datadog/android/core/configuration/Configuration$Core;", "getDEFAULT_CORE_CONFIG$dd_sdk_android_core_release", "()Lcom/datadog/android/core/configuration/Configuration$Core;", "NETWORK_REQUESTS_TRACKING_FEATURE_NAME", "", "NO_VARIANT", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackPressureStrategy getDEFAULT_BACKPRESSURE_STRATEGY$dd_sdk_android_core_release() {
            return DEFAULT_BACKPRESSURE_STRATEGY;
        }

        @NotNull
        public final Core getDEFAULT_CORE_CONFIG$dd_sdk_android_core_release() {
            return DEFAULT_CORE_CONFIG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b(\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\t\u00105\u001a\u00020\u0017H\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\u0019H\u00c6\u0003J\t\u00107\u001a\u00020\u001bH\u00c6\u0003J\t\u00108\u001a\u00020\u0003H\u00c6\u0003J\u001b\u00109\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006H\u00c6\u0003J\t\u0010:\u001a\u00020\u000bH\u00c6\u0003J\t\u0010;\u001a\u00020\rH\u00c6\u0003J\u000b\u0010<\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\t\u0010=\u001a\u00020\u0011H\u00c6\u0003J\u000b\u0010>\u001a\u0004\u0018\u00010\u0013H\u00c6\u0003J\t\u0010?\u001a\u00020\u0015H\u00c6\u0003J\u0099\u0001\u0010@\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001bH\u00c6\u0001J\u0013\u0010A\u001a\u00020\u00032\b\u0010B\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010C\u001a\u00020DH\u00d6\u0001J\t\u0010E\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010$R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u0006F"}, d2={"Lcom/datadog/android/core/configuration/Configuration$Core;", "", "needsClearTextHttp", "", "enableDeveloperModeWhenDebuggable", "firstPartyHostsWithHeaderTypes", "", "", "", "Lcom/datadog/android/trace/TracingHeaderType;", "batchSize", "Lcom/datadog/android/core/configuration/BatchSize;", "uploadFrequency", "Lcom/datadog/android/core/configuration/UploadFrequency;", "proxy", "Ljava/net/Proxy;", "proxyAuth", "Lokhttp3/Authenticator;", "encryption", "Lcom/datadog/android/security/Encryption;", "site", "Lcom/datadog/android/DatadogSite;", "batchProcessingLevel", "Lcom/datadog/android/core/configuration/BatchProcessingLevel;", "persistenceStrategyFactory", "Lcom/datadog/android/core/persistence/PersistenceStrategy$Factory;", "backpressureStrategy", "Lcom/datadog/android/core/configuration/BackPressureStrategy;", "(ZZLjava/util/Map;Lcom/datadog/android/core/configuration/BatchSize;Lcom/datadog/android/core/configuration/UploadFrequency;Ljava/net/Proxy;Lokhttp3/Authenticator;Lcom/datadog/android/security/Encryption;Lcom/datadog/android/DatadogSite;Lcom/datadog/android/core/configuration/BatchProcessingLevel;Lcom/datadog/android/core/persistence/PersistenceStrategy$Factory;Lcom/datadog/android/core/configuration/BackPressureStrategy;)V", "getBackpressureStrategy", "()Lcom/datadog/android/core/configuration/BackPressureStrategy;", "getBatchProcessingLevel", "()Lcom/datadog/android/core/configuration/BatchProcessingLevel;", "getBatchSize", "()Lcom/datadog/android/core/configuration/BatchSize;", "getEnableDeveloperModeWhenDebuggable", "()Z", "getEncryption", "()Lcom/datadog/android/security/Encryption;", "getFirstPartyHostsWithHeaderTypes", "()Ljava/util/Map;", "getNeedsClearTextHttp", "getPersistenceStrategyFactory", "()Lcom/datadog/android/core/persistence/PersistenceStrategy$Factory;", "getProxy", "()Ljava/net/Proxy;", "getProxyAuth", "()Lokhttp3/Authenticator;", "getSite", "()Lcom/datadog/android/DatadogSite;", "getUploadFrequency", "()Lcom/datadog/android/core/configuration/UploadFrequency;", "component1", "component10", "component11", "component12", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "dd-sdk-android-core_release"})
    public static final class Core {
        private final boolean needsClearTextHttp;
        private final boolean enableDeveloperModeWhenDebuggable;
        @NotNull
        private final Map<String, Set<TracingHeaderType>> firstPartyHostsWithHeaderTypes;
        @NotNull
        private final BatchSize batchSize;
        @NotNull
        private final UploadFrequency uploadFrequency;
        @Nullable
        private final Proxy proxy;
        @NotNull
        private final Authenticator proxyAuth;
        @Nullable
        private final Encryption encryption;
        @NotNull
        private final DatadogSite site;
        @NotNull
        private final BatchProcessingLevel batchProcessingLevel;
        @Nullable
        private final PersistenceStrategy.Factory persistenceStrategyFactory;
        @NotNull
        private final BackPressureStrategy backpressureStrategy;

        public Core(boolean needsClearTextHttp, boolean enableDeveloperModeWhenDebuggable, @NotNull Map<String, ? extends Set<? extends TracingHeaderType>> firstPartyHostsWithHeaderTypes, @NotNull BatchSize batchSize, @NotNull UploadFrequency uploadFrequency, @Nullable Proxy proxy, @NotNull Authenticator proxyAuth, @Nullable Encryption encryption, @NotNull DatadogSite site, @NotNull BatchProcessingLevel batchProcessingLevel, @Nullable PersistenceStrategy.Factory persistenceStrategyFactory, @NotNull BackPressureStrategy backpressureStrategy) {
            Intrinsics.checkNotNullParameter(firstPartyHostsWithHeaderTypes, (String)"firstPartyHostsWithHeaderTypes");
            Intrinsics.checkNotNullParameter((Object)((Object)batchSize), (String)"batchSize");
            Intrinsics.checkNotNullParameter((Object)((Object)uploadFrequency), (String)"uploadFrequency");
            Intrinsics.checkNotNullParameter((Object)proxyAuth, (String)"proxyAuth");
            Intrinsics.checkNotNullParameter((Object)((Object)site), (String)"site");
            Intrinsics.checkNotNullParameter((Object)((Object)batchProcessingLevel), (String)"batchProcessingLevel");
            Intrinsics.checkNotNullParameter((Object)backpressureStrategy, (String)"backpressureStrategy");
            this.needsClearTextHttp = needsClearTextHttp;
            this.enableDeveloperModeWhenDebuggable = enableDeveloperModeWhenDebuggable;
            this.firstPartyHostsWithHeaderTypes = firstPartyHostsWithHeaderTypes;
            this.batchSize = batchSize;
            this.uploadFrequency = uploadFrequency;
            this.proxy = proxy;
            this.proxyAuth = proxyAuth;
            this.encryption = encryption;
            this.site = site;
            this.batchProcessingLevel = batchProcessingLevel;
            this.persistenceStrategyFactory = persistenceStrategyFactory;
            this.backpressureStrategy = backpressureStrategy;
        }

        public final boolean getNeedsClearTextHttp() {
            return this.needsClearTextHttp;
        }

        public final boolean getEnableDeveloperModeWhenDebuggable() {
            return this.enableDeveloperModeWhenDebuggable;
        }

        @NotNull
        public final Map<String, Set<TracingHeaderType>> getFirstPartyHostsWithHeaderTypes() {
            return this.firstPartyHostsWithHeaderTypes;
        }

        @NotNull
        public final BatchSize getBatchSize() {
            return this.batchSize;
        }

        @NotNull
        public final UploadFrequency getUploadFrequency() {
            return this.uploadFrequency;
        }

        @Nullable
        public final Proxy getProxy() {
            return this.proxy;
        }

        @NotNull
        public final Authenticator getProxyAuth() {
            return this.proxyAuth;
        }

        @Nullable
        public final Encryption getEncryption() {
            return this.encryption;
        }

        @NotNull
        public final DatadogSite getSite() {
            return this.site;
        }

        @NotNull
        public final BatchProcessingLevel getBatchProcessingLevel() {
            return this.batchProcessingLevel;
        }

        @Nullable
        public final PersistenceStrategy.Factory getPersistenceStrategyFactory() {
            return this.persistenceStrategyFactory;
        }

        @NotNull
        public final BackPressureStrategy getBackpressureStrategy() {
            return this.backpressureStrategy;
        }

        public final boolean component1() {
            return this.needsClearTextHttp;
        }

        public final boolean component2() {
            return this.enableDeveloperModeWhenDebuggable;
        }

        @NotNull
        public final Map<String, Set<TracingHeaderType>> component3() {
            return this.firstPartyHostsWithHeaderTypes;
        }

        @NotNull
        public final BatchSize component4() {
            return this.batchSize;
        }

        @NotNull
        public final UploadFrequency component5() {
            return this.uploadFrequency;
        }

        @Nullable
        public final Proxy component6() {
            return this.proxy;
        }

        @NotNull
        public final Authenticator component7() {
            return this.proxyAuth;
        }

        @Nullable
        public final Encryption component8() {
            return this.encryption;
        }

        @NotNull
        public final DatadogSite component9() {
            return this.site;
        }

        @NotNull
        public final BatchProcessingLevel component10() {
            return this.batchProcessingLevel;
        }

        @Nullable
        public final PersistenceStrategy.Factory component11() {
            return this.persistenceStrategyFactory;
        }

        @NotNull
        public final BackPressureStrategy component12() {
            return this.backpressureStrategy;
        }

        @NotNull
        public final Core copy(boolean needsClearTextHttp, boolean enableDeveloperModeWhenDebuggable, @NotNull Map<String, ? extends Set<? extends TracingHeaderType>> firstPartyHostsWithHeaderTypes, @NotNull BatchSize batchSize, @NotNull UploadFrequency uploadFrequency, @Nullable Proxy proxy, @NotNull Authenticator proxyAuth, @Nullable Encryption encryption, @NotNull DatadogSite site, @NotNull BatchProcessingLevel batchProcessingLevel, @Nullable PersistenceStrategy.Factory persistenceStrategyFactory, @NotNull BackPressureStrategy backpressureStrategy) {
            Intrinsics.checkNotNullParameter(firstPartyHostsWithHeaderTypes, (String)"firstPartyHostsWithHeaderTypes");
            Intrinsics.checkNotNullParameter((Object)((Object)batchSize), (String)"batchSize");
            Intrinsics.checkNotNullParameter((Object)((Object)uploadFrequency), (String)"uploadFrequency");
            Intrinsics.checkNotNullParameter((Object)proxyAuth, (String)"proxyAuth");
            Intrinsics.checkNotNullParameter((Object)((Object)site), (String)"site");
            Intrinsics.checkNotNullParameter((Object)((Object)batchProcessingLevel), (String)"batchProcessingLevel");
            Intrinsics.checkNotNullParameter((Object)backpressureStrategy, (String)"backpressureStrategy");
            return new Core(needsClearTextHttp, enableDeveloperModeWhenDebuggable, firstPartyHostsWithHeaderTypes, batchSize, uploadFrequency, proxy, proxyAuth, encryption, site, batchProcessingLevel, persistenceStrategyFactory, backpressureStrategy);
        }

        public static /* synthetic */ Core copy$default(Core core, boolean bl, boolean bl2, Map map, BatchSize batchSize, UploadFrequency uploadFrequency, Proxy proxy, Authenticator authenticator, Encryption encryption, DatadogSite datadogSite, BatchProcessingLevel batchProcessingLevel, PersistenceStrategy.Factory factory, BackPressureStrategy backPressureStrategy, int n, Object object) {
            if ((n & 1) != 0) {
                bl = core.needsClearTextHttp;
            }
            if ((n & 2) != 0) {
                bl2 = core.enableDeveloperModeWhenDebuggable;
            }
            if ((n & 4) != 0) {
                map = core.firstPartyHostsWithHeaderTypes;
            }
            if ((n & 8) != 0) {
                batchSize = core.batchSize;
            }
            if ((n & 0x10) != 0) {
                uploadFrequency = core.uploadFrequency;
            }
            if ((n & 0x20) != 0) {
                proxy = core.proxy;
            }
            if ((n & 0x40) != 0) {
                authenticator = core.proxyAuth;
            }
            if ((n & 0x80) != 0) {
                encryption = core.encryption;
            }
            if ((n & 0x100) != 0) {
                datadogSite = core.site;
            }
            if ((n & 0x200) != 0) {
                batchProcessingLevel = core.batchProcessingLevel;
            }
            if ((n & 0x400) != 0) {
                factory = core.persistenceStrategyFactory;
            }
            if ((n & 0x800) != 0) {
                backPressureStrategy = core.backpressureStrategy;
            }
            return core.copy(bl, bl2, map, batchSize, uploadFrequency, proxy, authenticator, encryption, datadogSite, batchProcessingLevel, factory, backPressureStrategy);
        }

        @NotNull
        public String toString() {
            return "Core(needsClearTextHttp=" + this.needsClearTextHttp + ", enableDeveloperModeWhenDebuggable=" + this.enableDeveloperModeWhenDebuggable + ", firstPartyHostsWithHeaderTypes=" + this.firstPartyHostsWithHeaderTypes + ", batchSize=" + this.batchSize + ", uploadFrequency=" + this.uploadFrequency + ", proxy=" + this.proxy + ", proxyAuth=" + this.proxyAuth + ", encryption=" + this.encryption + ", site=" + this.site + ", batchProcessingLevel=" + this.batchProcessingLevel + ", persistenceStrategyFactory=" + this.persistenceStrategyFactory + ", backpressureStrategy=" + this.backpressureStrategy + ")";
        }

        public int hashCode() {
            int n;
            int result;
            int n2 = this.needsClearTextHttp ? 1 : 0;
            if (n2 != 0) {
                n2 = result = 1;
            }
            if ((n = this.enableDeveloperModeWhenDebuggable) != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + ((Object)this.firstPartyHostsWithHeaderTypes).hashCode();
            result = result * 31 + this.batchSize.hashCode();
            result = result * 31 + this.uploadFrequency.hashCode();
            result = result * 31 + (this.proxy == null ? 0 : this.proxy.hashCode());
            result = result * 31 + this.proxyAuth.hashCode();
            result = result * 31 + (this.encryption == null ? 0 : this.encryption.hashCode());
            result = result * 31 + this.site.hashCode();
            result = result * 31 + this.batchProcessingLevel.hashCode();
            result = result * 31 + (this.persistenceStrategyFactory == null ? 0 : this.persistenceStrategyFactory.hashCode());
            result = result * 31 + this.backpressureStrategy.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Core)) {
                return false;
            }
            Core core = (Core)other;
            if (this.needsClearTextHttp != core.needsClearTextHttp) {
                return false;
            }
            if (this.enableDeveloperModeWhenDebuggable != core.enableDeveloperModeWhenDebuggable) {
                return false;
            }
            if (!Intrinsics.areEqual(this.firstPartyHostsWithHeaderTypes, core.firstPartyHostsWithHeaderTypes)) {
                return false;
            }
            if (this.batchSize != core.batchSize) {
                return false;
            }
            if (this.uploadFrequency != core.uploadFrequency) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.proxy, (Object)core.proxy)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.proxyAuth, (Object)core.proxyAuth)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.encryption, (Object)core.encryption)) {
                return false;
            }
            if (this.site != core.site) {
                return false;
            }
            if (this.batchProcessingLevel != core.batchProcessingLevel) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.persistenceStrategyFactory, (Object)core.persistenceStrategyFactory)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.backpressureStrategy, (Object)core.backpressureStrategy);
        }
    }
}

