/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.core.LogcatLogHandler;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0002\u0010\bJP\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010 \u0018\u00010\u001fH\u0016JV\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00180\"2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010 \u0018\u00010\u001fH\u0016J,\u0010#\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010 0\u001fH\u0016J0\u0010$\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\b\u0010%\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002JH\u0010&\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\b\u0010%\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010 \u0018\u00010\u001fH\u0002J0\u0010'\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\b\u0010%\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002JF\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\b\u0010%\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\f\u0010+\u001a\u00020,*\u00020\u0016H\u0002J\f\u0010-\u001a\u00020\u000e*\u00020\u000eH\u0002R\u0016\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006/"}, d2={"Lcom/datadog/android/core/SdkInternalLogger;", "Lcom/datadog/android/api/InternalLogger;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "userLogHandlerFactory", "Lkotlin/Function0;", "Lcom/datadog/android/core/LogcatLogHandler;", "maintainerLogHandlerFactory", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "maintainerLogger", "getMaintainerLogger$dd_sdk_android_core_release", "()Lcom/datadog/android/core/LogcatLogHandler;", "onlyOnceMaintainerMessages", "", "", "onlyOnceTelemetryMessages", "onlyOnceUserMessages", "userLogger", "getUserLogger$dd_sdk_android_core_release", "log", "", "level", "Lcom/datadog/android/api/InternalLogger$Level;", "target", "Lcom/datadog/android/api/InternalLogger$Target;", "messageBuilder", "throwable", "", "onlyOnce", "", "additionalProperties", "", "", "targets", "", "logMetric", "logToMaintainer", "error", "logToTelemetry", "logToUser", "sendToLogHandler", "handler", "knownSingleMessages", "toLogLevel", "", "withSdkName", "Companion", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nSdkInternalLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkInternalLogger.kt\ncom/datadog/android/core/SdkInternalLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1855#2,2:235\n*S KotlinDebug\n*F\n+ 1 SdkInternalLogger.kt\ncom/datadog/android/core/SdkInternalLogger\n*L\n86#1:235,2\n*E\n"})
public final class SdkInternalLogger
implements InternalLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final LogcatLogHandler userLogger;
    @Nullable
    private final LogcatLogHandler maintainerLogger;
    @NotNull
    private final Set<String> onlyOnceUserMessages;
    @NotNull
    private final Set<String> onlyOnceMaintainerMessages;
    @NotNull
    private final Set<String> onlyOnceTelemetryMessages;
    @NotNull
    public static final String SDK_LOG_TAG = "DD_LOG";
    @NotNull
    public static final String DEV_LOG_TAG = "Datadog";
    @NotNull
    private static final String MESSAGE_KEY = "message";
    @NotNull
    private static final String TYPE_KEY = "type";
    @NotNull
    private static final String THROWABLE_KEY = "throwable";
    @NotNull
    private static final String ADDITIONAL_PROPERTIES_KEY = "additionalProperties";

    public SdkInternalLogger(@Nullable FeatureSdkCore sdkCore, @NotNull Function0<LogcatLogHandler> userLogHandlerFactory, @NotNull Function0<LogcatLogHandler> maintainerLogHandlerFactory) {
        Intrinsics.checkNotNullParameter(userLogHandlerFactory, (String)"userLogHandlerFactory");
        Intrinsics.checkNotNullParameter(maintainerLogHandlerFactory, (String)"maintainerLogHandlerFactory");
        this.sdkCore = sdkCore;
        this.userLogger = (LogcatLogHandler)userLogHandlerFactory.invoke();
        this.maintainerLogger = (LogcatLogHandler)maintainerLogHandlerFactory.invoke();
        this.onlyOnceUserMessages = new LinkedHashSet();
        this.onlyOnceMaintainerMessages = new LinkedHashSet();
        this.onlyOnceTelemetryMessages = new LinkedHashSet();
    }

    public /* synthetic */ SdkInternalLogger(FeatureSdkCore featureSdkCore, Function0 function0, Function0 function02, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function02 = 2.INSTANCE;
        }
        this(featureSdkCore, (Function0<LogcatLogHandler>)function0, (Function0<LogcatLogHandler>)function02);
    }

    @NotNull
    public final LogcatLogHandler getUserLogger$dd_sdk_android_core_release() {
        return this.userLogger;
    }

    @Nullable
    public final LogcatLogHandler getMaintainerLogger$dd_sdk_android_core_release() {
        return this.maintainerLogger;
    }

    @Override
    public void log(@NotNull InternalLogger.Level level, @NotNull InternalLogger.Target target, @NotNull Function0<String> messageBuilder, @Nullable Throwable throwable, boolean onlyOnce, @Nullable Map<String, ? extends Object> additionalProperties) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)((Object)target), (String)"target");
        Intrinsics.checkNotNullParameter(messageBuilder, (String)"messageBuilder");
        switch (WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
            case 1: {
                this.logToUser(level, messageBuilder, throwable, onlyOnce);
                break;
            }
            case 2: {
                this.logToMaintainer(level, messageBuilder, throwable, onlyOnce);
                break;
            }
            case 3: {
                this.logToTelemetry(level, messageBuilder, throwable, onlyOnce, additionalProperties);
            }
        }
    }

    @Override
    public void log(@NotNull InternalLogger.Level level, @NotNull List<? extends InternalLogger.Target> targets, @NotNull Function0<String> messageBuilder, @Nullable Throwable throwable, boolean onlyOnce, @Nullable Map<String, ? extends Object> additionalProperties) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter(messageBuilder, (String)"messageBuilder");
        Iterable $this$forEach$iv = targets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InternalLogger.Target it = (InternalLogger.Target)((Object)element$iv);
            boolean bl = false;
            this.log(level, it, messageBuilder, throwable, onlyOnce, additionalProperties);
        }
    }

    @Override
    public void logMetric(@NotNull Function0<String> messageBuilder, @NotNull Map<String, ? extends Object> additionalProperties) {
        Intrinsics.checkNotNullParameter(messageBuilder, (String)"messageBuilder");
        Intrinsics.checkNotNullParameter(additionalProperties, (String)ADDITIONAL_PROPERTIES_KEY);
        Object object = this.sdkCore;
        if (object == null || (object = object.getFeature("rum")) == null) {
            return;
        }
        Object rumFeature = object;
        String message = (String)messageBuilder.invoke();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)TYPE_KEY, (Object)"mobile_metric"), TuplesKt.to((Object)MESSAGE_KEY, (Object)message), TuplesKt.to((Object)ADDITIONAL_PROPERTIES_KEY, additionalProperties)};
        Map telemetryEvent = MapsKt.mapOf((Pair[])pairArray);
        rumFeature.sendEvent(telemetryEvent);
    }

    private final void logToUser(InternalLogger.Level level, Function0<String> messageBuilder, Throwable error, boolean onlyOnce) {
        this.sendToLogHandler(this.userLogger, level, messageBuilder, error, onlyOnce, this.onlyOnceUserMessages);
    }

    private final void logToMaintainer(InternalLogger.Level level, Function0<String> messageBuilder, Throwable error, boolean onlyOnce) {
        block0: {
            LogcatLogHandler logcatLogHandler = this.maintainerLogger;
            if (logcatLogHandler == null) break block0;
            LogcatLogHandler it = logcatLogHandler;
            boolean bl = false;
            this.sendToLogHandler(it, level, messageBuilder, error, onlyOnce, this.onlyOnceMaintainerMessages);
        }
    }

    private final void sendToLogHandler(LogcatLogHandler handler, InternalLogger.Level level, Function0<String> messageBuilder, Throwable error, boolean onlyOnce, Set<String> knownSingleMessages) {
        if (!handler.canLog(this.toLogLevel(level))) {
            return;
        }
        String message = this.withSdkName((String)messageBuilder.invoke());
        if (onlyOnce) {
            if (knownSingleMessages.contains(message)) {
                return;
            }
            knownSingleMessages.add(message);
        }
        handler.log(this.toLogLevel(level), message, error);
    }

    private final void logToTelemetry(InternalLogger.Level level, Function0<String> messageBuilder, Throwable error, boolean onlyOnce, Map<String, ? extends Object> additionalProperties) {
        Map map;
        Object object;
        Object object2 = this.sdkCore;
        if (object2 == null || (object2 = object2.getFeature("rum")) == null) {
            return;
        }
        Object rumFeature = object2;
        String message = (String)messageBuilder.invoke();
        if (onlyOnce) {
            if (this.onlyOnceTelemetryMessages.contains(message)) {
                return;
            }
            this.onlyOnceTelemetryMessages.add(message);
        }
        if (level == InternalLogger.Level.ERROR || level == InternalLogger.Level.WARN || error != null) {
            object = new Pair[]{TuplesKt.to((Object)TYPE_KEY, (Object)"telemetry_error"), TuplesKt.to((Object)MESSAGE_KEY, (Object)message), TuplesKt.to((Object)THROWABLE_KEY, (Object)error)};
            map = MapsKt.mapOf((Pair[])object);
        } else {
            object = additionalProperties;
            if (!(object == null || object.isEmpty())) {
                object = new Pair[]{TuplesKt.to((Object)TYPE_KEY, (Object)"telemetry_debug"), TuplesKt.to((Object)MESSAGE_KEY, (Object)message), TuplesKt.to((Object)ADDITIONAL_PROPERTIES_KEY, additionalProperties)};
                map = MapsKt.mapOf((Pair[])object);
            } else {
                object = new Pair[]{TuplesKt.to((Object)TYPE_KEY, (Object)"telemetry_debug"), TuplesKt.to((Object)MESSAGE_KEY, (Object)message)};
                map = MapsKt.mapOf((Pair[])object);
            }
        }
        Map telemetryEvent = map;
        rumFeature.sendEvent(telemetryEvent);
    }

    private final int toLogLevel(InternalLogger.Level $this$toLogLevel) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toLogLevel.ordinal()]) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 5;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private final String withSdkName(String $this$withSdkName) {
        FeatureSdkCore featureSdkCore = this.sdkCore;
        String instanceName = featureSdkCore != null ? featureSdkCore.getName() : null;
        return instanceName != null ? "[" + instanceName + "]: " + $this$withSdkName : $this$withSdkName;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/core/SdkInternalLogger$Companion;", "", "()V", "ADDITIONAL_PROPERTIES_KEY", "", "DEV_LOG_TAG", "MESSAGE_KEY", "SDK_LOG_TAG", "THROWABLE_KEY", "TYPE_KEY", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[InternalLogger.Target.values().length];
            try {
                nArray[InternalLogger.Target.USER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalLogger.Target.MAINTAINER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalLogger.Target.TELEMETRY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[InternalLogger.Level.values().length];
            try {
                nArray[InternalLogger.Level.VERBOSE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalLogger.Level.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalLogger.Level.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalLogger.Level.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalLogger.Level.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

