/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.time;

import com.datadog.android.core.internal.time.TimeProvider;
import com.lyft.kronos.Clock;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/core/internal/time/KronosTimeProvider;", "Lcom/datadog/android/core/internal/time/TimeProvider;", "clock", "Lcom/lyft/kronos/Clock;", "(Lcom/lyft/kronos/Clock;)V", "getDeviceTimestamp", "", "getServerOffsetMillis", "getServerOffsetNanos", "getServerTimestamp", "dd-sdk-android-core_release"})
public final class KronosTimeProvider
implements TimeProvider {
    @NotNull
    private final Clock clock;

    public KronosTimeProvider(@NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
    }

    @Override
    public long getDeviceTimestamp() {
        return System.currentTimeMillis();
    }

    @Override
    public long getServerTimestamp() {
        return this.clock.getCurrentTimeMs();
    }

    @Override
    public long getServerOffsetMillis() {
        long server = this.clock.getCurrentTimeMs();
        long device = System.currentTimeMillis();
        long delta = server - device;
        return delta;
    }

    @Override
    public long getServerOffsetNanos() {
        return TimeUnit.MILLISECONDS.toNanos(this.getServerOffsetMillis());
    }
}

