/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.persistence;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.storage.EventBatchWriter;
import com.datadog.android.api.storage.EventType;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.core.internal.persistence.file.FileExtKt;
import com.datadog.android.core.internal.persistence.file.FilePersistenceConfig;
import com.datadog.android.core.internal.persistence.file.FileReaderWriter;
import com.datadog.android.core.internal.persistence.file.FileWriter;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J\"\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0014H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/datadog/android/core/internal/persistence/FileEventBatchWriter;", "Lcom/datadog/android/api/storage/EventBatchWriter;", "batchFile", "Ljava/io/File;", "metadataFile", "eventsWriter", "Lcom/datadog/android/core/internal/persistence/file/FileWriter;", "Lcom/datadog/android/api/storage/RawBatchEvent;", "metadataReaderWriter", "Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;", "filePersistenceConfig", "Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Ljava/io/File;Ljava/io/File;Lcom/datadog/android/core/internal/persistence/file/FileWriter;Lcom/datadog/android/core/internal/persistence/file/FileReaderWriter;Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;Lcom/datadog/android/api/InternalLogger;)V", "checkEventSize", "", "eventSize", "", "currentMetadata", "", "write", "event", "batchMetadata", "eventType", "Lcom/datadog/android/api/storage/EventType;", "writeBatchMetadata", "", "metadata", "Companion", "dd-sdk-android-core_release"})
public final class FileEventBatchWriter
implements EventBatchWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File batchFile;
    @Nullable
    private final File metadataFile;
    @NotNull
    private final FileWriter<RawBatchEvent> eventsWriter;
    @NotNull
    private final FileReaderWriter metadataReaderWriter;
    @NotNull
    private final FilePersistenceConfig filePersistenceConfig;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    public static final String WARNING_METADATA_WRITE_FAILED = "Unable to write metadata file: %s";
    @NotNull
    public static final String ERROR_LARGE_DATA = "Can't write data with size %d (max item size is %d)";

    public FileEventBatchWriter(@NotNull File batchFile, @Nullable File metadataFile, @NotNull FileWriter<RawBatchEvent> eventsWriter, @NotNull FileReaderWriter metadataReaderWriter, @NotNull FilePersistenceConfig filePersistenceConfig, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)batchFile, (String)"batchFile");
        Intrinsics.checkNotNullParameter(eventsWriter, (String)"eventsWriter");
        Intrinsics.checkNotNullParameter((Object)metadataReaderWriter, (String)"metadataReaderWriter");
        Intrinsics.checkNotNullParameter((Object)filePersistenceConfig, (String)"filePersistenceConfig");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.batchFile = batchFile;
        this.metadataFile = metadataFile;
        this.eventsWriter = eventsWriter;
        this.metadataReaderWriter = metadataReaderWriter;
        this.filePersistenceConfig = filePersistenceConfig;
        this.internalLogger = internalLogger;
    }

    @Override
    @WorkerThread
    @Nullable
    public byte[] currentMetadata() {
        if (this.metadataFile == null || !FileExtKt.existsSafe(this.metadataFile, this.internalLogger)) {
            return null;
        }
        return (byte[])this.metadataReaderWriter.readData(this.metadataFile);
    }

    @Override
    @WorkerThread
    public boolean write(@NotNull RawBatchEvent event, @Nullable byte[] batchMetadata, @NotNull EventType eventType) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
        if (event.getData().length == 0) {
            bl = true;
        } else if (!this.checkEventSize(event.getData().length)) {
            bl = false;
        } else if (this.eventsWriter.writeData(this.batchFile, event, true)) {
            boolean bl2 = batchMetadata != null ? !(batchMetadata.length == 0) : false;
            if (bl2 && this.metadataFile != null) {
                this.writeBatchMetadata(this.metadataFile, batchMetadata);
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean checkEventSize(int eventSize) {
        if ((long)eventSize > this.filePersistenceConfig.getMaxItemSize()) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)new Function0<String>(eventSize, this){
                final /* synthetic */ int $eventSize;
                final /* synthetic */ FileEventBatchWriter this$0;
                {
                    this.$eventSize = $eventSize;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Can't write data with size %d (max item size is %d)";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$eventSize, FileEventBatchWriter.access$getFilePersistenceConfig$p(this.this$0).getMaxItemSize()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }, null, false, null, 56, null);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final void writeBatchMetadata(File metadataFile, byte[] metadata) {
        boolean result = this.metadataReaderWriter.writeData(metadataFile, metadata, false);
        if (!result) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)new Function0<String>(metadataFile){
                final /* synthetic */ File $metadataFile;
                {
                    this.$metadataFile = $metadataFile;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Unable to write metadata file: %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$metadataFile.getPath()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }, null, false, null, 56, null);
        }
    }

    public static final /* synthetic */ FilePersistenceConfig access$getFilePersistenceConfig$p(FileEventBatchWriter $this) {
        return $this.filePersistenceConfig;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/core/internal/persistence/FileEventBatchWriter$Companion;", "", "()V", "ERROR_LARGE_DATA", "", "WARNING_METADATA_WRITE_FAILED", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

