/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.data.upload;

import com.datadog.android.api.InternalLogger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u00132\u00020\u0001:\u000b\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001dB\u001b\b\u0004\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0001\n\u001e\u001f !\"#$%&'\u00a8\u0006("}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "", "shouldRetry", "", "code", "", "(ZI)V", "getCode", "()I", "getShouldRetry", "()Z", "logStatus", "", "context", "", "byteSize", "logger", "Lcom/datadog/android/api/InternalLogger;", "requestId", "Companion", "HttpClientError", "HttpClientRateLimiting", "HttpRedirection", "HttpServerError", "InvalidTokenError", "NetworkError", "RequestCreationError", "Success", "UnknownError", "UnknownStatus", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$HttpClientError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$HttpClientRateLimiting;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$HttpRedirection;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$HttpServerError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$InvalidTokenError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$NetworkError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$RequestCreationError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$Success;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$UnknownError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus$UnknownStatus;", "dd-sdk-android-core_release"})
public abstract class UploadStatus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean shouldRetry;
    private final int code;
    public static final int UNKNOWN_RESPONSE_CODE = 0;

    private UploadStatus(boolean shouldRetry, int code) {
        this.shouldRetry = shouldRetry;
        this.code = code;
    }

    public /* synthetic */ UploadStatus(boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(bl, n, null);
    }

    public final boolean getShouldRetry() {
        return this.shouldRetry;
    }

    public final int getCode() {
        return this.code;
    }

    public final void logStatus(@NotNull String context, int byteSize, @NotNull InternalLogger logger, @Nullable String requestId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        String batchInfo = requestId == null ? "Batch [" + byteSize + " bytes] (" + context + ")" : "Batch " + requestId + " [" + byteSize + " bytes] (" + context + ")";
        UploadStatus uploadStatus2 = this;
        if (uploadStatus2 instanceof NetworkError) {
            InternalLogger.DefaultImpls.log$default(logger, InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)new Function0<String>(batchInfo){
                final /* synthetic */ String $batchInfo;
                {
                    this.$batchInfo = $batchInfo;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$batchInfo + " failed because of a network error; we will retry later.";
                }
            }, null, false, null, 56, null);
        } else if (uploadStatus2 instanceof InvalidTokenError) {
            InternalLogger.DefaultImpls.log$default(logger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)new Function0<String>(batchInfo){
                final /* synthetic */ String $batchInfo;
                {
                    this.$batchInfo = $batchInfo;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$batchInfo + " failed because your token is invalid; the batch was dropped. Make sure that the provided token still exists and you're targeting the relevant Datadog site.";
                }
            }, null, false, null, 56, null);
        } else if (uploadStatus2 instanceof HttpRedirection) {
            InternalLogger.DefaultImpls.log$default(logger, InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)new Function0<String>(batchInfo){
                final /* synthetic */ String $batchInfo;
                {
                    this.$batchInfo = $batchInfo;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$batchInfo + " failed because of a network redirection; the batch was dropped.";
                }
            }, null, false, null, 56, null);
        } else if (uploadStatus2 instanceof HttpClientError) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(logger, InternalLogger.Level.ERROR, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(batchInfo){
                final /* synthetic */ String $batchInfo;
                {
                    this.$batchInfo = $batchInfo;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$batchInfo + " failed because of a processing error or invalid data; the batch was dropped.";
                }
            }, null, false, null, 56, null);
        } else if (uploadStatus2 instanceof HttpClientRateLimiting) {
            InternalLogger.Target[] targetArray = new InternalLogger.Target[]{InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default(logger, InternalLogger.Level.WARN, CollectionsKt.listOf((Object[])targetArray), (Function0)new Function0<String>(batchInfo){
                final /* synthetic */ String $batchInfo;
                {
                    this.$batchInfo = $batchInfo;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$batchInfo + " not uploaded due to rate limitation; we will retry later.";
                }
            }, null, false, null, 56, null);
        } else if (uploadStatus2 instanceof HttpServerError) {
            InternalLogger.DefaultImpls.log$default(logger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)new Function0<String>(batchInfo){
                final /* synthetic */ String $batchInfo;
                {
                    this.$batchInfo = $batchInfo;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$batchInfo + " failed because of a server processing error; we will retry later.";
                }
            }, null, false, null, 56, null);
        } else if (uploadStatus2 instanceof UnknownError) {
            InternalLogger.DefaultImpls.log$default(logger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)new Function0<String>(batchInfo, this){
                final /* synthetic */ String $batchInfo;
                final /* synthetic */ UploadStatus this$0;
                {
                    this.$batchInfo = $batchInfo;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$batchInfo + " failed because of an unknown error (status code = " + this.this$0.getCode() + "); the batch was dropped.";
                }
            }, null, false, null, 56, null);
        } else if (uploadStatus2 instanceof RequestCreationError) {
            InternalLogger.DefaultImpls.log$default(logger, InternalLogger.Level.ERROR, InternalLogger.Target.USER, (Function0)new Function0<String>(batchInfo){
                final /* synthetic */ String $batchInfo;
                {
                    this.$batchInfo = $batchInfo;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$batchInfo + " failed because of an error when creating the request; the batch was dropped.";
                }
            }, null, false, null, 56, null);
        } else if (uploadStatus2 instanceof Success) {
            InternalLogger.DefaultImpls.log$default(logger, InternalLogger.Level.INFO, InternalLogger.Target.USER, (Function0)new Function0<String>(batchInfo){
                final /* synthetic */ String $batchInfo;
                {
                    this.$batchInfo = $batchInfo;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$batchInfo + " sent successfully.";
                }
            }, null, false, null, 56, null);
        }
    }

    public static /* synthetic */ void logStatus$default(UploadStatus uploadStatus2, String string, int n, InternalLogger internalLogger, String string2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: logStatus");
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        uploadStatus2.logStatus(string, n, internalLogger, string2);
    }

    public /* synthetic */ UploadStatus(boolean shouldRetry, int code, DefaultConstructorMarker $constructor_marker) {
        this(shouldRetry, code);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$Companion;", "", "()V", "UNKNOWN_RESPONSE_CODE", "", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$HttpClientError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "responseCode", "", "(I)V", "dd-sdk-android-core_release"})
    public static final class HttpClientError
    extends UploadStatus {
        public HttpClientError(int responseCode) {
            super(false, responseCode, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$HttpClientRateLimiting;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "responseCode", "", "(I)V", "dd-sdk-android-core_release"})
    public static final class HttpClientRateLimiting
    extends UploadStatus {
        public HttpClientRateLimiting(int responseCode) {
            super(true, responseCode, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$HttpRedirection;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "responseCode", "", "(I)V", "dd-sdk-android-core_release"})
    public static final class HttpRedirection
    extends UploadStatus {
        public HttpRedirection(int responseCode) {
            super(false, responseCode, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$HttpServerError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "responseCode", "", "(I)V", "dd-sdk-android-core_release"})
    public static final class HttpServerError
    extends UploadStatus {
        public HttpServerError(int responseCode) {
            super(true, responseCode, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$InvalidTokenError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "responseCode", "", "(I)V", "dd-sdk-android-core_release"})
    public static final class InvalidTokenError
    extends UploadStatus {
        public InvalidTokenError(int responseCode) {
            super(false, responseCode, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$NetworkError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "()V", "dd-sdk-android-core_release"})
    public static final class NetworkError
    extends UploadStatus {
        @NotNull
        public static final NetworkError INSTANCE = new NetworkError();

        private NetworkError() {
            super(true, 0, 2, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$RequestCreationError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "()V", "dd-sdk-android-core_release"})
    public static final class RequestCreationError
    extends UploadStatus {
        @NotNull
        public static final RequestCreationError INSTANCE = new RequestCreationError();

        private RequestCreationError() {
            super(false, 0, 2, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$Success;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "responseCode", "", "(I)V", "dd-sdk-android-core_release"})
    public static final class Success
    extends UploadStatus {
        public Success(int responseCode) {
            super(false, responseCode, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$UnknownError;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "responseCode", "", "(I)V", "dd-sdk-android-core_release"})
    public static final class UnknownError
    extends UploadStatus {
        public UnknownError(int responseCode) {
            super(false, responseCode, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/datadog/android/core/internal/data/upload/UploadStatus$UnknownStatus;", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "()V", "dd-sdk-android-core_release"})
    public static final class UnknownStatus
    extends UploadStatus {
        @NotNull
        public static final UnknownStatus INSTANCE = new UnknownStatus();

        private UnknownStatus() {
            super(false, 0, null);
        }
    }
}

