/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal.data.upload;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.context.NetworkInfo;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.core.internal.ContextProvider;
import com.datadog.android.core.internal.configuration.DataUploadConfiguration;
import com.datadog.android.core.internal.data.upload.DataUploader;
import com.datadog.android.core.internal.data.upload.UploadRunnable;
import com.datadog.android.core.internal.data.upload.UploadStatus;
import com.datadog.android.core.internal.metrics.RemovalReason;
import com.datadog.android.core.internal.net.info.NetworkInfoProvider;
import com.datadog.android.core.internal.persistence.BatchData;
import com.datadog.android.core.internal.persistence.BatchId;
import com.datadog.android.core.internal.persistence.Storage;
import com.datadog.android.core.internal.system.SystemInfo;
import com.datadog.android.core.internal.system.SystemInfoProvider;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 92\u00020\u0001:\u00019BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J0\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\b\u0010,\u001a\u0004\u0018\u00010-H\u0003J\b\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020$H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&H\u0003J\b\u00103\u001a\u00020/H\u0002J\b\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u000205H\u0002J\b\u00107\u001a\u00020/H\u0017J\b\u00108\u001a\u00020/H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001cX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0018R\u0014\u0010!\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0018R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/datadog/android/core/internal/data/upload/DataUploadRunnable;", "Lcom/datadog/android/core/internal/data/upload/UploadRunnable;", "featureName", "", "threadPoolExecutor", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "storage", "Lcom/datadog/android/core/internal/persistence/Storage;", "dataUploader", "Lcom/datadog/android/core/internal/data/upload/DataUploader;", "contextProvider", "Lcom/datadog/android/core/internal/ContextProvider;", "networkInfoProvider", "Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;", "systemInfoProvider", "Lcom/datadog/android/core/internal/system/SystemInfoProvider;", "uploadConfiguration", "Lcom/datadog/android/core/internal/configuration/DataUploadConfiguration;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Ljava/lang/String;Ljava/util/concurrent/ScheduledThreadPoolExecutor;Lcom/datadog/android/core/internal/persistence/Storage;Lcom/datadog/android/core/internal/data/upload/DataUploader;Lcom/datadog/android/core/internal/ContextProvider;Lcom/datadog/android/core/internal/net/info/NetworkInfoProvider;Lcom/datadog/android/core/internal/system/SystemInfoProvider;Lcom/datadog/android/core/internal/configuration/DataUploadConfiguration;Lcom/datadog/android/api/InternalLogger;)V", "currentDelayIntervalMs", "", "getCurrentDelayIntervalMs$dd_sdk_android_core_release", "()J", "setCurrentDelayIntervalMs$dd_sdk_android_core_release", "(J)V", "maxBatchesPerJob", "", "getMaxBatchesPerJob$dd_sdk_android_core_release", "()I", "maxDelayMs", "getMaxDelayMs$dd_sdk_android_core_release", "minDelayMs", "getMinDelayMs$dd_sdk_android_core_release", "consumeBatch", "Lcom/datadog/android/core/internal/data/upload/UploadStatus;", "context", "Lcom/datadog/android/api/context/DatadogContext;", "batchId", "Lcom/datadog/android/core/internal/persistence/BatchId;", "batch", "", "Lcom/datadog/android/api/storage/RawBatchEvent;", "batchMeta", "", "decreaseInterval", "", "handleBatchConsumingJobFrequency", "lastBatchUploadStatus", "handleNextBatch", "increaseInterval", "isNetworkAvailable", "", "isSystemReady", "run", "scheduleNextUpload", "Companion", "dd-sdk-android-core_release"})
public final class DataUploadRunnable
implements UploadRunnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String featureName;
    @NotNull
    private final ScheduledThreadPoolExecutor threadPoolExecutor;
    @NotNull
    private final Storage storage;
    @NotNull
    private final DataUploader dataUploader;
    @NotNull
    private final ContextProvider contextProvider;
    @NotNull
    private final NetworkInfoProvider networkInfoProvider;
    @NotNull
    private final SystemInfoProvider systemInfoProvider;
    @NotNull
    private final InternalLogger internalLogger;
    private long currentDelayIntervalMs;
    private final long minDelayMs;
    private final long maxDelayMs;
    private final int maxBatchesPerJob;
    public static final int LOW_BATTERY_THRESHOLD = 10;
    public static final double DECREASE_PERCENT = 0.9;
    public static final double INCREASE_PERCENT = 1.1;

    public DataUploadRunnable(@NotNull String featureName, @NotNull ScheduledThreadPoolExecutor threadPoolExecutor, @NotNull Storage storage, @NotNull DataUploader dataUploader, @NotNull ContextProvider contextProvider, @NotNull NetworkInfoProvider networkInfoProvider, @NotNull SystemInfoProvider systemInfoProvider, @NotNull DataUploadConfiguration uploadConfiguration, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter((Object)threadPoolExecutor, (String)"threadPoolExecutor");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)dataUploader, (String)"dataUploader");
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        Intrinsics.checkNotNullParameter((Object)networkInfoProvider, (String)"networkInfoProvider");
        Intrinsics.checkNotNullParameter((Object)systemInfoProvider, (String)"systemInfoProvider");
        Intrinsics.checkNotNullParameter((Object)uploadConfiguration, (String)"uploadConfiguration");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.featureName = featureName;
        this.threadPoolExecutor = threadPoolExecutor;
        this.storage = storage;
        this.dataUploader = dataUploader;
        this.contextProvider = contextProvider;
        this.networkInfoProvider = networkInfoProvider;
        this.systemInfoProvider = systemInfoProvider;
        this.internalLogger = internalLogger;
        this.currentDelayIntervalMs = uploadConfiguration.getDefaultDelayMs$dd_sdk_android_core_release();
        this.minDelayMs = uploadConfiguration.getMinDelayMs$dd_sdk_android_core_release();
        this.maxDelayMs = uploadConfiguration.getMaxDelayMs$dd_sdk_android_core_release();
        this.maxBatchesPerJob = uploadConfiguration.getMaxBatchesPerUploadJob$dd_sdk_android_core_release();
    }

    public final long getCurrentDelayIntervalMs$dd_sdk_android_core_release() {
        return this.currentDelayIntervalMs;
    }

    public final void setCurrentDelayIntervalMs$dd_sdk_android_core_release(long l) {
        this.currentDelayIntervalMs = l;
    }

    public final long getMinDelayMs$dd_sdk_android_core_release() {
        return this.minDelayMs;
    }

    public final long getMaxDelayMs$dd_sdk_android_core_release() {
        return this.maxDelayMs;
    }

    public final int getMaxBatchesPerJob$dd_sdk_android_core_release() {
        return this.maxBatchesPerJob;
    }

    @Override
    @WorkerThread
    public void run() {
        if (this.isNetworkAvailable() && this.isSystemReady()) {
            DatadogContext context = this.contextProvider.getContext();
            int batchConsumerAvailableAttempts = this.maxBatchesPerJob;
            UploadStatus lastBatchUploadStatus = null;
            do {
                lastBatchUploadStatus = this.handleNextBatch(context);
            } while (--batchConsumerAvailableAttempts > 0 && lastBatchUploadStatus instanceof UploadStatus.Success);
            if (lastBatchUploadStatus != null) {
                this.handleBatchConsumingJobFrequency(lastBatchUploadStatus);
            } else {
                this.increaseInterval();
            }
        }
        this.scheduleNextUpload();
    }

    private final void handleBatchConsumingJobFrequency(UploadStatus lastBatchUploadStatus) {
        if (lastBatchUploadStatus.getShouldRetry()) {
            this.increaseInterval();
        } else {
            this.decreaseInterval();
        }
    }

    @WorkerThread
    private final UploadStatus handleNextBatch(DatadogContext context) {
        UploadStatus uploadStatus2 = null;
        BatchData nextBatchData = this.storage.readNextBatch();
        if (nextBatchData != null) {
            uploadStatus2 = this.consumeBatch(context, nextBatchData.getId(), nextBatchData.getData(), nextBatchData.getMetadata());
        }
        return uploadStatus2;
    }

    private final boolean isNetworkAvailable() {
        NetworkInfo networkInfo = this.networkInfoProvider.getLatestNetworkInfo();
        return networkInfo.getConnectivity() != NetworkInfo.Connectivity.NETWORK_NOT_CONNECTED;
    }

    private final boolean isSystemReady() {
        SystemInfo systemInfo = this.systemInfoProvider.getLatestSystemInfo();
        boolean hasEnoughPower = systemInfo.getBatteryFullOrCharging() || systemInfo.getOnExternalPowerSource() || systemInfo.getBatteryLevel() > 10;
        return hasEnoughPower && !systemInfo.getPowerSaveMode();
    }

    private final void scheduleNextUpload() {
        this.threadPoolExecutor.remove(this);
        ConcurrencyExtKt.scheduleSafe(this.threadPoolExecutor, this.featureName + ": data upload", this.currentDelayIntervalMs, TimeUnit.MILLISECONDS, this.internalLogger, this);
    }

    @WorkerThread
    private final UploadStatus consumeBatch(DatadogContext context, BatchId batchId, List<RawBatchEvent> batch, byte[] batchMeta) {
        UploadStatus status = this.dataUploader.upload(context, batch, batchMeta);
        RemovalReason removalReason = status instanceof UploadStatus.RequestCreationError ? (RemovalReason)RemovalReason.Invalid.INSTANCE : (RemovalReason)new RemovalReason.IntakeCode(status.getCode());
        this.storage.confirmBatchRead(batchId, removalReason, !status.getShouldRetry());
        return status;
    }

    private final void decreaseInterval() {
        this.currentDelayIntervalMs = Math.max(this.minDelayMs, MathKt.roundToLong((double)((double)this.currentDelayIntervalMs * 0.9)));
    }

    private final void increaseInterval() {
        this.currentDelayIntervalMs = Math.min(this.maxDelayMs, MathKt.roundToLong((double)((double)this.currentDelayIntervalMs * 1.1)));
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/android/core/internal/data/upload/DataUploadRunnable$Companion;", "", "()V", "DECREASE_PERCENT", "", "INCREASE_PERCENT", "LOW_BATTERY_THRESHOLD", "", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

