/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core.internal;

import android.app.Application;
import android.content.Context;
import androidx.annotation.AnyThread;
import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.feature.Feature;
import com.datadog.android.api.feature.FeatureContextUpdateReceiver;
import com.datadog.android.api.feature.FeatureEventReceiver;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.StorageBackedFeature;
import com.datadog.android.api.net.RequestFactory;
import com.datadog.android.api.storage.EventBatchWriter;
import com.datadog.android.api.storage.FeatureStorageConfiguration;
import com.datadog.android.core.configuration.BatchProcessingLevel;
import com.datadog.android.core.configuration.UploadFrequency;
import com.datadog.android.core.internal.ContextProvider;
import com.datadog.android.core.internal.CoreFeature;
import com.datadog.android.core.internal.NoOpContextProvider;
import com.datadog.android.core.internal.configuration.DataUploadConfiguration;
import com.datadog.android.core.internal.data.upload.DataFlusher;
import com.datadog.android.core.internal.data.upload.DataOkHttpUploader;
import com.datadog.android.core.internal.data.upload.DataUploadScheduler;
import com.datadog.android.core.internal.data.upload.DataUploader;
import com.datadog.android.core.internal.data.upload.NoOpDataUploader;
import com.datadog.android.core.internal.data.upload.NoOpUploadScheduler;
import com.datadog.android.core.internal.data.upload.UploadScheduler;
import com.datadog.android.core.internal.lifecycle.ProcessLifecycleMonitor;
import com.datadog.android.core.internal.metrics.BatchMetricsDispatcher;
import com.datadog.android.core.internal.metrics.MetricsDispatcher;
import com.datadog.android.core.internal.metrics.NoOpMetricsDispatcher;
import com.datadog.android.core.internal.persistence.AbstractStorage;
import com.datadog.android.core.internal.persistence.ConsentAwareStorage;
import com.datadog.android.core.internal.persistence.NoOpStorage;
import com.datadog.android.core.internal.persistence.Storage;
import com.datadog.android.core.internal.persistence.file.FileMover;
import com.datadog.android.core.internal.persistence.file.FileOrchestrator;
import com.datadog.android.core.internal.persistence.file.FilePersistenceConfig;
import com.datadog.android.core.internal.persistence.file.FileReaderWriter;
import com.datadog.android.core.internal.persistence.file.NoOpFileOrchestrator;
import com.datadog.android.core.internal.persistence.file.advanced.FeatureFileOrchestrator;
import com.datadog.android.core.internal.persistence.file.batch.BatchFileReaderWriter;
import com.datadog.android.core.persistence.PersistenceStrategy;
import com.datadog.android.privacy.TrackingConsentProviderCallback;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 x2\u00020\u0001:\u0001xB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010E\u001a\u00020FH\u0007J(\u0010G\u001a\u0002022\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020I2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0002J\u0018\u0010O\u001a\u0002022\u0006\u0010J\u001a\u00020I2\u0006\u0010P\u001a\u00020QH\u0002J\u0010\u0010R\u001a\u00020>2\u0006\u0010S\u001a\u00020TH\u0002J\r\u0010U\u001a\u00020FH\u0001\u00a2\u0006\u0002\bVJ\u0016\u0010W\u001a\u00020F2\u0006\u0010X\u001a\u00020Y2\u0006\u0010H\u001a\u00020IJ\u0006\u0010Z\u001a\u00020[J+\u0010\\\u001a\u00020F2\u0006\u0010J\u001a\u00020I2\u0014\u0010X\u001a\u0010\u0012\u0004\u0012\u00020I\u0012\u0006\u0012\u0004\u0018\u00010^0]H\u0000\u00a2\u0006\u0002\b_J2\u0010`\u001a\u0002022\u0006\u0010a\u001a\u00020b2\u0006\u0010\u0004\u001a\u00020c2\u0006\u0010X\u001a\u00020Y2\u0006\u0010H\u001a\u00020I2\b\u0010M\u001a\u0004\u0018\u00010NH\u0002J\u0015\u0010d\u001a\u00020F2\u0006\u0010e\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\bfJ\u0010\u0010g\u001a\u00020F2\u0006\u0010h\u001a\u00020^H\u0016J\u0015\u0010i\u001a\u00020F2\u0006\u0010e\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\bjJ \u0010k\u001a\u00020F2\u0006\u0010a\u001a\u00020b2\u0006\u0010P\u001a\u00020Q2\u0006\u0010X\u001a\u00020YH\u0002J\u0018\u0010l\u001a\u00020F2\u0006\u0010m\u001a\u00020c2\u0006\u0010n\u001a\u00020bH\u0002J\u0006\u0010o\u001a\u00020FJ\u0017\u0010p\u001a\u0002Hq\"\b\b\u0000\u0010q*\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010DJ*\u0010r\u001a\u00020F2\u0006\u0010s\u001a\u00020[2\u0018\u0010t\u001a\u0014\u0012\u0004\u0012\u00020v\u0012\u0004\u0012\u00020w\u0012\u0004\u0012\u00020F0uH\u0016R>\u0010\t\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\r0\nX\u0080\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001c\u0010+\u001a\u0004\u0018\u00010,X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u000202X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u000208X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020>X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010D\u00a8\u0006y"}, d2={"Lcom/datadog/android/core/internal/SdkFeature;", "Lcom/datadog/android/api/feature/FeatureScope;", "coreFeature", "Lcom/datadog/android/core/internal/CoreFeature;", "wrappedFeature", "Lcom/datadog/android/api/feature/Feature;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/core/internal/CoreFeature;Lcom/datadog/android/api/feature/Feature;Lcom/datadog/android/api/InternalLogger;)V", "contextUpdateListeners", "", "Lcom/datadog/android/api/feature/FeatureContextUpdateReceiver;", "kotlin.jvm.PlatformType", "", "getContextUpdateListeners$dd_sdk_android_core_release$annotations", "()V", "getContextUpdateListeners$dd_sdk_android_core_release", "()Ljava/util/Set;", "getCoreFeature$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/CoreFeature;", "eventReceiver", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/datadog/android/api/feature/FeatureEventReceiver;", "getEventReceiver$dd_sdk_android_core_release", "()Ljava/util/concurrent/atomic/AtomicReference;", "fileOrchestrator", "Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "getFileOrchestrator$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;", "setFileOrchestrator$dd_sdk_android_core_release", "(Lcom/datadog/android/core/internal/persistence/file/FileOrchestrator;)V", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized$dd_sdk_android_core_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "getInternalLogger$dd_sdk_android_core_release", "()Lcom/datadog/android/api/InternalLogger;", "metricsDispatcher", "Lcom/datadog/android/core/internal/metrics/MetricsDispatcher;", "getMetricsDispatcher$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/metrics/MetricsDispatcher;", "setMetricsDispatcher$dd_sdk_android_core_release", "(Lcom/datadog/android/core/internal/metrics/MetricsDispatcher;)V", "processLifecycleMonitor", "Lcom/datadog/android/core/internal/lifecycle/ProcessLifecycleMonitor;", "getProcessLifecycleMonitor$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/lifecycle/ProcessLifecycleMonitor;", "setProcessLifecycleMonitor$dd_sdk_android_core_release", "(Lcom/datadog/android/core/internal/lifecycle/ProcessLifecycleMonitor;)V", "storage", "Lcom/datadog/android/core/internal/persistence/Storage;", "getStorage$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/persistence/Storage;", "setStorage$dd_sdk_android_core_release", "(Lcom/datadog/android/core/internal/persistence/Storage;)V", "uploadScheduler", "Lcom/datadog/android/core/internal/data/upload/UploadScheduler;", "getUploadScheduler$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/data/upload/UploadScheduler;", "setUploadScheduler$dd_sdk_android_core_release", "(Lcom/datadog/android/core/internal/data/upload/UploadScheduler;)V", "uploader", "Lcom/datadog/android/core/internal/data/upload/DataUploader;", "getUploader$dd_sdk_android_core_release", "()Lcom/datadog/android/core/internal/data/upload/DataUploader;", "setUploader$dd_sdk_android_core_release", "(Lcom/datadog/android/core/internal/data/upload/DataUploader;)V", "getWrappedFeature$dd_sdk_android_core_release", "()Lcom/datadog/android/api/feature/Feature;", "clearAllData", "", "createCustomStorage", "instanceId", "", "featureName", "storageConfiguration", "Lcom/datadog/android/api/storage/FeatureStorageConfiguration;", "persistenceStrategyFactory", "Lcom/datadog/android/core/persistence/PersistenceStrategy$Factory;", "createFileStorage", "filePersistenceConfig", "Lcom/datadog/android/core/internal/persistence/file/FilePersistenceConfig;", "createUploader", "requestFactory", "Lcom/datadog/android/api/net/RequestFactory;", "flushStoredData", "flushStoredData$dd_sdk_android_core_release", "initialize", "context", "Landroid/content/Context;", "isInitialized", "", "notifyContextUpdated", "", "", "notifyContextUpdated$dd_sdk_android_core_release", "prepareStorage", "dataUploadConfiguration", "Lcom/datadog/android/core/internal/configuration/DataUploadConfiguration;", "Lcom/datadog/android/api/feature/StorageBackedFeature;", "removeContextUpdateListener", "listener", "removeContextUpdateListener$dd_sdk_android_core_release", "sendEvent", "event", "setContextUpdateListener", "setContextUpdateListener$dd_sdk_android_core_release", "setupMetricsDispatcher", "setupUploader", "feature", "uploadConfiguration", "stop", "unwrap", "T", "withWriteContext", "forceNewBatch", "callback", "Lkotlin/Function2;", "Lcom/datadog/android/api/context/DatadogContext;", "Lcom/datadog/android/api/storage/EventBatchWriter;", "Companion", "dd-sdk-android-core_release"})
@SourceDebugExtension(value={"SMAP\nSdkFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkFeature.kt\ncom/datadog/android/core/internal/SdkFeature\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,371:1\n1855#2,2:372\n*S KotlinDebug\n*F\n+ 1 SdkFeature.kt\ncom/datadog/android/core/internal/SdkFeature\n*L\n183#1:372,2\n*E\n"})
public final class SdkFeature
implements FeatureScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoreFeature coreFeature;
    @NotNull
    private final Feature wrappedFeature;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final AtomicBoolean initialized;
    private final Set<FeatureContextUpdateReceiver> contextUpdateListeners;
    @NotNull
    private final AtomicReference<FeatureEventReceiver> eventReceiver;
    @NotNull
    private Storage storage;
    @NotNull
    private DataUploader uploader;
    @NotNull
    private UploadScheduler uploadScheduler;
    @NotNull
    private FileOrchestrator fileOrchestrator;
    @NotNull
    private MetricsDispatcher metricsDispatcher;
    @Nullable
    private ProcessLifecycleMonitor processLifecycleMonitor;
    @NotNull
    public static final String CONTEXT_UPDATE_LISTENER_ALREADY_EXISTS = "Feature \"%s\" already has this listener registered.";
    @NotNull
    public static final String NO_EVENT_RECEIVER = "Feature \"%s\" has no event receiver registered, ignoring event.";

    public SdkFeature(@NotNull CoreFeature coreFeature, @NotNull Feature wrappedFeature, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)coreFeature, (String)"coreFeature");
        Intrinsics.checkNotNullParameter((Object)wrappedFeature, (String)"wrappedFeature");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.coreFeature = coreFeature;
        this.wrappedFeature = wrappedFeature;
        this.internalLogger = internalLogger;
        this.initialized = new AtomicBoolean(false);
        this.contextUpdateListeners = Collections.newSetFromMap(new ConcurrentHashMap());
        this.eventReceiver = new AtomicReference<Object>(null);
        this.storage = new NoOpStorage();
        this.uploader = new NoOpDataUploader();
        this.uploadScheduler = new NoOpUploadScheduler();
        this.fileOrchestrator = new NoOpFileOrchestrator();
        this.metricsDispatcher = new NoOpMetricsDispatcher();
    }

    @NotNull
    public final CoreFeature getCoreFeature$dd_sdk_android_core_release() {
        return this.coreFeature;
    }

    @NotNull
    public final Feature getWrappedFeature$dd_sdk_android_core_release() {
        return this.wrappedFeature;
    }

    @NotNull
    public final InternalLogger getInternalLogger$dd_sdk_android_core_release() {
        return this.internalLogger;
    }

    @NotNull
    public final AtomicBoolean getInitialized$dd_sdk_android_core_release() {
        return this.initialized;
    }

    public final Set<FeatureContextUpdateReceiver> getContextUpdateListeners$dd_sdk_android_core_release() {
        return this.contextUpdateListeners;
    }

    public static /* synthetic */ void getContextUpdateListeners$dd_sdk_android_core_release$annotations() {
    }

    @NotNull
    public final AtomicReference<FeatureEventReceiver> getEventReceiver$dd_sdk_android_core_release() {
        return this.eventReceiver;
    }

    @NotNull
    public final Storage getStorage$dd_sdk_android_core_release() {
        return this.storage;
    }

    public final void setStorage$dd_sdk_android_core_release(@NotNull Storage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"<set-?>");
        this.storage = storage;
    }

    @NotNull
    public final DataUploader getUploader$dd_sdk_android_core_release() {
        return this.uploader;
    }

    public final void setUploader$dd_sdk_android_core_release(@NotNull DataUploader dataUploader) {
        Intrinsics.checkNotNullParameter((Object)dataUploader, (String)"<set-?>");
        this.uploader = dataUploader;
    }

    @NotNull
    public final UploadScheduler getUploadScheduler$dd_sdk_android_core_release() {
        return this.uploadScheduler;
    }

    public final void setUploadScheduler$dd_sdk_android_core_release(@NotNull UploadScheduler uploadScheduler) {
        Intrinsics.checkNotNullParameter((Object)uploadScheduler, (String)"<set-?>");
        this.uploadScheduler = uploadScheduler;
    }

    @NotNull
    public final FileOrchestrator getFileOrchestrator$dd_sdk_android_core_release() {
        return this.fileOrchestrator;
    }

    public final void setFileOrchestrator$dd_sdk_android_core_release(@NotNull FileOrchestrator fileOrchestrator) {
        Intrinsics.checkNotNullParameter((Object)fileOrchestrator, (String)"<set-?>");
        this.fileOrchestrator = fileOrchestrator;
    }

    @NotNull
    public final MetricsDispatcher getMetricsDispatcher$dd_sdk_android_core_release() {
        return this.metricsDispatcher;
    }

    public final void setMetricsDispatcher$dd_sdk_android_core_release(@NotNull MetricsDispatcher metricsDispatcher) {
        Intrinsics.checkNotNullParameter((Object)metricsDispatcher, (String)"<set-?>");
        this.metricsDispatcher = metricsDispatcher;
    }

    @Nullable
    public final ProcessLifecycleMonitor getProcessLifecycleMonitor$dd_sdk_android_core_release() {
        return this.processLifecycleMonitor;
    }

    public final void setProcessLifecycleMonitor$dd_sdk_android_core_release(@Nullable ProcessLifecycleMonitor processLifecycleMonitor) {
        this.processLifecycleMonitor = processLifecycleMonitor;
    }

    public final void initialize(@NotNull Context context, @NotNull String instanceId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)instanceId, (String)"instanceId");
        if (this.initialized.get()) {
            return;
        }
        DataUploadConfiguration dataUploadConfiguration = null;
        if (this.wrappedFeature instanceof StorageBackedFeature) {
            UploadFrequency uploadFrequency = this.coreFeature.getUploadFrequency$dd_sdk_android_core_release();
            BatchProcessingLevel batchProcessingLevel = this.coreFeature.getBatchProcessingLevel$dd_sdk_android_core_release();
            dataUploadConfiguration = new DataUploadConfiguration(uploadFrequency, batchProcessingLevel.getMaxBatchesPerUploadJob());
            this.storage = this.prepareStorage(dataUploadConfiguration, (StorageBackedFeature)this.wrappedFeature, context, instanceId, this.coreFeature.getPersistenceStrategyFactory$dd_sdk_android_core_release());
        }
        this.wrappedFeature.onInitialize(context);
        if (this.wrappedFeature instanceof StorageBackedFeature && dataUploadConfiguration != null) {
            this.setupUploader((StorageBackedFeature)this.wrappedFeature, dataUploadConfiguration);
        }
        if (this.wrappedFeature instanceof TrackingConsentProviderCallback) {
            this.coreFeature.getTrackingConsentProvider$dd_sdk_android_core_release().registerCallback((TrackingConsentProviderCallback)((Object)this.wrappedFeature));
        }
        this.initialized.set(true);
        this.uploadScheduler.startScheduling();
    }

    public final boolean isInitialized() {
        return this.initialized.get();
    }

    @AnyThread
    public final void clearAllData() {
        this.storage.dropAll();
    }

    public final void stop() {
        if (this.initialized.get()) {
            Application application;
            this.wrappedFeature.onStop();
            if (this.wrappedFeature instanceof TrackingConsentProviderCallback) {
                this.coreFeature.getTrackingConsentProvider$dd_sdk_android_core_release().unregisterCallback((TrackingConsentProviderCallback)((Object)this.wrappedFeature));
            }
            this.uploadScheduler.stopScheduling();
            this.uploadScheduler = new NoOpUploadScheduler();
            this.storage = new NoOpStorage();
            this.uploader = new NoOpDataUploader();
            this.fileOrchestrator = new NoOpFileOrchestrator();
            this.metricsDispatcher = new NoOpMetricsDispatcher();
            Object t = this.coreFeature.getContextRef$dd_sdk_android_core_release().get();
            Application application2 = application = t instanceof Application ? (Application)t : null;
            if (application != null) {
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.processLifecycleMonitor);
            }
            this.processLifecycleMonitor = null;
            this.initialized.set(false);
        }
    }

    @Override
    public void withWriteContext(boolean forceNewBatch, @NotNull Function2<? super DatadogContext, ? super EventBatchWriter, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ContextProvider contextProvider = this.coreFeature.getContextProvider$dd_sdk_android_core_release();
        if (contextProvider instanceof NoOpContextProvider) {
            return;
        }
        DatadogContext context = contextProvider.getContext();
        this.storage.writeCurrentBatch(context, forceNewBatch, (Function1<? super EventBatchWriter, Unit>)((Function1)new Function1<EventBatchWriter, Unit>(callback, context){
            final /* synthetic */ Function2<DatadogContext, EventBatchWriter, Unit> $callback;
            final /* synthetic */ DatadogContext $context;
            {
                this.$callback = $callback;
                this.$context = $context;
                super(1);
            }

            public final void invoke(@NotNull EventBatchWriter it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$callback.invoke((Object)this.$context, (Object)it);
            }
        }));
    }

    @Override
    public void sendEvent(@NotNull Object event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        FeatureEventReceiver receiver = this.eventReceiver.get();
        if (receiver == null) {
            InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.INFO, InternalLogger.Target.USER, (Function0)new Function0<String>(this){
                final /* synthetic */ SdkFeature this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Feature \"%s\" has no event receiver registered, ignoring event.";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.this$0.getWrappedFeature$dd_sdk_android_core_release().getName()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }, null, false, null, 56, null);
        } else {
            receiver.onReceive(event);
        }
    }

    @Override
    @NotNull
    public <T extends Feature> T unwrap() {
        Feature feature = this.wrappedFeature;
        Intrinsics.checkNotNull((Object)feature, (String)"null cannot be cast to non-null type T of com.datadog.android.core.internal.SdkFeature.unwrap");
        return (T)feature;
    }

    public final void notifyContextUpdated$dd_sdk_android_core_release(@NotNull String featureName, @NotNull Map<String, ? extends Object> context) {
        Intrinsics.checkNotNullParameter((Object)featureName, (String)"featureName");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Set<FeatureContextUpdateReceiver> set = this.contextUpdateListeners;
        Intrinsics.checkNotNullExpressionValue(set, (String)"contextUpdateListeners");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FeatureContextUpdateReceiver it = (FeatureContextUpdateReceiver)element$iv;
            boolean bl = false;
            it.onContextUpdate(featureName, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setContextUpdateListener$dd_sdk_android_core_release(@NotNull FeatureContextUpdateReceiver listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Set<FeatureContextUpdateReceiver> set = this.contextUpdateListeners;
        Intrinsics.checkNotNullExpressionValue(set, (String)"contextUpdateListeners");
        Set<FeatureContextUpdateReceiver> set2 = set;
        synchronized (set2) {
            boolean bl = false;
            if (this.contextUpdateListeners.contains(listener)) {
                InternalLogger.DefaultImpls.log$default(this.internalLogger, InternalLogger.Level.WARN, InternalLogger.Target.USER, (Function0)new Function0<String>(this){
                    final /* synthetic */ SdkFeature this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        String string = "Feature \"%s\" already has this listener registered.";
                        Locale locale = Locale.US;
                        Object[] objectArray = new Object[]{this.this$0.getWrappedFeature$dd_sdk_android_core_release().getName()};
                        String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                        return string2;
                    }
                }, null, false, null, 56, null);
            }
            boolean bl2 = this.contextUpdateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeContextUpdateListener$dd_sdk_android_core_release(@NotNull FeatureContextUpdateReceiver listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Set<FeatureContextUpdateReceiver> set = this.contextUpdateListeners;
        Intrinsics.checkNotNullExpressionValue(set, (String)"contextUpdateListeners");
        Set<FeatureContextUpdateReceiver> set2 = set;
        synchronized (set2) {
            boolean bl = false;
            boolean bl2 = this.contextUpdateListeners.remove(listener);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setupMetricsDispatcher(DataUploadConfiguration dataUploadConfiguration, FilePersistenceConfig filePersistenceConfig, Context context) {
        BatchMetricsDispatcher batchMetricsDispatcher;
        BatchMetricsDispatcher batchMetricsDispatcher2 = batchMetricsDispatcher = new BatchMetricsDispatcher(this.wrappedFeature.getName(), dataUploadConfiguration, filePersistenceConfig, this.internalLogger, this.coreFeature.getTimeProvider$dd_sdk_android_core_release(), null, 32, null);
        SdkFeature sdkFeature = this;
        boolean bl = false;
        if (context instanceof Application) {
            void $this$setupMetricsDispatcher_u24lambda_u243;
            this.processLifecycleMonitor = new ProcessLifecycleMonitor((ProcessLifecycleMonitor.Callback)$this$setupMetricsDispatcher_u24lambda_u243);
            ((Application)context).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.processLifecycleMonitor);
        }
        sdkFeature.metricsDispatcher = batchMetricsDispatcher;
    }

    private final void setupUploader(StorageBackedFeature feature, DataUploadConfiguration uploadConfiguration) {
        UploadScheduler uploadScheduler;
        if (this.coreFeature.isMainProcess$dd_sdk_android_core_release()) {
            this.uploader = this.createUploader(feature.getRequestFactory());
            uploadScheduler = new DataUploadScheduler(feature.getName(), this.storage, this.uploader, this.coreFeature.getContextProvider$dd_sdk_android_core_release(), this.coreFeature.getNetworkInfoProvider$dd_sdk_android_core_release(), this.coreFeature.getSystemInfoProvider$dd_sdk_android_core_release(), uploadConfiguration, this.coreFeature.getUploadExecutorService$dd_sdk_android_core_release(), this.internalLogger);
        } else {
            uploadScheduler = new NoOpUploadScheduler();
        }
        this.uploadScheduler = uploadScheduler;
    }

    private final Storage prepareStorage(DataUploadConfiguration dataUploadConfiguration, StorageBackedFeature wrappedFeature, Context context, String instanceId, PersistenceStrategy.Factory persistenceStrategyFactory) {
        Storage storage;
        FeatureStorageConfiguration storageConfiguration = wrappedFeature.getStorageConfiguration();
        if (persistenceStrategyFactory == null) {
            long recentDelayMs = this.coreFeature.getBatchSize$dd_sdk_android_core_release().getWindowDurationMs$dd_sdk_android_core_release();
            FilePersistenceConfig filePersistenceConfig = this.coreFeature.buildFilePersistenceConfig();
            long l = storageConfiguration.getMaxBatchSize();
            long l2 = storageConfiguration.getMaxItemSize();
            int n = storageConfiguration.getMaxItemsPerBatch();
            long l3 = storageConfiguration.getOldBatchThreshold();
            FilePersistenceConfig filePersistenceConfig2 = FilePersistenceConfig.copy$default(filePersistenceConfig, recentDelayMs, l, l2, n, l3, 0L, 0L, 96, null);
            this.setupMetricsDispatcher(dataUploadConfiguration, filePersistenceConfig2, context);
            storage = this.createFileStorage(wrappedFeature.getName(), filePersistenceConfig2);
        } else {
            storage = this.createCustomStorage(instanceId, wrappedFeature.getName(), storageConfiguration, persistenceStrategyFactory);
        }
        return storage;
    }

    private final Storage createCustomStorage(String instanceId, String featureName, FeatureStorageConfiguration storageConfiguration, PersistenceStrategy.Factory persistenceStrategyFactory) {
        return new AbstractStorage(instanceId, featureName, persistenceStrategyFactory, this.coreFeature.getPersistenceExecutorService$dd_sdk_android_core_release(), this.internalLogger, storageConfiguration, this.coreFeature.getTrackingConsentProvider$dd_sdk_android_core_release());
    }

    private final Storage createFileStorage(String featureName, FilePersistenceConfig filePersistenceConfig) {
        FeatureFileOrchestrator fileOrchestrator = new FeatureFileOrchestrator(this.coreFeature.getTrackingConsentProvider$dd_sdk_android_core_release(), this.coreFeature.getStorageDir$dd_sdk_android_core_release(), featureName, this.coreFeature.getPersistenceExecutorService$dd_sdk_android_core_release(), filePersistenceConfig, this.internalLogger, this.metricsDispatcher);
        this.fileOrchestrator = fileOrchestrator;
        return new ConsentAwareStorage(this.coreFeature.getPersistenceExecutorService$dd_sdk_android_core_release(), fileOrchestrator.getGrantedOrchestrator$dd_sdk_android_core_release(), fileOrchestrator.getPendingOrchestrator$dd_sdk_android_core_release(), BatchFileReaderWriter.Companion.create(this.internalLogger, this.coreFeature.getLocalDataEncryption$dd_sdk_android_core_release()), FileReaderWriter.Companion.create(this.internalLogger, this.coreFeature.getLocalDataEncryption$dd_sdk_android_core_release()), new FileMover(this.internalLogger), this.internalLogger, filePersistenceConfig, this.metricsDispatcher);
    }

    private final DataUploader createUploader(RequestFactory requestFactory) {
        return new DataOkHttpUploader(requestFactory, this.internalLogger, (Call.Factory)this.coreFeature.getOkHttpClient$dd_sdk_android_core_release(), this.coreFeature.getSdkVersion$dd_sdk_android_core_release(), this.coreFeature.getAndroidInfoProvider$dd_sdk_android_core_release());
    }

    @WorkerThread
    public final void flushStoredData$dd_sdk_android_core_release() {
        DataFlusher flusher = new DataFlusher(this.coreFeature.getContextProvider$dd_sdk_android_core_release(), this.fileOrchestrator, BatchFileReaderWriter.Companion.create(this.internalLogger, this.coreFeature.getLocalDataEncryption$dd_sdk_android_core_release()), FileReaderWriter.Companion.create(this.internalLogger, this.coreFeature.getLocalDataEncryption$dd_sdk_android_core_release()), new FileMover(this.internalLogger), this.internalLogger);
        flusher.flush(this.uploader);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/core/internal/SdkFeature$Companion;", "", "()V", "CONTEXT_UPDATE_LISTENER_ALREADY_EXISTS", "", "NO_EVENT_RECEIVER", "dd-sdk-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

