/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.core;

import com.datadog.android.Datadog;
import com.datadog.android.api.SdkCore;
import com.datadog.android.core.internal.DatadogCore;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006J\n\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/datadog/android/core/SdkReference;", "", "sdkInstanceName", "", "onSdkInstanceCaptured", "Lkotlin/Function1;", "Lcom/datadog/android/api/SdkCore;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "reference", "Ljava/util/concurrent/atomic/AtomicReference;", "get", "tryAcquire", "dd-sdk-android-core_release"})
public final class SdkReference {
    @Nullable
    private final String sdkInstanceName;
    @NotNull
    private final Function1<SdkCore, Unit> onSdkInstanceCaptured;
    @NotNull
    private final AtomicReference<SdkCore> reference;

    @JvmOverloads
    public SdkReference(@Nullable String sdkInstanceName, @NotNull Function1<? super SdkCore, Unit> onSdkInstanceCaptured) {
        Intrinsics.checkNotNullParameter(onSdkInstanceCaptured, (String)"onSdkInstanceCaptured");
        this.sdkInstanceName = sdkInstanceName;
        this.onSdkInstanceCaptured = onSdkInstanceCaptured;
        this.reference = new AtomicReference<Object>(null);
    }

    public /* synthetic */ SdkReference(String string, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(string, (Function1<? super SdkCore, Unit>)function1);
    }

    @Nullable
    public final SdkCore get() {
        SdkCore sdkCore;
        SdkCore current = this.reference.get();
        if (current == null) {
            sdkCore = this.tryAcquire();
        } else {
            Boolean isActive;
            DatadogCore datadogCore = current instanceof DatadogCore ? (DatadogCore)current : null;
            Boolean bl = isActive = datadogCore != null ? Boolean.valueOf(datadogCore.isActive$dd_sdk_android_core_release()) : null;
            if (isActive != null && !isActive.booleanValue()) {
                this.reference.compareAndSet(current, null);
                sdkCore = null;
            } else {
                sdkCore = current;
            }
        }
        return sdkCore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SdkCore tryAcquire() {
        SdkCore sdkCore;
        AtomicReference<SdkCore> atomicReference = this.reference;
        synchronized (atomicReference) {
            SdkCore sdkCore2;
            boolean bl = false;
            SdkCore current = this.reference.get();
            if (current != null) {
                sdkCore2 = current;
            } else if (Datadog.isInitialized(this.sdkInstanceName)) {
                SdkCore sdkCore3 = Datadog.getInstance(this.sdkInstanceName);
                this.reference.set(sdkCore3);
                this.onSdkInstanceCaptured.invoke((Object)sdkCore3);
                sdkCore2 = sdkCore3;
            } else {
                sdkCore2 = null;
            }
            sdkCore = sdkCore2;
        }
        return sdkCore;
    }

    @JvmOverloads
    public SdkReference(@Nullable String sdkInstanceName) {
        this(sdkInstanceName, null, 2, null);
    }

    @JvmOverloads
    public SdkReference() {
        this(null, null, 3, null);
    }
}

