/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.metrics;

import datadog.trace.bootstrap.otel.api.common.Attributes;
import datadog.trace.bootstrap.otel.api.metrics.DoubleHistogram;
import datadog.trace.bootstrap.otel.api.metrics.DoubleHistogramBuilder;
import datadog.trace.bootstrap.otel.api.metrics.LongHistogramBuilder;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.shim.metrics.OtelInstrumentBuilder;
import datadog.trace.bootstrap.otel.shim.metrics.OtelInstrumentType;
import datadog.trace.bootstrap.otel.shim.metrics.OtelLongHistogram;
import datadog.trace.bootstrap.otel.shim.metrics.OtelMeter;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class OtelDoubleHistogram
implements DoubleHistogram {
    OtelDoubleHistogram() {
    }

    @Override
    public void record(double value) {
    }

    @Override
    public void record(double value, Attributes attributes) {
    }

    @Override
    public void record(double value, Attributes attributes, Context context) {
    }

    static final class Builder
    implements DoubleHistogramBuilder {
        private final OtelInstrumentBuilder instrumentBuilder;

        Builder(OtelMeter meter, String instrumentName) {
            this.instrumentBuilder = OtelInstrumentBuilder.ofDoubles(meter, instrumentName, OtelInstrumentType.HISTOGRAM);
        }

        @Override
        public DoubleHistogramBuilder setDescription(String description) {
            this.instrumentBuilder.setDescription(description);
            return this;
        }

        @Override
        public DoubleHistogramBuilder setUnit(String unit) {
            this.instrumentBuilder.setUnit(unit);
            return this;
        }

        @Override
        public DoubleHistogramBuilder setExplicitBucketBoundariesAdvice(List<Double> bucketBoundaries) {
            return this;
        }

        @Override
        public LongHistogramBuilder ofLongs() {
            return new OtelLongHistogram.Builder(this.instrumentBuilder);
        }

        @Override
        public DoubleHistogram build() {
            return new OtelDoubleHistogram();
        }
    }
}

