/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.appsec;

import datadog.appsec.api.blocking.BlockingException;
import datadog.appsec.api.login.EventTrackerService;
import datadog.appsec.api.login.EventTrackerV2;
import datadog.appsec.api.user.User;
import datadog.appsec.api.user.UserService;
import datadog.trace.api.EventTracker;
import datadog.trace.api.GlobalTracer;
import datadog.trace.api.UserIdCollectionMode;
import datadog.trace.api.gateway.BlockResponseFunction;
import datadog.trace.api.gateway.CallbackProvider;
import datadog.trace.api.gateway.EventType;
import datadog.trace.api.gateway.Events;
import datadog.trace.api.gateway.Flow;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.api.gateway.RequestContextSlot;
import datadog.trace.api.internal.TraceSegment;
import datadog.trace.api.telemetry.LoginEvent;
import datadog.trace.api.telemetry.LoginVersion;
import datadog.trace.api.telemetry.WafMetricCollector;
import datadog.trace.bootstrap.ActiveSubsystems;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.util.Strings;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

public class AppSecEventTracker
extends EventTracker
implements UserService,
EventTrackerService {
    private static final int HASH_SIZE_BYTES = 16;
    private static final String ANON_PREFIX = "anon_";
    private static final Map<String, LoginEvent> EVENT_MAPPING = new HashMap<String, LoginEvent>();
    private static final String LOGIN_SUCCESS_EVENT = "users.login.success";
    private static final String LOGIN_FAILURE_EVENT = "users.login.failure";
    private static final String SIGNUP_EVENT = "users.signup";
    private static final String COLLECTION_MODE = "_dd.appsec.user.collection_mode";

    public static void install() {
        AppSecEventTracker tracker = new AppSecEventTracker();
        GlobalTracer.setEventTracker(tracker);
        EventTrackerV2.setEventTrackerService(tracker);
        User.setUserService(tracker);
    }

    @Override
    public final void trackLoginSuccessEvent(String userId, Map<String, String> metadata) {
        if (userId == null || userId.isEmpty()) {
            throw new IllegalArgumentException("userId is null or empty");
        }
        WafMetricCollector.get().appSecSdkEvent(LoginEvent.LOGIN_SUCCESS, LoginVersion.V1);
        if (this.handleLoginEvent(LoginVersion.V1, LOGIN_SUCCESS_EVENT, UserIdCollectionMode.SDK, userId, userId, null, metadata)) {
            throw new BlockingException("Blocked request (for login success)");
        }
    }

    @Override
    public final void trackLoginFailureEvent(String userId, boolean exists, Map<String, String> metadata) {
        if (userId == null || userId.isEmpty()) {
            throw new IllegalArgumentException("userId is null or empty");
        }
        WafMetricCollector.get().appSecSdkEvent(LoginEvent.LOGIN_FAILURE, LoginVersion.V1);
        if (this.handleLoginEvent(LoginVersion.V1, LOGIN_FAILURE_EVENT, UserIdCollectionMode.SDK, userId, userId, exists, metadata)) {
            throw new BlockingException("Blocked request (for login failure)");
        }
    }

    @Override
    public void trackUserLoginSuccess(String login, String userId, Map<String, String> metadata) {
        if (login == null || login.isEmpty()) {
            throw new IllegalArgumentException("login is null or empty");
        }
        WafMetricCollector.get().appSecSdkEvent(LoginEvent.LOGIN_SUCCESS, LoginVersion.V2);
        if (this.handleLoginEvent(LoginVersion.V2, LOGIN_SUCCESS_EVENT, UserIdCollectionMode.SDK, login, userId, null, metadata)) {
            throw new BlockingException("Blocked request (for login success)");
        }
    }

    @Override
    public void trackUserLoginFailure(String login, boolean exists, Map<String, String> metadata) {
        if (login == null || login.isEmpty()) {
            throw new IllegalArgumentException("login is null or empty");
        }
        WafMetricCollector.get().appSecSdkEvent(LoginEvent.LOGIN_FAILURE, LoginVersion.V2);
        if (this.handleLoginEvent(LoginVersion.V2, LOGIN_FAILURE_EVENT, UserIdCollectionMode.SDK, login, null, exists, metadata)) {
            throw new BlockingException("Blocked request (for login failure)");
        }
    }

    @Override
    public final void trackCustomEvent(String eventName, Map<String, String> metadata) {
        if (eventName == null || eventName.isEmpty()) {
            throw new IllegalArgumentException("eventName is null or empty");
        }
        WafMetricCollector.get().appSecSdkEvent(LoginEvent.CUSTOM, LoginVersion.V2);
        if (this.handleLoginEvent(LoginVersion.V2, eventName, UserIdCollectionMode.SDK, null, null, null, metadata)) {
            throw new BlockingException("Blocked request (for custom event)");
        }
    }

    @Override
    public void trackUserEvent(String userId, Map<String, String> metadata) {
        if (userId == null || userId.isEmpty()) {
            throw new IllegalArgumentException("userId is null or empty");
        }
        if (this.handleUser(UserIdCollectionMode.SDK, userId, metadata)) {
            throw new BlockingException("Blocked request (for user)");
        }
    }

    public void onUserEvent(UserIdCollectionMode mode, String userId) {
        this.onUserEvent(mode, userId, Collections.emptyMap());
    }

    public void onUserEvent(UserIdCollectionMode mode, String userId, Map<String, String> metadata) {
        if (this.handleUser(mode, userId, metadata)) {
            throw new BlockingException("Blocked request (for user)");
        }
    }

    public void onUserNotFound(UserIdCollectionMode mode) {
        if (this.handleLoginEvent(LoginVersion.AUTO, LOGIN_FAILURE_EVENT, mode, null, null, false, null)) {
            throw new BlockingException("Blocked request (for user not found)");
        }
    }

    public void onSignupEvent(UserIdCollectionMode mode, String login, Map<String, String> metadata) {
        this.onSignupEvent(mode, login, null, metadata);
    }

    public void onSignupEvent(UserIdCollectionMode mode, String login, String userId, Map<String, String> metadata) {
        if (this.handleLoginEvent(LoginVersion.AUTO, SIGNUP_EVENT, mode, login, userId, null, metadata)) {
            throw new BlockingException("Blocked request (for signup)");
        }
    }

    public void onLoginSuccessEvent(UserIdCollectionMode mode, String login, Map<String, String> metadata) {
        this.onLoginSuccessEvent(mode, login, null, metadata);
    }

    public void onLoginSuccessEvent(UserIdCollectionMode mode, String login, String user, Map<String, String> metadata) {
        if (this.handleLoginEvent(LoginVersion.AUTO, LOGIN_SUCCESS_EVENT, mode, login, user, null, metadata)) {
            throw new BlockingException("Blocked request (for login success)");
        }
    }

    public void onLoginFailureEvent(UserIdCollectionMode mode, String login, Boolean exists, Map<String, String> metadata) {
        if (this.handleLoginEvent(LoginVersion.AUTO, LOGIN_FAILURE_EVENT, mode, login, null, exists, metadata)) {
            throw new BlockingException("Blocked request (for login failure)");
        }
    }

    private boolean handleUser(UserIdCollectionMode mode, String userId, Map<String, String> metadata) {
        if (!this.isEnabled(mode)) {
            return false;
        }
        AgentTracer.TracerAPI tracer = this.tracer();
        if (tracer == null) {
            return false;
        }
        TraceSegment segment = tracer.getTraceSegment();
        if (segment == null) {
            return false;
        }
        String finalUserId = AppSecEventTracker.anonymize(mode, userId);
        if (finalUserId == null) {
            return false;
        }
        if (mode != UserIdCollectionMode.SDK) {
            segment.setTagTop("_dd.appsec.usr.id", finalUserId);
        }
        if (this.isNewUser(mode, segment)) {
            segment.setTagTop("usr.id", finalUserId);
            if (metadata != null && !metadata.isEmpty()) {
                segment.setTagTop("usr", metadata);
            }
            segment.setTagTop(COLLECTION_MODE, mode.fullName());
            segment.setTagTop("asm.keep", true);
            segment.setTagTop("_dd.p.ts", 2);
            return this.dispatch(tracer, Events.EVENTS.user(), (ctx, cb) -> (Flow)cb.apply(ctx, finalUserId));
        }
        return false;
    }

    private boolean handleLoginEvent(LoginVersion version, String eventName, UserIdCollectionMode mode, String login, String userId, Boolean exists, Map<String, String> metadata) {
        if (!this.isEnabled(mode)) {
            return false;
        }
        AgentTracer.TracerAPI tracer = this.tracer();
        if (tracer == null) {
            return false;
        }
        TraceSegment segment = tracer.getTraceSegment();
        if (segment == null) {
            return false;
        }
        boolean block = false;
        String finalLogin = AppSecEventTracker.anonymize(mode, login);
        if (finalLogin == null && login != null) {
            return false;
        }
        if (mode == UserIdCollectionMode.SDK) {
            segment.setTagTop("_dd.appsec.events." + eventName + ".sdk", true, true);
        } else {
            if (finalLogin != null) {
                segment.setTagTop("_dd.appsec.usr.login", finalLogin);
            }
            segment.setTagTop("_dd.appsec.events." + eventName + ".auto.mode", mode.fullName(), true);
        }
        LoginEvent event = EVENT_MAPPING.get(eventName);
        if (this.isNewLoginEvent(mode, segment, eventName)) {
            if (finalLogin != null) {
                segment.setTagTop("appsec.events." + eventName + ".usr.login", finalLogin, true);
            }
            if (metadata != null && !metadata.isEmpty()) {
                segment.setTagTop("appsec.events." + eventName, metadata, true);
            }
            if (exists != null) {
                segment.setTagTop("appsec.events." + eventName + ".usr.exists", exists, true);
            }
            segment.setTagTop("appsec.events." + eventName + ".track", true, true);
            segment.setTagTop("asm.keep", true);
            segment.setTagTop("_dd.p.ts", 2);
            if (finalLogin != null && event != null) {
                block = this.dispatch(tracer, Events.EVENTS.loginEvent(), (ctx, cb) -> (Flow)cb.apply(ctx, event, finalLogin));
            }
        }
        if (userId != null) {
            boolean blockUser;
            if (version == LoginVersion.V2) {
                segment.setTagTop("appsec.events." + eventName + ".usr.id", userId, true);
                if (metadata != null && !metadata.isEmpty()) {
                    segment.setTagTop("appsec.events." + eventName + ".usr", metadata, true);
                }
                blockUser = this.handleUser(mode, userId, metadata);
            } else {
                if (event == LoginEvent.LOGIN_SUCCESS) {
                    segment.setTagTop("usr.id", userId);
                } else {
                    segment.setTagTop("appsec.events." + eventName + ".usr.id", userId, true);
                }
                blockUser = this.dispatch(tracer, Events.EVENTS.user(), (ctx, cb) -> (Flow)cb.apply(ctx, userId));
            }
            block |= blockUser;
        }
        return block;
    }

    private boolean isNewLoginEvent(UserIdCollectionMode mode, TraceSegment segment, String event) {
        if (mode == UserIdCollectionMode.SDK) {
            return true;
        }
        return segment.getTagTop("_dd.appsec.events." + event + ".sdk") == null;
    }

    private boolean isNewUser(UserIdCollectionMode mode, TraceSegment segment) {
        if (mode == UserIdCollectionMode.SDK) {
            return true;
        }
        Object value = segment.getTagTop(COLLECTION_MODE);
        return value == null || !"sdk".equalsIgnoreCase(value.toString());
    }

    private <T> boolean dispatch(AgentTracer.TracerAPI tracer, EventType<T> event, BiFunction<RequestContext, T, Flow<Void>> consumer) {
        if (tracer == null) {
            return false;
        }
        CallbackProvider cbp = tracer.getCallbackProvider(RequestContextSlot.APPSEC);
        if (cbp == null) {
            return false;
        }
        AgentSpan span = tracer.activeSpan();
        if (span == null) {
            return false;
        }
        RequestContext ctx = span.getRequestContext();
        if (ctx == null) {
            return false;
        }
        T callback = cbp.getCallback(event);
        if (callback == null) {
            return false;
        }
        Flow<Void> flow = consumer.apply(ctx, (RequestContext)callback);
        if (flow == null) {
            return false;
        }
        Flow.Action action = flow.getAction();
        if (action instanceof Flow.Action.RequestBlockingAction) {
            BlockResponseFunction brf = ctx.getBlockResponseFunction();
            if (brf != null) {
                Flow.Action.RequestBlockingAction rba = (Flow.Action.RequestBlockingAction)action;
                brf.tryCommitBlockingResponse(ctx.getTraceSegment(), rba);
            }
            return true;
        }
        return false;
    }

    protected static String anonymize(UserIdCollectionMode mode, String userId) {
        MessageDigest digest;
        if (mode != UserIdCollectionMode.ANONYMIZATION || userId == null) {
            return userId;
        }
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        digest.update(userId.getBytes());
        byte[] hash = digest.digest();
        if (hash.length > 16) {
            byte[] temp = new byte[16];
            System.arraycopy(hash, 0, temp, 0, temp.length);
            hash = temp;
        }
        return ANON_PREFIX + Strings.toHexString(hash);
    }

    protected boolean isEnabled(UserIdCollectionMode mode) {
        return mode == UserIdCollectionMode.SDK || ActiveSubsystems.APPSEC_ACTIVE && mode != UserIdCollectionMode.DISABLED;
    }

    protected AgentTracer.TracerAPI tracer() {
        return AgentTracer.get();
    }

    static {
        EVENT_MAPPING.put(LOGIN_SUCCESS_EVENT, LoginEvent.LOGIN_SUCCESS);
        EVENT_MAPPING.put(LOGIN_FAILURE_EVENT, LoginEvent.LOGIN_FAILURE);
        EVENT_MAPPING.put(SIGNUP_EVENT, LoginEvent.SIGN_UP);
    }
}

