/*
 * Decompiled with CFR 0.152.
 */
package datadog.environment;

import datadog.environment.JavaVirtualMachine;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class ThreadSupport {
    static final MethodHandle THREAD_ID_MH = ThreadSupport.findThreadIdMethodHandle();
    static final MethodHandle IS_VIRTUAL_MH = ThreadSupport.findIsVirtualMethodHandle();
    static final MethodHandle NEW_VIRTUAL_THREAD_PER_TASK_EXECUTOR_MH = ThreadSupport.findNewVirtualThreadPerTaskExecutorMethodHandle();

    private ThreadSupport() {
    }

    public static long threadId() {
        return ThreadSupport.threadId(Thread.currentThread());
    }

    public static long threadId(Thread thread) {
        if (THREAD_ID_MH != null) {
            try {
                return THREAD_ID_MH.invoke(thread);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return thread.getId();
    }

    public static boolean supportsVirtualThreads() {
        return IS_VIRTUAL_MH != null;
    }

    public static boolean isVirtual() {
        return IS_VIRTUAL_MH != null && ThreadSupport.isVirtual(Thread.currentThread());
    }

    public static boolean isVirtual(Thread thread) {
        if (IS_VIRTUAL_MH != null) {
            try {
                return IS_VIRTUAL_MH.invoke(thread);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static Optional<ExecutorService> newVirtualThreadPerTaskExecutor() {
        if (NEW_VIRTUAL_THREAD_PER_TASK_EXECUTOR_MH != null) {
            try {
                ExecutorService executorService = NEW_VIRTUAL_THREAD_PER_TASK_EXECUTOR_MH.invoke();
                return Optional.of(executorService);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private static MethodHandle findThreadIdMethodHandle() {
        if (JavaVirtualMachine.isJavaVersionAtLeast(19)) {
            try {
                return MethodHandles.lookup().findVirtual(Thread.class, "threadId", MethodType.methodType(Long.TYPE));
            }
            catch (Throwable ignored) {
                return null;
            }
        }
        return null;
    }

    private static MethodHandle findIsVirtualMethodHandle() {
        if (JavaVirtualMachine.isJavaVersionAtLeast(21)) {
            try {
                return MethodHandles.lookup().findVirtual(Thread.class, "isVirtual", MethodType.methodType(Boolean.TYPE));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static MethodHandle findNewVirtualThreadPerTaskExecutorMethodHandle() {
        if (JavaVirtualMachine.isJavaVersionAtLeast(21)) {
            try {
                return MethodHandles.lookup().findStatic(Executors.class, "newVirtualThreadPerTaskExecutor", MethodType.methodType(ExecutorService.class));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

