/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.baggage;

import datadog.trace.bootstrap.otel.api.baggage.Baggage;
import datadog.trace.bootstrap.otel.api.baggage.BaggageBuilder;
import datadog.trace.bootstrap.otel.api.baggage.BaggageEntryMetadata;
import datadog.trace.bootstrap.otel.shim.baggage.OtelBaggage;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class OtelBaggageBuilder
implements BaggageBuilder {
    private final Map<String, String> items;

    public OtelBaggageBuilder(Map<String, String> items) {
        this.items = new HashMap<String, String>(items);
    }

    @Override
    public BaggageBuilder put(@Nullable String key, @Nullable String value, BaggageEntryMetadata ignore) {
        if (key != null && value != null) {
            this.items.put(key, value);
        }
        return this;
    }

    @Override
    public BaggageBuilder remove(@Nullable String key) {
        if (key != null) {
            this.items.remove(key);
        }
        return this;
    }

    @Override
    public Baggage build() {
        return new OtelBaggage(new HashMap<String, String>(this.items));
    }
}

