/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.context.propagation;

import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.context.propagation.MultiTextMapPropagator;
import datadog.trace.bootstrap.otel.context.propagation.NoopTextMapPropagator;
import datadog.trace.bootstrap.otel.context.propagation.TextMapGetter;
import datadog.trace.bootstrap.otel.context.propagation.TextMapSetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface TextMapPropagator {
    public static TextMapPropagator composite(TextMapPropagator ... propagators) {
        return TextMapPropagator.composite(Arrays.asList(propagators));
    }

    public static TextMapPropagator composite(Iterable<TextMapPropagator> propagators) {
        ArrayList<TextMapPropagator> propagatorsList = new ArrayList<TextMapPropagator>();
        for (TextMapPropagator propagator : propagators) {
            propagatorsList.add(propagator);
        }
        if (propagatorsList.isEmpty()) {
            return NoopTextMapPropagator.getInstance();
        }
        if (propagatorsList.size() == 1) {
            return (TextMapPropagator)propagatorsList.get(0);
        }
        return new MultiTextMapPropagator(propagatorsList);
    }

    public static TextMapPropagator noop() {
        return NoopTextMapPropagator.getInstance();
    }

    public Collection<String> fields();

    public <C> void inject(Context var1, @Nullable C var2, TextMapSetter<C> var3);

    public <C> Context extract(Context var1, @Nullable C var2, TextMapGetter<C> var3);
}

