/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.trace.api.GenericClassValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public final class InstanceStore<T> {
    private static final ClassValue<InstanceStore> classInstanceStore = GenericClassValue.of((Class<?> type) -> new InstanceStore());
    private final Map<String, T> store = Collections.synchronizedMap(new HashMap());

    public static <T> InstanceStore<T> of(Class<T> type) {
        return classInstanceStore.get(type);
    }

    private InstanceStore() {
    }

    public T get(String key) {
        return this.store.get(key);
    }

    public void put(String key, T instance) {
        this.store.put(key, instance);
    }

    public T putIfAbsent(String key, Supplier<T> instanceFactory) {
        return (T)this.store.computeIfAbsent(key, k -> instanceFactory.get());
    }

    public T remove(String key) {
        return this.store.remove(key);
    }
}

