/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.metrics;

import datadog.trace.bootstrap.otel.api.common.Attributes;
import datadog.trace.bootstrap.otel.api.metrics.DoubleUpDownCounterBuilder;
import datadog.trace.bootstrap.otel.api.metrics.LongUpDownCounter;
import datadog.trace.bootstrap.otel.api.metrics.LongUpDownCounterBuilder;
import datadog.trace.bootstrap.otel.api.metrics.ObservableLongMeasurement;
import datadog.trace.bootstrap.otel.api.metrics.ObservableLongUpDownCounter;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.shim.metrics.OtelDoubleUpDownCounter;
import datadog.trace.bootstrap.otel.shim.metrics.OtelInstrumentBuilder;
import datadog.trace.bootstrap.otel.shim.metrics.OtelInstrumentType;
import datadog.trace.bootstrap.otel.shim.metrics.OtelMeter;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class OtelLongUpDownCounter
implements LongUpDownCounter {
    OtelLongUpDownCounter() {
    }

    @Override
    public void add(long value) {
    }

    @Override
    public void add(long value, Attributes attributes) {
    }

    @Override
    public void add(long value, Attributes attributes, Context context) {
    }

    static final class Builder
    implements LongUpDownCounterBuilder {
        private final OtelInstrumentBuilder instrumentBuilder;

        Builder(OtelMeter meter, String instrumentName) {
            this.instrumentBuilder = OtelInstrumentBuilder.ofLongs(meter, instrumentName, OtelInstrumentType.UP_DOWN_COUNTER);
        }

        @Override
        public LongUpDownCounterBuilder setDescription(String description) {
            this.instrumentBuilder.setDescription(description);
            return this;
        }

        @Override
        public LongUpDownCounterBuilder setUnit(String unit) {
            this.instrumentBuilder.setUnit(unit);
            return this;
        }

        @Override
        public DoubleUpDownCounterBuilder ofDoubles() {
            return new OtelDoubleUpDownCounter.Builder(this.instrumentBuilder);
        }

        @Override
        public LongUpDownCounter build() {
            return new OtelLongUpDownCounter();
        }

        @Override
        public ObservableLongUpDownCounter buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            return OtelMeter.NOOP_METER.upDownCounterBuilder("noop").buildWithCallback(callback);
        }

        @Override
        public ObservableLongMeasurement buildObserver() {
            return OtelMeter.NOOP_METER.upDownCounterBuilder("noop").buildObserver();
        }
    }
}

