/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.metrics;

import datadog.trace.bootstrap.otel.api.common.Attributes;
import datadog.trace.bootstrap.otel.api.metrics.DoubleUpDownCounter;
import datadog.trace.bootstrap.otel.api.metrics.DoubleUpDownCounterBuilder;
import datadog.trace.bootstrap.otel.api.metrics.ObservableDoubleMeasurement;
import datadog.trace.bootstrap.otel.api.metrics.ObservableDoubleUpDownCounter;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.shim.metrics.OtelInstrumentBuilder;
import datadog.trace.bootstrap.otel.shim.metrics.OtelInstrumentType;
import datadog.trace.bootstrap.otel.shim.metrics.OtelMeter;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class OtelDoubleUpDownCounter
implements DoubleUpDownCounter {
    OtelDoubleUpDownCounter() {
    }

    @Override
    public void add(double value) {
    }

    @Override
    public void add(double value, Attributes attributes) {
    }

    @Override
    public void add(double value, Attributes attributes, Context context) {
    }

    static final class Builder
    implements DoubleUpDownCounterBuilder {
        private final OtelInstrumentBuilder instrumentBuilder;

        Builder(OtelInstrumentBuilder builder) {
            this.instrumentBuilder = OtelInstrumentBuilder.ofDoubles(builder, OtelInstrumentType.UP_DOWN_COUNTER);
        }

        @Override
        public DoubleUpDownCounterBuilder setDescription(String description) {
            this.instrumentBuilder.setDescription(description);
            return this;
        }

        @Override
        public DoubleUpDownCounterBuilder setUnit(String unit) {
            this.instrumentBuilder.setUnit(unit);
            return this;
        }

        @Override
        public DoubleUpDownCounter build() {
            return new OtelDoubleUpDownCounter();
        }

        @Override
        public ObservableDoubleUpDownCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return OtelMeter.NOOP_METER.upDownCounterBuilder("noop").ofDoubles().buildWithCallback(callback);
        }

        @Override
        public ObservableDoubleMeasurement buildObserver() {
            return OtelMeter.NOOP_METER.upDownCounterBuilder("noop").ofDoubles().buildObserver();
        }
    }
}

