/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.metrics;

import datadog.trace.bootstrap.otel.api.common.Attributes;
import datadog.trace.bootstrap.otel.api.metrics.DoubleCounter;
import datadog.trace.bootstrap.otel.api.metrics.DoubleCounterBuilder;
import datadog.trace.bootstrap.otel.api.metrics.ObservableDoubleCounter;
import datadog.trace.bootstrap.otel.api.metrics.ObservableDoubleMeasurement;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.shim.metrics.OtelInstrumentBuilder;
import datadog.trace.bootstrap.otel.shim.metrics.OtelInstrumentType;
import datadog.trace.bootstrap.otel.shim.metrics.OtelMeter;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class OtelDoubleCounter
implements DoubleCounter {
    OtelDoubleCounter() {
    }

    @Override
    public void add(double value) {
    }

    @Override
    public void add(double value, Attributes attributes) {
    }

    @Override
    public void add(double value, Attributes attributes, Context context) {
    }

    static final class Builder
    implements DoubleCounterBuilder {
        private final OtelInstrumentBuilder instrumentBuilder;

        Builder(OtelInstrumentBuilder builder) {
            this.instrumentBuilder = OtelInstrumentBuilder.ofDoubles(builder, OtelInstrumentType.COUNTER);
        }

        @Override
        public DoubleCounterBuilder setDescription(String description) {
            this.instrumentBuilder.setDescription(description);
            return this;
        }

        @Override
        public DoubleCounterBuilder setUnit(String unit) {
            this.instrumentBuilder.setUnit(unit);
            return this;
        }

        @Override
        public DoubleCounter build() {
            return new OtelDoubleCounter();
        }

        @Override
        public ObservableDoubleCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return OtelMeter.NOOP_METER.counterBuilder("noop").ofDoubles().buildWithCallback(callback);
        }

        @Override
        public ObservableDoubleMeasurement buildObserver() {
            return OtelMeter.NOOP_METER.counterBuilder("noop").ofDoubles().buildObserver();
        }
    }
}

