/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.dbm;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.BaseHash;
import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class SharedDBCommenter {
    private static final Logger log = LoggerFactory.getLogger(SharedDBCommenter.class);
    private static final String UTF8 = StandardCharsets.UTF_8.toString();
    private static final char EQUALS = '=';
    private static final char COMMA = ',';
    private static final char QUOTE = '\'';
    private static final String PARENT_SERVICE = SharedDBCommenter.encode("ddps");
    private static final String DATABASE_SERVICE = SharedDBCommenter.encode("dddbs");
    private static final String DD_HOSTNAME = SharedDBCommenter.encode("ddh");
    private static final String DD_DB_NAME = SharedDBCommenter.encode("dddb");
    private static final String DD_PEER_SERVICE = "ddprs";
    private static final String DD_ENV = SharedDBCommenter.encode("dde");
    private static final String DD_VERSION = SharedDBCommenter.encode("ddpv");
    private static final String TRACEPARENT = SharedDBCommenter.encode("traceparent");
    private static final String DD_SERVICE_HASH = SharedDBCommenter.encode("ddsh");

    public static boolean containsTraceComment(String commentContent) {
        return commentContent.contains(PARENT_SERVICE + "=") || commentContent.contains(DATABASE_SERVICE + "=") || commentContent.contains(DD_HOSTNAME + "=") || commentContent.contains(DD_DB_NAME + "=") || commentContent.contains("ddprs=") || commentContent.contains(DD_ENV + "=") || commentContent.contains(DD_VERSION + "=") || commentContent.contains(TRACEPARENT + "=") || commentContent.contains(DD_SERVICE_HASH + "=");
    }

    public static String buildComment(String dbService, String dbType, String hostname, String dbName, String traceParent) {
        Config config = Config.get();
        StringBuilder sb = new StringBuilder();
        int initSize = 0;
        SharedDBCommenter.append(sb, PARENT_SERVICE, config.getServiceName(), initSize);
        SharedDBCommenter.append(sb, DATABASE_SERVICE, dbService, initSize);
        SharedDBCommenter.append(sb, DD_HOSTNAME, hostname, initSize);
        SharedDBCommenter.append(sb, DD_DB_NAME, dbName, initSize);
        SharedDBCommenter.append(sb, DD_PEER_SERVICE, SharedDBCommenter.getPeerService(), initSize);
        SharedDBCommenter.append(sb, DD_ENV, config.getEnv(), initSize);
        SharedDBCommenter.append(sb, DD_VERSION, config.getVersion(), initSize);
        SharedDBCommenter.append(sb, TRACEPARENT, traceParent, initSize);
        if (config.isDbmInjectSqlBaseHash() && config.isExperimentalPropagateProcessTagsEnabled()) {
            SharedDBCommenter.append(sb, DD_SERVICE_HASH, BaseHash.getBaseHashStr(), initSize);
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    private static String getPeerService() {
        AgentSpan span = AgentTracer.activeSpan();
        Object peerService = null;
        if (span != null) {
            peerService = span.getTag("peer.service");
        }
        return peerService != null ? peerService.toString() : null;
    }

    private static String encode(String val) {
        try {
            return URLEncoder.encode(val, UTF8);
        }
        catch (UnsupportedEncodingException exe) {
            if (log.isDebugEnabled()) {
                log.debug("exception thrown while encoding comment key {}", (Object)val, (Object)exe);
            }
            return val;
        }
    }

    private static void append(StringBuilder sb, String key, String value, int initSize) {
        String encodedValue;
        if (null == value || value.isEmpty()) {
            return;
        }
        try {
            encodedValue = URLEncoder.encode(value, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            encodedValue = value;
        }
        if (sb.length() > initSize) {
            sb.append(',');
        }
        sb.append(key).append('=').append('\'').append(encodedValue).append('\'');
    }
}

