/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.AgentJarIndex;
import datadog.trace.bootstrap.BootstrapProxy;
import datadog.trace.bootstrap.InstrumentationClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class DatadogClassLoader
extends SecureClassLoader {
    private static final Logger log;
    private final Set<String> definedPackages = new HashSet<String>();
    private final JarFile agentJarFile;
    private final CodeSource agentCodeSource;
    private final String agentResourcePrefix;
    private final AgentJarIndex agentJarIndex;
    private final Object instrumentationClassLoaderLock = new Object();
    private volatile WeakReference<InstrumentationClassLoader> instrumentationClassLoader = new WeakReference<InstrumentationClassLoader>(new InstrumentationClassLoader(this));

    public DatadogClassLoader(URL agentJarURL, ClassLoader parent) throws Exception {
        super(parent);
        this.agentJarFile = new JarFile(new File(agentJarURL.toURI()), false);
        this.agentCodeSource = new CodeSource(agentJarURL, (Certificate[])null);
        this.agentResourcePrefix = "jar:file:" + this.agentJarFile.getName() + "!/";
        this.agentJarIndex = AgentJarIndex.readIndex(this.agentJarFile);
    }

    public DatadogClassLoader() {
        super(null);
        this.agentCodeSource = null;
        this.agentJarFile = null;
        this.agentResourcePrefix = null;
        this.agentJarIndex = AgentJarIndex.emptyIndex();
    }

    @Override
    public URL getResource(String name) {
        URL bootstrapResource = BootstrapProxy.INSTANCE.getResource(name);
        if (null != bootstrapResource) {
            return bootstrapResource;
        }
        return super.getResource(name);
    }

    @Override
    protected URL findResource(String name) {
        JarEntry jarEntry;
        String entryName = this.agentJarIndex.resourceEntryName(name);
        if (null != entryName && null != (jarEntry = this.agentJarFile.getJarEntry(entryName))) {
            String location = this.agentResourcePrefix + entryName;
            try {
                return new URL(location);
            }
            catch (Exception e) {
                log.warn("Malformed location {}", (Object)location);
            }
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        URL resource = this.findResource(name);
        if (null != resource) {
            return Collections.enumeration(Collections.singleton(resource));
        }
        return Collections.emptyEnumeration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("datadog.trace.instrumentation.") && (name.endsWith("$Muzzle") || name.endsWith("Instrumentation") || name.endsWith("Module"))) {
            InstrumentationClassLoader cl = (InstrumentationClassLoader)this.instrumentationClassLoader.get();
            if (null == cl) {
                Object object = this.instrumentationClassLoaderLock;
                synchronized (object) {
                    cl = (InstrumentationClassLoader)this.instrumentationClassLoader.get();
                    if (null == cl) {
                        cl = new InstrumentationClassLoader(this);
                        this.instrumentationClassLoader = new WeakReference<InstrumentationClassLoader>(cl);
                    }
                }
            }
            return cl.loadInstrumentationClass(name, this.agentCodeSource);
        }
        if (name.startsWith("com.kenai.jffi")) {
            return this.loadLocalClass(name, resolve);
        }
        return super.loadClass(name, resolve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadLocalClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (null == c) {
                c = this.findClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] buf = this.loadClassBytes(name);
        return this.defineClass(name, buf, 0, buf.length, this.agentCodeSource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] loadClassBytes(String name) throws ClassNotFoundException {
        String entryName = this.agentJarIndex.classEntryName(name);
        if (null == entryName) throw new ClassNotFoundException(name);
        JarEntry jarEntry = this.agentJarFile.getJarEntry(entryName);
        if (null == jarEntry) throw new ClassNotFoundException(name);
        byte[] buf = new byte[(int)jarEntry.getSize()];
        try (InputStream in = this.agentJarFile.getInputStream(jarEntry);){
            int bytesRead;
            int delta;
            for (bytesRead = in.read(buf); bytesRead < buf.length && (delta = in.read(buf, bytesRead, buf.length - bytesRead)) >= 0; bytesRead += delta) {
            }
            if (bytesRead == buf.length) {
                byte[] byArray = buf;
                return byArray;
            }
            log.warn("Malformed class data at {}", (Object)jarEntry);
            throw new ClassNotFoundException(name);
        }
        catch (IOException e) {
            log.warn("Problem reading class data at {}", (Object)jarEntry, (Object)e);
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Package getPackage(String name) {
        Set<String> set = this.definedPackages;
        synchronized (set) {
            if (this.definedPackages.add(name)) {
                return this.definePackage(name, null, null, null, null, null, null, null);
            }
            return super.getPackage(name);
        }
    }

    public String toString() {
        return "datadog";
    }

    static {
        ClassLoader.registerAsParallelCapable();
        log = LoggerFactory.getLogger(DatadogClassLoader.class);
    }
}

