/*
 * Decompiled with CFR 0.152.
 */
package datadog.instrument.classmatch;

import datadog.instrument.classmatch.TypeString;
import java.util.BitSet;
import javax.annotation.Nullable;

public final class MethodOutline {
    public final int access;
    public final String methodName;
    public final String descriptor;
    public final String[] annotations;
    private static final int[] NO_BOUNDARIES = new int[0];
    private int[] descriptorBoundaries;
    private int[] typeStringHashes;

    MethodOutline(int access, String methodName, String descriptor, String[] annotations) {
        this.access = access;
        this.methodName = methodName;
        this.descriptor = descriptor;
        this.annotations = annotations;
    }

    int parameterCount() {
        return this.descriptorBoundaries().length;
    }

    @Nullable
    TypeString parameterTypeString(int paramIndex) {
        int start;
        int[] boundaries = this.descriptorBoundaries();
        if (paramIndex >= boundaries.length) {
            return null;
        }
        int n = start = paramIndex == 0 ? 2 : boundaries[paramIndex - 1] + 1;
        if (this.descriptor.charAt(start - 1) != 'L') {
            return null;
        }
        int end = boundaries[paramIndex] - 1;
        return new TypeString(this.descriptor, start, end, this.getHash(paramIndex, start, end));
    }

    @Nullable
    TypeString returnTypeString() {
        int start;
        int[] boundaries = this.descriptorBoundaries();
        int returnIndex = boundaries.length;
        int n = start = returnIndex == 0 ? 3 : boundaries[returnIndex - 1] + 1;
        if (this.descriptor.charAt(start - 1) != 'L') {
            return null;
        }
        int end = this.descriptor.length() - 1;
        return new TypeString(this.descriptor, start, end, this.getHash(returnIndex, start, end));
    }

    private int getHash(int typeStringIndex, int start, int end) {
        int hash;
        if (this.typeStringHashes == null) {
            this.typeStringHashes = new int[this.descriptorBoundaries.length + 1];
        }
        if ((hash = this.typeStringHashes[typeStringIndex]) == 0) {
            this.typeStringHashes[typeStringIndex] = hash = TypeString.computeHash(this.descriptor, start, end);
        }
        return hash;
    }

    int[] descriptorBoundaries() {
        if (this.descriptorBoundaries == null) {
            this.descriptorBoundaries = MethodOutline.parseBoundaries(this.descriptor);
        }
        return this.descriptorBoundaries;
    }

    private static int[] parseBoundaries(String descriptor) {
        char c = descriptor.charAt(1);
        if (c == ')') {
            return NO_BOUNDARIES;
        }
        BitSet partition = new BitSet();
        try {
            int i = 1;
            while (true) {
                if (c == '[') {
                    c = descriptor.charAt(++i);
                    continue;
                }
                if (c == 'L' && (i = descriptor.indexOf(59, i + 2)) < 0) break;
                if ((c = descriptor.charAt(++i)) == ')') {
                    partition.set(++i);
                    break;
                }
                partition.set(i);
            }
        }
        catch (IndexOutOfBoundsException i) {
            // empty catch block
        }
        int[] boundaries = new int[partition.cardinality()];
        int p = 0;
        int len = boundaries.length;
        for (int i = 0; i < len; ++i) {
            p = partition.nextSetBit(p);
            boundaries[i] = p++;
        }
        return boundaries;
    }
}

