/*
 * Decompiled with CFR 0.152.
 */
package datadog.instrument.classmatch;

import datadog.instrument.classmatch.AccessMatcher;
import datadog.instrument.classmatch.FieldOutline;
import datadog.instrument.classmatch.InternalMatchers;
import datadog.instrument.classmatch.TypeMatcher;
import datadog.instrument.classmatch.TypeString;
import java.util.function.Predicate;

@FunctionalInterface
public interface FieldMatcher
extends Predicate<FieldOutline> {
    public static FieldMatcher field(String name) {
        return f -> name.equals(f.fieldName);
    }

    public static FieldMatcher field(Predicate<String> nameMatcher) {
        return f -> nameMatcher.test(f.fieldName);
    }

    default public FieldMatcher access(AccessMatcher accessMatcher) {
        return f -> this.test(f) && accessMatcher.test(f.access);
    }

    default public FieldMatcher type(String type) {
        String descriptor = InternalMatchers.descriptor(type);
        return f -> this.test(f) && descriptor.equals(f.descriptor);
    }

    default public FieldMatcher type(Class<?> type) {
        String descriptor = InternalMatchers.descriptor(type);
        return f -> this.test(f) && descriptor.equals(f.descriptor);
    }

    default public FieldMatcher and(TypeMatcher typeMatcher) {
        return f -> {
            if (!this.test(f)) {
                return false;
            }
            TypeString fieldType = f.typeString();
            return fieldType != null && typeMatcher.test(fieldType);
        };
    }

    default public FieldMatcher and(FieldMatcher other) {
        return f -> this.test(f) && other.test(f);
    }

    default public FieldMatcher or(FieldMatcher other) {
        return f -> this.test(f) || other.test(f);
    }
}

