/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.util.json;

import java.util.Arrays;

public class PathCursor {
    private final Object[] path;
    private int length;

    public PathCursor(int capacity) {
        this.path = new Object[capacity];
        this.length = 0;
    }

    public PathCursor(Object[] path, int capacity) {
        assert (path.length <= capacity);
        this.path = new Object[capacity];
        System.arraycopy(path, 0, this.path, 0, path.length);
        this.length = path.length;
    }

    private PathCursor(PathCursor that) {
        this.path = Arrays.copyOf(that.path, that.path.length);
        this.length = that.length;
    }

    public PathCursor push(String name) {
        assert (this.length < this.path.length);
        this.path[this.length] = name;
        ++this.length;
        return this;
    }

    public PathCursor push(int index) {
        assert (this.length < this.path.length);
        this.path[this.length] = index;
        ++this.length;
        return this;
    }

    public void pop() {
        if (this.length > 0) {
            --this.length;
        }
    }

    public void advance() {
        if (this.length > 0) {
            Object last = this.path[this.length - 1];
            if (last instanceof Integer) {
                this.path[this.length - 1] = (Integer)last + 1;
            } else {
                --this.length;
            }
        }
    }

    public PathCursor copy() {
        return new PathCursor(this);
    }

    public int length() {
        return this.length;
    }

    Object get(int i) {
        return this.path[i];
    }

    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder(prefix);
        for (int i = 0; i < this.length; ++i) {
            sb.append('.');
            sb.append(String.valueOf(this.path[i]).replace(".", "\\."));
        }
        return sb.toString();
    }

    public Object[] toPath() {
        return Arrays.copyOf(this.path, this.length);
    }
}

