/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.baggage;

import datadog.trace.bootstrap.instrumentation.api.Baggage;
import datadog.trace.bootstrap.otel.api.baggage.BaggageBuilder;
import datadog.trace.bootstrap.otel.api.baggage.BaggageEntry;
import datadog.trace.bootstrap.otel.api.baggage.BaggageEntryMetadata;
import datadog.trace.bootstrap.otel.shim.baggage.OtelBaggageBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class OtelBaggage
implements datadog.trace.bootstrap.otel.api.baggage.Baggage {
    private final Baggage delegate;

    public OtelBaggage(Baggage delegate) {
        this.delegate = delegate;
    }

    public OtelBaggage(Map<String, String> items) {
        this(Baggage.create(items));
    }

    @Override
    public int size() {
        return this.delegate.asMap().size();
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super BaggageEntry> consumer) {
        for (Map.Entry<String, String> entry : this.delegate.asMap().entrySet()) {
            consumer.accept(entry.getKey(), new ValueOnly(entry));
        }
    }

    @Override
    public Map<String, BaggageEntry> asMap() {
        return this.delegate.asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, ValueOnly::new));
    }

    @Override
    @Nullable
    public String getEntryValue(String key) {
        return this.delegate.asMap().get(key);
    }

    @Nullable
    public BaggageEntry getEntry(String key) {
        String value = this.getEntryValue(key);
        return value != null ? new ValueOnly(value) : null;
    }

    @Override
    public BaggageBuilder toBuilder() {
        return new OtelBaggageBuilder(this.delegate.asMap());
    }

    public Baggage asAgentBaggage() {
        return this.delegate;
    }

    static class ValueOnly
    implements BaggageEntry {
        private final String value;

        ValueOnly(String value) {
            this.value = value;
        }

        ValueOnly(Map.Entry<String, String> entry) {
            this(entry.getValue());
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public BaggageEntryMetadata getMetadata() {
            return BaggageEntryMetadata.empty();
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public final boolean equals(Object o) {
            return o instanceof ValueOnly && Objects.equals(this.value, ((ValueOnly)o).value);
        }
    }
}

