/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.debugger;

public class DebuggerConfigUpdate {
    private final Boolean dynamicInstrumentationEnabled;
    private final Boolean exceptionReplayEnabled;
    private final Boolean codeOriginEnabled;
    private final Boolean distributedDebuggerEnabled;

    public DebuggerConfigUpdate() {
        this(null, null, null, null);
    }

    public DebuggerConfigUpdate(Boolean dynamicInstrumentationEnabled, Boolean exceptionReplayEnabled, Boolean codeOriginEnabled, Boolean distributedDebuggerEnabled) {
        this.dynamicInstrumentationEnabled = dynamicInstrumentationEnabled;
        this.exceptionReplayEnabled = exceptionReplayEnabled;
        this.codeOriginEnabled = codeOriginEnabled;
        this.distributedDebuggerEnabled = distributedDebuggerEnabled;
    }

    public Boolean getDynamicInstrumentationEnabled() {
        return this.dynamicInstrumentationEnabled;
    }

    public Boolean getExceptionReplayEnabled() {
        return this.exceptionReplayEnabled;
    }

    public Boolean getCodeOriginEnabled() {
        return this.codeOriginEnabled;
    }

    public Boolean getDistributedDebuggerEnabled() {
        return this.distributedDebuggerEnabled;
    }

    public String toString() {
        return "DebuggerConfigUpdate{dynamicInstrumentationEnabled=" + this.dynamicInstrumentationEnabled + ", exceptionReplayEnabled=" + this.exceptionReplayEnabled + ", codeOriginEnabled=" + this.codeOriginEnabled + ", distributedDebuggerEnabled=" + this.distributedDebuggerEnabled + '}';
    }

    public boolean hasUpdates() {
        return this.dynamicInstrumentationEnabled != null || this.exceptionReplayEnabled != null || this.codeOriginEnabled != null || this.distributedDebuggerEnabled != null;
    }

    public static DebuggerConfigUpdate coalesce(DebuggerConfigUpdate existing, DebuggerConfigUpdate update) {
        if (existing == null) {
            return update;
        }
        return new DebuggerConfigUpdate(DebuggerConfigUpdate.coalesceSetting(existing.dynamicInstrumentationEnabled, update.dynamicInstrumentationEnabled), DebuggerConfigUpdate.coalesceSetting(existing.exceptionReplayEnabled, update.exceptionReplayEnabled), DebuggerConfigUpdate.coalesceSetting(existing.codeOriginEnabled, update.codeOriginEnabled), DebuggerConfigUpdate.coalesceSetting(existing.distributedDebuggerEnabled, update.distributedDebuggerEnabled));
    }

    private static Boolean coalesceSetting(Boolean existing, Boolean update) {
        return update != null ? update : existing;
    }
}

