/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.civisibility;

import datadog.trace.api.civisibility.domain.TestContext;
import datadog.trace.api.gateway.RequestContext;
import datadog.trace.api.gateway.RequestContextSlot;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;

public abstract class InstrumentationTestBridge {
    private static final CopyOnWriteArrayList<TestListener> TEST_LISTENERS = new CopyOnWriteArrayList();

    private InstrumentationTestBridge() {
    }

    @Nullable
    public static TestContext getCurrentTestContext() {
        AgentSpan span = AgentTracer.activeSpan();
        if (span == null) {
            return null;
        }
        RequestContext requestContext = span.getRequestContext();
        if (requestContext == null) {
            return null;
        }
        return (TestContext)requestContext.getData(RequestContextSlot.CI_VISIBILITY);
    }

    public static void fireBeforeTestEnd(TestContext testContext) {
        for (TestListener testListener : TEST_LISTENERS) {
            testListener.beforeTestEnd(testContext);
        }
    }

    public static void registerListener(TestListener listener) {
        TEST_LISTENERS.addIfAbsent(listener);
    }

    public static interface TestListener {
        public void beforeTestEnd(TestContext var1);
    }
}

