/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.aiguard;

import datadog.trace.api.aiguard.Evaluator;
import datadog.trace.api.aiguard.noop.NoOpEvaluator;
import java.util.Arrays;
import java.util.List;

public abstract class AIGuard {
    protected static Evaluator EVALUATOR = new NoOpEvaluator();

    protected AIGuard() {
    }

    public static Evaluation evaluate(List<Message> messages) {
        return AIGuard.evaluate(messages, Options.DEFAULT);
    }

    public static Evaluation evaluate(List<Message> messages, Options options) {
        return EVALUATOR.evaluate(messages, options);
    }

    public static final class Options {
        public static final Options DEFAULT = new Options().block(false);
        private boolean block;

        public boolean block() {
            return this.block;
        }

        public Options block(boolean block) {
            this.block = block;
            return this;
        }
    }

    public static class Evaluation {
        final Action action;
        final String reason;
        final List<String> tags;

        public Evaluation(Action action, String reason, List<String> tags) {
            this.action = action;
            this.reason = reason;
            this.tags = tags;
        }

        public Action getAction() {
            return this.action;
        }

        public String getReason() {
            return this.reason;
        }

        public List<String> getTags() {
            return this.tags;
        }
    }

    public static class ToolCall {
        private final String id;
        private final Function function;

        public ToolCall(String id, Function function) {
            this.id = id;
            this.function = function;
        }

        public String getId() {
            return this.id;
        }

        public Function getFunction() {
            return this.function;
        }

        public static ToolCall toolCall(String id, String name, String arguments) {
            return new ToolCall(id, new Function(name, arguments));
        }

        public static class Function {
            private final String name;
            private final String arguments;

            public Function(String name, String arguments) {
                this.name = name;
                this.arguments = arguments;
            }

            public String getName() {
                return this.name;
            }

            public String getArguments() {
                return this.arguments;
            }
        }
    }

    public static class Message {
        private final String role;
        private final String content;
        private final List<ToolCall> toolCalls;
        private final String toolCallId;

        public Message(String role, String content, List<ToolCall> toolCalls, String toolCallId) {
            this.role = role;
            this.content = content;
            this.toolCalls = toolCalls;
            this.toolCallId = toolCallId;
        }

        public String getRole() {
            return this.role;
        }

        public String getContent() {
            return this.content;
        }

        public List<ToolCall> getToolCalls() {
            return this.toolCalls;
        }

        public String getToolCallId() {
            return this.toolCallId;
        }

        public static Message message(String role, String content) {
            return new Message(role, content, null, null);
        }

        public static Message tool(String toolCallId, String content) {
            return new Message("tool", content, null, toolCallId);
        }

        public static Message assistant(ToolCall ... toolCalls) {
            return new Message("assistant", null, Arrays.asList(toolCalls), null);
        }
    }

    public static enum Action {
        ALLOW,
        DENY,
        ABORT;

    }

    public static class AIGuardClientError
    extends RuntimeException {
        private final Object errors;

        public AIGuardClientError(String message, Throwable cause) {
            super(message, cause);
            this.errors = null;
        }

        public AIGuardClientError(String message, Object errors) {
            super(message, null);
            this.errors = errors;
        }

        public Object getErrors() {
            return this.errors;
        }
    }

    public static class AIGuardAbortError
    extends RuntimeException {
        private final Action action;
        private final String reason;
        private final List<String> tags;

        public AIGuardAbortError(Action action, String reason, List<String> tags) {
            super(reason);
            this.action = action;
            this.reason = reason;
            this.tags = tags;
        }

        public Action getAction() {
            return this.action;
        }

        public String getReason() {
            return this.reason;
        }

        public List<String> getTags() {
            return this.tags;
        }
    }
}

