/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger;

import datadog.trace.util.RandomUtils;

public class ProbeId {
    private static final String ID_SEPARATOR = ":";
    private final String id;
    private final int version;
    private final String encoded;

    public static ProbeId from(String encodedId) {
        int idx = encodedId.indexOf(ID_SEPARATOR);
        if (idx == -1) {
            throw new IllegalArgumentException("Invalid probe id: " + encodedId);
        }
        return new ProbeId(encodedId.substring(0, idx), Integer.parseInt(encodedId.substring(idx + 1)), encodedId);
    }

    public ProbeId(String id, int version) {
        this.id = id;
        this.version = version;
        this.encoded = id + ID_SEPARATOR + version;
    }

    private ProbeId(String id, int version, String encoded) {
        this.id = id;
        this.version = version;
        this.encoded = encoded;
    }

    public static ProbeId newId() {
        return new ProbeId(RandomUtils.randomUUID().toString(), 0);
    }

    public String getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public String getEncodedId() {
        return this.encoded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProbeId probeId = (ProbeId)o;
        if (this.version != probeId.version) {
            return false;
        }
        return this.id.equals(probeId.id);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.version;
        return result;
    }

    public String toString() {
        return "ProbeId{id='" + this.id + '\'' + ", version=" + this.version + '}';
    }
}

