/*
 * Decompiled with CFR 0.152.
 */
package datadog.instrument.classmatch;

import datadog.instrument.classmatch.AccessMatcher;
import datadog.instrument.classmatch.ClassOutline;
import datadog.instrument.classmatch.FieldMatcher;
import datadog.instrument.classmatch.InternalMatchers;
import datadog.instrument.classmatch.MethodMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;

@FunctionalInterface
public interface ClassMatcher
extends Predicate<ClassOutline> {
    public static ClassMatcher declares(FieldMatcher fieldMatcher) {
        return c -> InternalMatchers.anyMatch(c.fields, fieldMatcher);
    }

    public static ClassMatcher declares(AccessMatcher accessMatcher, FieldMatcher fieldMatcher) {
        FieldMatcher combinedMatcher = fieldMatcher.access(accessMatcher);
        return c -> InternalMatchers.anyMatch(c.fields, combinedMatcher);
    }

    public static ClassMatcher declares(MethodMatcher methodMatcher) {
        return c -> InternalMatchers.anyMatch(c.methods, methodMatcher);
    }

    public static ClassMatcher declares(AccessMatcher accessMatcher, MethodMatcher methodMatcher) {
        MethodMatcher combinedMatcher = methodMatcher.access(accessMatcher);
        return c -> InternalMatchers.anyMatch(c.methods, combinedMatcher);
    }

    public static ClassMatcher annotatedWith(String annotationType) {
        Predicate<String[]> annotationMatcher = InternalMatchers.declaresAnnotation(annotationType);
        return c -> annotationMatcher.test(c.annotations);
    }

    public static ClassMatcher annotatedWith(String ... annotationTypes) {
        return ClassMatcher.annotatedWith(Arrays.asList(annotationTypes));
    }

    public static ClassMatcher annotatedWith(Collection<String> annotationTypes) {
        Predicate<String[]> annotationMatcher = InternalMatchers.declaresAnnotationOneOf(annotationTypes);
        return c -> annotationMatcher.test(c.annotations);
    }

    default public ClassMatcher and(ClassMatcher other) {
        return new InternalMatchers.ClassConjunction(this, other);
    }

    default public ClassMatcher or(ClassMatcher other) {
        return new InternalMatchers.ClassDisjunction(this, other);
    }
}

