/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api;

import datadog.trace.api.DDTraceId;
import datadog.trace.api.EndpointCheckpointer;
import datadog.trace.api.EndpointTracker;
import datadog.trace.api.TraceConfig;
import datadog.trace.api.Tracer;
import datadog.trace.api.datastreams.AgentDataStreamsMonitoring;
import datadog.trace.api.datastreams.NoopDataStreamsMonitoring;
import datadog.trace.api.experimental.DataStreamsCheckpointer;
import datadog.trace.api.gateway.CallbackProvider;
import datadog.trace.api.gateway.RequestContextSlot;
import datadog.trace.api.gateway.SubscriptionService;
import datadog.trace.api.interceptor.TraceInterceptor;
import datadog.trace.api.internal.InternalTracer;
import datadog.trace.api.internal.TraceSegment;
import datadog.trace.api.sampling.SamplingRule;
import datadog.trace.api.scopemanager.ScopeListener;
import datadog.trace.bootstrap.instrumentation.api.AgentHistogram;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentSpanContext;
import datadog.trace.bootstrap.instrumentation.api.AgentSpanLink;
import datadog.trace.bootstrap.instrumentation.api.AgentTraceCollector;
import datadog.trace.bootstrap.instrumentation.api.BlackHoleSpan;
import datadog.trace.bootstrap.instrumentation.api.NoopContinuation;
import datadog.trace.bootstrap.instrumentation.api.NoopScope;
import datadog.trace.bootstrap.instrumentation.api.NoopSpan;
import datadog.trace.bootstrap.instrumentation.api.NoopSpanContext;
import datadog.trace.bootstrap.instrumentation.api.ProfilingContextIntegration;
import datadog.trace.context.TraceScope;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class AgentTracer {
    private static final String DEFAULT_INSTRUMENTATION_NAME = "datadog";
    public static final TracerAPI NOOP_TRACER;
    private static volatile TracerAPI provider;

    @Deprecated
    public static AgentSpan startSpan(CharSequence spanName) {
        return AgentTracer.startSpan(DEFAULT_INSTRUMENTATION_NAME, spanName);
    }

    public static AgentSpan startSpan(String instrumentationName, CharSequence spanName) {
        return AgentTracer.get().startSpan(instrumentationName, spanName);
    }

    @Deprecated
    public static AgentSpan startSpan(CharSequence spanName, long startTimeMicros) {
        return AgentTracer.startSpan(DEFAULT_INSTRUMENTATION_NAME, spanName, startTimeMicros);
    }

    public static AgentSpan startSpan(String instrumentationName, CharSequence spanName, long startTimeMicros) {
        return AgentTracer.get().startSpan(instrumentationName, spanName, startTimeMicros);
    }

    @Deprecated
    public static AgentSpan startSpan(CharSequence spanName, AgentSpanContext parent) {
        return AgentTracer.startSpan(DEFAULT_INSTRUMENTATION_NAME, spanName, parent);
    }

    public static AgentSpan startSpan(String instrumentationName, CharSequence spanName, AgentSpanContext parent) {
        return AgentTracer.get().startSpan(instrumentationName, spanName, parent);
    }

    @Deprecated
    public static AgentSpan startSpan(CharSequence spanName, AgentSpanContext parent, long startTimeMicros) {
        return AgentTracer.startSpan(DEFAULT_INSTRUMENTATION_NAME, spanName, parent, startTimeMicros);
    }

    public static AgentSpan startSpan(String instrumentationName, CharSequence spanName, AgentSpanContext parent, long startTimeMicros) {
        return AgentTracer.get().startSpan(instrumentationName, spanName, parent, startTimeMicros);
    }

    public static AgentScope activateSpan(AgentSpan span) {
        return AgentTracer.get().activateSpan(span);
    }

    @Deprecated
    public static void activateSpanWithoutScope(AgentSpan span) {
        AgentTracer.get().activateSpanWithoutScope(span);
    }

    @Nonnull
    public static AgentScope.Continuation captureActiveSpan() {
        return AgentTracer.get().captureActiveSpan();
    }

    @Nonnull
    public static AgentScope.Continuation captureSpan(AgentSpan span) {
        return AgentTracer.get().captureSpan(span);
    }

    @Deprecated
    public static void checkpointActiveForRollback() {
        AgentTracer.get().checkpointActiveForRollback();
    }

    @Deprecated
    public static void rollbackActiveToCheckpoint() {
        AgentTracer.get().rollbackActiveToCheckpoint();
    }

    @Deprecated
    public static void closeActive() {
        AgentTracer.get().closeActive();
    }

    public static void closePrevious(boolean finishSpan) {
        AgentTracer.get().closePrevious(finishSpan);
    }

    public static AgentScope activateNext(AgentSpan span) {
        return AgentTracer.get().activateNext(span);
    }

    public static TraceConfig traceConfig(AgentSpan span) {
        return null != span ? span.traceConfig() : AgentTracer.traceConfig();
    }

    public static TraceConfig traceConfig() {
        return AgentTracer.get().captureTraceConfig();
    }

    public static AgentSpan activeSpan() {
        return AgentTracer.get().activeSpan();
    }

    public static boolean isAsyncPropagationEnabled() {
        return AgentTracer.get().isAsyncPropagationEnabled();
    }

    public static void setAsyncPropagationEnabled(boolean asyncPropagationEnabled) {
        AgentTracer.get().setAsyncPropagationEnabled(asyncPropagationEnabled);
    }

    public static AgentSpan noopSpan() {
        return NoopSpan.INSTANCE;
    }

    public static AgentSpan blackholeSpan() {
        return AgentTracer.get().blackholeSpan();
    }

    public static AgentSpanContext noopSpanContext() {
        return NoopSpanContext.INSTANCE;
    }

    public static AgentScope noopScope() {
        return NoopScope.INSTANCE;
    }

    public static AgentScope.Continuation noopContinuation() {
        return NoopContinuation.INSTANCE;
    }

    public static boolean isRegistered() {
        return provider != NOOP_TRACER;
    }

    public static synchronized void registerIfAbsent(TracerAPI tracer) {
        if (tracer != null && tracer != NOOP_TRACER) {
            provider = tracer;
        }
    }

    public static synchronized void forceRegister(TracerAPI tracer) {
        provider = tracer;
    }

    public static TracerAPI get() {
        return provider;
    }

    private AgentTracer() {
    }

    static {
        provider = NOOP_TRACER = new NoopTracerAPI();
    }

    public static final class NoopTraceConfig
    implements TraceConfig {
        public static final NoopTraceConfig INSTANCE = new NoopTraceConfig();

        @Override
        public boolean isTraceEnabled() {
            return false;
        }

        @Override
        public boolean isRuntimeMetricsEnabled() {
            return false;
        }

        @Override
        public boolean isLogsInjectionEnabled() {
            return false;
        }

        @Override
        public boolean isDataStreamsEnabled() {
            return false;
        }

        @Override
        public Map<String, String> getServiceMapping() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, String> getRequestHeaderTags() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, String> getResponseHeaderTags() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, String> getBaggageMapping() {
            return Collections.emptyMap();
        }

        @Override
        public Double getTraceSampleRate() {
            return null;
        }

        @Override
        public Map<String, String> getTracingTags() {
            return Collections.emptyMap();
        }

        @Override
        public String getPreferredServiceName() {
            return null;
        }

        @Override
        public List<? extends SamplingRule.SpanSamplingRule> getSpanSamplingRules() {
            return Collections.emptyList();
        }

        @Override
        public List<? extends SamplingRule.TraceSamplingRule> getTraceSamplingRules() {
            return Collections.emptyList();
        }
    }

    public static class NoopAgentHistogram
    implements AgentHistogram {
        public static final NoopAgentHistogram INSTANCE = new NoopAgentHistogram();

        @Override
        public double getCount() {
            return 0.0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void accept(double value) {
        }

        @Override
        public void accept(double value, double count) {
        }

        @Override
        public double getValueAtQuantile(double quantile) {
            return 0.0;
        }

        @Override
        public double getMinValue() {
            return 0.0;
        }

        @Override
        public double getMaxValue() {
            return 0.0;
        }

        @Override
        public void clear() {
        }

        @Override
        public ByteBuffer serialize() {
            return null;
        }
    }

    public static class NoopAgentTraceCollector
    implements AgentTraceCollector {
        public static final NoopAgentTraceCollector INSTANCE = new NoopAgentTraceCollector();

        @Override
        public void registerContinuation(AgentScope.Continuation continuation) {
        }

        @Override
        public void removeContinuation(AgentScope.Continuation continuation) {
        }
    }

    static class NoopTracerAPI
    implements TracerAPI {
        protected NoopTracerAPI() {
        }

        @Override
        public AgentSpan startSpan(String instrumentationName, CharSequence spanName) {
            return NoopSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(String instrumentationName, CharSequence spanName, long startTimeMicros) {
            return NoopSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(String instrumentationName, CharSequence spanName, AgentSpanContext parent) {
            return NoopSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(String instrumentationName, CharSequence spanName, AgentSpanContext parent, long startTimeMicros) {
            return NoopSpan.INSTANCE;
        }

        @Override
        public AgentScope activateSpan(AgentSpan span) {
            return NoopScope.INSTANCE;
        }

        @Override
        public AgentScope activateManualSpan(AgentSpan span) {
            return NoopScope.INSTANCE;
        }

        @Override
        public void activateSpanWithoutScope(AgentSpan span) {
        }

        @Override
        public AgentScope.Continuation captureActiveSpan() {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public AgentScope.Continuation captureSpan(AgentSpan span) {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public boolean isAsyncPropagationEnabled() {
            return false;
        }

        @Override
        public void setAsyncPropagationEnabled(boolean asyncPropagationEnabled) {
        }

        @Override
        public void checkpointActiveForRollback() {
        }

        @Override
        public void rollbackActiveToCheckpoint() {
        }

        @Override
        public void closeActive() {
        }

        @Override
        public void closePrevious(boolean finishSpan) {
        }

        @Override
        public AgentScope activateNext(AgentSpan span) {
            return NoopScope.INSTANCE;
        }

        @Override
        public AgentSpan activeSpan() {
            return NoopSpan.INSTANCE;
        }

        @Override
        public AgentSpan blackholeSpan() {
            return NoopSpan.INSTANCE;
        }

        @Override
        public SpanBuilder buildSpan(String instrumentationName, CharSequence spanName) {
            return null;
        }

        @Override
        public SpanBuilder singleSpanBuilder(String instrumentationName, CharSequence spanName) {
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public void addScopeListener(Runnable afterScopeActivatedCallback, Runnable afterScopeClosedCallback) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void flushMetrics() {
        }

        @Override
        public ProfilingContextIntegration getProfilingContext() {
            return ProfilingContextIntegration.NoOp.INSTANCE;
        }

        @Override
        public TraceSegment getTraceSegment() {
            return null;
        }

        @Override
        public String getTraceId() {
            return null;
        }

        @Override
        public String getSpanId() {
            return null;
        }

        @Override
        public String getTraceId(AgentSpan span) {
            return null;
        }

        @Override
        public String getSpanId(AgentSpan span) {
            return null;
        }

        @Override
        public boolean addTraceInterceptor(TraceInterceptor traceInterceptor) {
            return false;
        }

        @Override
        public TraceScope muteTracing() {
            return NoopScope.INSTANCE;
        }

        @Override
        public DataStreamsCheckpointer getDataStreamsCheckpointer() {
            return this.getDataStreamsMonitoring();
        }

        @Override
        public void addShutdownListener(Runnable listener) {
        }

        @Override
        public void addScopeListener(ScopeListener listener) {
        }

        @Override
        public SubscriptionService getSubscriptionService(RequestContextSlot slot) {
            return SubscriptionService.SubscriptionServiceNoop.INSTANCE;
        }

        @Override
        public CallbackProvider getCallbackProvider(RequestContextSlot slot) {
            return CallbackProvider.CallbackProviderNoop.INSTANCE;
        }

        @Override
        public CallbackProvider getUniversalCallbackProvider() {
            return CallbackProvider.CallbackProviderNoop.INSTANCE;
        }

        @Override
        public void onRootSpanFinished(AgentSpan root, EndpointTracker tracker) {
        }

        @Override
        public EndpointTracker onRootSpanStarted(AgentSpan root) {
            return EndpointTracker.NO_OP;
        }

        @Override
        public AgentSpanContext notifyExtensionStart(Object event) {
            return null;
        }

        @Override
        public void notifyExtensionEnd(AgentSpan span, Object result, boolean isError) {
        }

        @Override
        public AgentDataStreamsMonitoring getDataStreamsMonitoring() {
            return NoopDataStreamsMonitoring.INSTANCE;
        }

        @Override
        public TraceConfig captureTraceConfig() {
            return NoopTraceConfig.INSTANCE;
        }

        @Override
        public AgentHistogram newHistogram(double relativeAccuracy, int maxNumBins) {
            return NoopAgentHistogram.INSTANCE;
        }

        @Override
        public void updatePreferredServiceName(String serviceName) {
        }
    }

    public static interface SpanBuilder {
        public AgentSpan start();

        public SpanBuilder asChildOf(AgentSpanContext var1);

        public SpanBuilder ignoreActiveSpan();

        public SpanBuilder withTag(String var1, String var2);

        public SpanBuilder withTag(String var1, boolean var2);

        public SpanBuilder withTag(String var1, Number var2);

        public SpanBuilder withTag(String var1, Object var2);

        public SpanBuilder withStartTimestamp(long var1);

        public SpanBuilder withServiceName(String var1);

        public SpanBuilder withResourceName(String var1);

        public SpanBuilder withErrorFlag();

        public SpanBuilder withSpanType(CharSequence var1);

        public <T> SpanBuilder withRequestContextData(RequestContextSlot var1, T var2);

        public SpanBuilder withLink(AgentSpanLink var1);

        public SpanBuilder withSpanId(long var1);
    }

    public static interface TracerAPI
    extends Tracer,
    InternalTracer,
    EndpointCheckpointer {
        public AgentSpan startSpan(String var1, CharSequence var2);

        public AgentSpan startSpan(String var1, CharSequence var2, long var3);

        public AgentSpan startSpan(String var1, CharSequence var2, AgentSpanContext var3);

        public AgentSpan startSpan(String var1, CharSequence var2, AgentSpanContext var3, long var4);

        public AgentScope activateSpan(AgentSpan var1);

        public AgentScope activateManualSpan(AgentSpan var1);

        public void activateSpanWithoutScope(AgentSpan var1);

        @Override
        public AgentScope.Continuation captureActiveSpan();

        public AgentScope.Continuation captureSpan(AgentSpan var1);

        public void checkpointActiveForRollback();

        public void rollbackActiveToCheckpoint();

        public void closeActive();

        public void closePrevious(boolean var1);

        public AgentScope activateNext(AgentSpan var1);

        public AgentSpan activeSpan();

        default public AgentSpan blackholeSpan() {
            AgentSpan active = this.activeSpan();
            return new BlackHoleSpan(active != null ? active.getTraceId() : DDTraceId.ZERO);
        }

        @Deprecated
        default public SpanBuilder buildSpan(CharSequence spanName) {
            return this.buildSpan(AgentTracer.DEFAULT_INSTRUMENTATION_NAME, spanName);
        }

        public SpanBuilder buildSpan(String var1, CharSequence var2);

        public SpanBuilder singleSpanBuilder(String var1, CharSequence var2);

        public void close();

        public void addScopeListener(ScopeListener var1);

        public SubscriptionService getSubscriptionService(RequestContextSlot var1);

        public CallbackProvider getCallbackProvider(RequestContextSlot var1);

        public CallbackProvider getUniversalCallbackProvider();

        public AgentSpanContext notifyExtensionStart(Object var1);

        public void notifyExtensionEnd(AgentSpan var1, Object var2, boolean var3);

        public AgentDataStreamsMonitoring getDataStreamsMonitoring();

        public String getTraceId(AgentSpan var1);

        public String getSpanId(AgentSpan var1);

        public TraceConfig captureTraceConfig();

        @Override
        public ProfilingContextIntegration getProfilingContext();

        public AgentHistogram newHistogram(double var1, int var3);

        public void updatePreferredServiceName(String var1);

        public void addShutdownListener(Runnable var1);
    }
}

