/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.environment;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public final class ThreadUtils {
    static final MethodHandle H_IS_VIRTUAL = ThreadUtils.lookupIsVirtual();
    static final MethodHandle H_ID = ThreadUtils.lookupId();

    private ThreadUtils() {
    }

    public static final long threadId(Thread thread) {
        try {
            return H_ID.invoke(thread);
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    public static final boolean supportsVirtualThreads() {
        return H_IS_VIRTUAL != null;
    }

    public static final boolean isCurrentThreadVirtual() {
        try {
            return H_IS_VIRTUAL != null && H_IS_VIRTUAL.invoke(Thread.currentThread());
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static final boolean isVirtual(Thread thread) {
        try {
            return H_IS_VIRTUAL != null && H_IS_VIRTUAL.invoke(thread);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static final MethodHandle lookupIsVirtual() {
        try {
            return MethodHandles.lookup().findVirtual(Thread.class, "isVirtual", MethodType.methodType(Boolean.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    private static final MethodHandle lookupId() {
        MethodHandle threadIdHandle = ThreadUtils.lookupThreadId();
        return threadIdHandle != null ? threadIdHandle : ThreadUtils.lookupGetId();
    }

    private static final MethodHandle lookupThreadId() {
        try {
            return MethodHandles.lookup().findVirtual(Thread.class, "threadId", MethodType.methodType(Long.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    private static final MethodHandle lookupGetId() {
        try {
            return MethodHandles.lookup().findVirtual(Thread.class, "getId", MethodType.methodType(Long.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }
}

