/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.config.provider;

import datadog.environment.SystemProperties;
import datadog.trace.bootstrap.config.provider.ConfigConverter;
import datadog.trace.config.inversion.ConfigHelper;
import datadog.trace.util.ConfigStrings;
import java.util.Map;

public class AgentArgsInjector {
    public static void injectAgentArgsConfig(String agentArgs) {
        Map<String, String> args = ConfigConverter.parseMap(agentArgs, "javaagent arguments", '=');
        AgentArgsInjector.injectAgentArgsConfig(args);
    }

    public static void injectAgentArgsConfig(Map<String, String> args) {
        if (args == null) {
            return;
        }
        for (Map.Entry<String, String> e : args.entrySet()) {
            String envVarName;
            String envVarValue;
            String propertyName = e.getKey();
            String existingPropertyValue = SystemProperties.get(propertyName);
            if (existingPropertyValue != null || (envVarValue = ConfigHelper.env(envVarName = ConfigStrings.toEnvVar(propertyName))) != null) continue;
            String propertyValue = e.getValue();
            System.setProperty(propertyName, propertyValue);
        }
    }
}

