/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.environment.EnvironmentVariables;
import datadog.environment.SystemProperties;
import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.api.env.CapturedEnvironment;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.util.TraceUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProcessTags {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessTags.class);
    private static boolean enabled = Config.get().isExperimentalPropagateProcessTagsEnabled();
    public static final String CLUSTER_NAME = "cluster.name";
    public static final String SERVER_NAME = "server.name";
    public static final String SERVER_TYPE = "server.type";
    public static final String ENTRYPOINT_NAME = "entrypoint.name";
    public static final String ENTRYPOINT_BASEDIR = "entrypoint.basedir";
    public static final String ENTRYPOINT_WORKDIR = "entrypoint.workdir";
    static Function<String, String> envGetter = EnvironmentVariables::get;

    private ProcessTags() {
    }

    public static boolean isEnabled() {
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTag(String key, String value) {
        if (enabled) {
            SortedMap<String, String> sortedMap = Lazy.TAGS;
            synchronized (sortedMap) {
                Lazy.TAGS.put(key, value);
                Lazy.serializedForm = null;
                Lazy.stringListForm = null;
                Lazy.utf8ListForm = null;
            }
        }
    }

    public static List<UTF8BytesString> getTagsAsUTF8ByteStringList() {
        if (!enabled) {
            return null;
        }
        List<UTF8BytesString> listForm = Lazy.utf8ListForm;
        if (listForm != null) {
            return listForm;
        }
        Lazy.calculate();
        return Lazy.utf8ListForm;
    }

    public static List<String> getTagsAsStringList() {
        if (!enabled) {
            return null;
        }
        List<String> listForm = Lazy.stringListForm;
        if (listForm != null) {
            return listForm;
        }
        Lazy.calculate();
        return Lazy.stringListForm;
    }

    public static UTF8BytesString getTagsForSerialization() {
        if (!enabled) {
            return null;
        }
        UTF8BytesString serializedForm = Lazy.serializedForm;
        if (serializedForm != null) {
            return serializedForm;
        }
        Lazy.calculate();
        return Lazy.serializedForm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void empty() {
        SortedMap<String, String> sortedMap = Lazy.TAGS;
        synchronized (sortedMap) {
            Lazy.TAGS.clear();
            Lazy.serializedForm = null;
            Lazy.stringListForm = null;
            Lazy.utf8ListForm = null;
        }
    }

    static void reset() {
        ProcessTags.reset(Config.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset(Config config) {
        SortedMap<String, String> sortedMap = Lazy.TAGS;
        synchronized (sortedMap) {
            ProcessTags.empty();
            enabled = config.isExperimentalPropagateProcessTagsEnabled();
            Lazy.TAGS.putAll(Lazy.loadTags());
        }
    }

    private static class Lazy {
        static final SortedMap<String, String> TAGS = Lazy.loadTags();
        static volatile UTF8BytesString serializedForm;
        static volatile List<UTF8BytesString> utf8ListForm;
        static volatile List<String> stringListForm;

        private Lazy() {
        }

        private static SortedMap<String, String> loadTags() {
            TreeMap<String, String> tags = new TreeMap<String, String>();
            if (enabled) {
                try {
                    Lazy.fillBaseTags(tags);
                    Lazy.fillJeeTags(tags);
                }
                catch (Throwable t) {
                    LOGGER.debug("Unable to calculate default process tags", t);
                }
            }
            return tags;
        }

        private static void fillJeeTags(SortedMap<String, String> tags) {
            if (Lazy.fillJbossTags(tags)) {
                return;
            }
            Lazy.fillWebsphereTags(tags);
        }

        private static void insertTagFromSysPropIfPresent(Map<String, String> tags, String propKey, String tagKey) {
            String value = SystemProperties.get(propKey);
            if (value != null) {
                tags.put(tagKey, value);
            }
        }

        private static boolean insertTagFromEnvIfPresent(Map<String, String> tags, String envKey, String tagKey) {
            try {
                String value = envGetter.apply(envKey);
                if (value != null) {
                    tags.put(tagKey, value);
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }

        private static boolean insertLastPathSegmentIfPresent(Map<String, String> tags, String path, String tagKey) {
            if (path == null || path.isEmpty()) {
                return false;
            }
            try {
                Path p = Paths.get(path, new String[0]).getFileName();
                if (p != null) {
                    tags.put(tagKey, p.toString());
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }

        private static boolean hasSystemProperty(String propKey) {
            return SystemProperties.get(propKey) != null;
        }

        private static void fillBaseTags(Map<String, String> tags) {
            CapturedEnvironment.ProcessInfo processInfo = CapturedEnvironment.get().getProcessInfo();
            if (processInfo.mainClass != null) {
                tags.put(ProcessTags.ENTRYPOINT_NAME, processInfo.mainClass);
                tags.put("entrypoint.type", "class");
            }
            if (processInfo.jarFile != null) {
                String jarName = processInfo.jarFile.getName();
                tags.put(ProcessTags.ENTRYPOINT_NAME, jarName.substring(0, jarName.length() - 4));
                tags.put("entrypoint.type", "jar");
                Lazy.insertLastPathSegmentIfPresent(tags, processInfo.jarFile.getParent(), ProcessTags.ENTRYPOINT_BASEDIR);
            }
            Lazy.insertLastPathSegmentIfPresent(tags, SystemProperties.get("user.dir"), ProcessTags.ENTRYPOINT_WORKDIR);
        }

        private static boolean fillJbossTags(Map<String, String> tags) {
            if (Lazy.insertLastPathSegmentIfPresent(tags, SystemProperties.get("jboss.home.dir"), "jboss.home")) {
                Lazy.insertTagFromSysPropIfPresent(tags, "jboss.server.name", ProcessTags.SERVER_NAME);
                tags.put("jboss.mode", Lazy.hasSystemProperty("[Standalone]") ? "standalone" : "domain");
                tags.put(ProcessTags.SERVER_TYPE, "jboss");
                return true;
            }
            return false;
        }

        private static boolean fillWebsphereTags(Map<String, String> tags) {
            if (Lazy.insertTagFromEnvIfPresent(tags, "WAS_CELL", ProcessTags.CLUSTER_NAME)) {
                Lazy.insertTagFromEnvIfPresent(tags, "SERVER_NAME", ProcessTags.SERVER_NAME);
                tags.put(ProcessTags.SERVER_TYPE, "websphere");
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void calculate() {
            if (serializedForm != null || TAGS.isEmpty()) {
                return;
            }
            SortedMap<String, String> sortedMap = TAGS;
            synchronized (sortedMap) {
                Stream<UTF8BytesString> tagStream = TAGS.entrySet().stream().map(entry -> UTF8BytesString.create((String)entry.getKey() + ":" + TraceUtils.normalizeTagValue((String)entry.getValue())));
                utf8ListForm = Collections.unmodifiableList(tagStream.collect(Collectors.toList()));
                stringListForm = Collections.unmodifiableList(utf8ListForm.stream().map(UTF8BytesString::toString).collect(Collectors.toList()));
                serializedForm = UTF8BytesString.create(String.join((CharSequence)",", utf8ListForm));
            }
        }
    }
}

