/*
 * Decompiled with CFR 0.152.
 */
package datadog.instrument.utils;

import java.nio.charset.StandardCharsets;
import java.util.List;

public final class Glue {
    private Glue() {
    }

    public static void classHeader(List<String> lines, String className) {
        lines.add("package datadog.instrument.glue;");
        lines.add("");
        lines.add("/** Generated by " + className + "Generator - DO NOT EDIT! */");
        lines.add("public interface " + className + " {");
    }

    public static void packBytecode(List<String> lines, byte[] bytecode) {
        if ((bytecode.length & 1) == 1) {
            throw new IllegalStateException("Bytecode length is not even; requires padding");
        }
        StringBuilder buf = new StringBuilder("      \"");
        for (int i = 0; i < bytecode.length; i += 2) {
            char c;
            if (buf.length() > 120) {
                lines.add(buf + "\"");
                buf.setLength(0);
                buf.append("          + \"");
            }
            if ((c = (char)(bytecode[i] << 8 | 0xFF & bytecode[i + 1])) <= '\u00ff') {
                buf.append(String.format("\\%03o", c));
                continue;
            }
            buf.append(String.format("\\u%04x", c));
        }
        lines.add(buf + "\";");
    }

    public static byte[] unpackBytecode(String bytecode) {
        return bytecode.getBytes(StandardCharsets.UTF_16BE);
    }
}

