/*
 * Decompiled with CFR 0.152.
 */
package datadog.instrument.classmatch;

import datadog.instrument.classmatch.InternalMatchers;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class InternalNames
extends AbstractSet<String> {
    private static final int MAX_HASH_ATTEMPTS = 3;
    private final String[] table;
    private final int slotMask;

    InternalNames(Collection<String> types) {
        int tableSize = Integer.max(8, types.size() * 4 / 3) - 1;
        int slotMask = -1 >>> Integer.numberOfLeadingZeros(tableSize);
        String[] table = new String[slotMask + 1];
        Iterator<String> itr = types.iterator();
        while (itr.hasNext()) {
            if (InternalNames.add(table, slotMask, InternalMatchers.internalName(itr.next()))) continue;
            slotMask = (slotMask << 1) + 1;
            table = new String[slotMask + 1];
            itr = types.iterator();
        }
        this.table = table;
        this.slotMask = slotMask;
    }

    public boolean containsType(CharSequence internalName) {
        String[] table = this.table;
        int slotMask = this.slotMask;
        int i = 1;
        int h = internalName.hashCode();
        while (true) {
            block6: {
                block5: {
                    String existing;
                    if ((existing = table[slotMask & h]) == null) break block5;
                    if (existing.contentEquals(internalName)) {
                        return true;
                    }
                    if (i < 3) break block6;
                }
                return false;
            }
            ++i;
            h = InternalNames.rehash(h);
        }
    }

    private static boolean add(String[] table, int slotMask, String internalName) {
        int i = 1;
        int h = internalName.hashCode();
        while (true) {
            int slot;
            String existing;
            if ((existing = table[slot = slotMask & h]) == null || existing.equals(internalName)) {
                table[slot] = internalName;
                return true;
            }
            if (i >= 3) {
                return false;
            }
            ++i;
            h = InternalNames.rehash(h);
        }
    }

    private static int rehash(int oldHash) {
        return Integer.reverseBytes(oldHash * -1640532531) * -1640532531;
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof CharSequence && this.containsType((CharSequence)o);
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                while (this.i < InternalNames.this.table.length) {
                    if (InternalNames.this.table[this.i] != null) {
                        return true;
                    }
                    ++this.i;
                }
                return false;
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    return InternalNames.this.table[this.i++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public int size() {
        int size = 0;
        for (String s : this.table) {
            if (s == null) continue;
            ++size;
        }
        return size;
    }
}

