/*
 * Decompiled with CFR 0.152.
 */
package datadog.instrument.classmatch;

import datadog.instrument.classmatch.TypeString;
import javax.annotation.Nullable;

public final class FieldOutline {
    public final int access;
    public final String fieldName;
    public final String descriptor;
    private int typeStringHash;

    FieldOutline(int access, String fieldName, String descriptor) {
        this.access = access;
        this.fieldName = fieldName;
        this.descriptor = descriptor;
    }

    @Nullable
    TypeString typeString() {
        if (this.descriptor.charAt(0) != 'L') {
            return null;
        }
        int start = 1;
        int end = this.descriptor.length() - 1;
        if (this.typeStringHash == 0) {
            this.typeStringHash = TypeString.computeHash(this.descriptor, start, end);
        }
        return new TypeString(this.descriptor, start, end, this.typeStringHash);
    }
}

