/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.logging.simplelogger;

import datadog.trace.logging.LogLevel;
import datadog.trace.logging.LogReporter;
import datadog.trace.logging.PrintStreamWrapper;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class SLCompatSettings {
    private final Properties properties;
    private final Properties fileProperties;
    final String warnLevelString;
    final boolean levelInBrackets;
    final PrintStream printStream;
    final boolean showShortLogName;
    final boolean showLogName;
    final boolean showThreadName;
    final DTFormatter dateTimeFormatter;
    final boolean showDateTime;
    final boolean jsonEnabled;
    final LogLevel defaultLogLevel;
    final boolean embedException;

    @SuppressForbidden
    static PrintStream getPrintStream(String logFile) {
        PrintStreamWrapper printStreamWrapper;
        switch (logFile.toLowerCase(Locale.ROOT)) {
            case "system.err": {
                printStreamWrapper = new PrintStreamWrapper(System.err);
                break;
            }
            case "system.out": {
                printStreamWrapper = new PrintStreamWrapper(System.out);
                break;
            }
            default: {
                FileOutputStream outputStream = null;
                try {
                    File outputFile = new File(logFile);
                    File parentFile = outputFile.getParentFile();
                    if (parentFile != null) {
                        parentFile.mkdirs();
                    }
                    outputStream = new FileOutputStream(outputFile);
                    PrintStream printStream = new PrintStream(outputStream, true);
                    LogReporter.register(outputFile);
                    return printStream;
                }
                catch (IOException | SecurityException e) {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    printStreamWrapper = new PrintStreamWrapper(System.err);
                }
            }
        }
        LogReporter.register(printStreamWrapper);
        return printStreamWrapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Properties loadProperties(String fileName) {
        try (InputStream inputStream = AccessController.doPrivileged(new ResourceStreamPrivilegedAction(fileName));){
            if (inputStream == null) return null;
            Properties properties2 = new Properties();
            properties2.load(inputStream);
            Properties properties = properties2;
            return properties;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String getString(Properties properties, Properties fallbackProperties, String name) {
        String property;
        String string = property = properties == null ? null : properties.getProperty(name);
        if (property == null) {
            property = fallbackProperties == null ? null : fallbackProperties.getProperty(name);
        }
        return property;
    }

    static String getString(Properties properties, Properties fallbackProperties, String name, String defaultValue) {
        String property = SLCompatSettings.getString(properties, fallbackProperties, name);
        return property == null ? defaultValue : property;
    }

    static boolean getBoolean(Properties properties, Properties fallbackProperties, String name, boolean defaultValue) {
        String property = SLCompatSettings.getString(properties, fallbackProperties, name);
        return property == null ? defaultValue : Boolean.parseBoolean(property);
    }

    public SLCompatSettings(Properties properties) {
        this(properties, SLCompatSettings.loadProperties(properties.getProperty("datadog.slf4j.simpleLogger.configurationFile", "simplelogger.properties")));
    }

    public SLCompatSettings(Properties properties, Properties fileProperties) {
        this(properties, fileProperties, SLCompatSettings.getPrintStream(SLCompatSettings.getString(properties, fileProperties, "datadog.slf4j.simpleLogger.logFile", "System.err")));
    }

    public SLCompatSettings(Properties properties, Properties fileProperties, PrintStream printStream) {
        this(properties, fileProperties, SLCompatSettings.getString(properties, fileProperties, "datadog.slf4j.simpleLogger.warnLevelString"), SLCompatSettings.getBoolean(properties, fileProperties, "datadog.slf4j.simpleLogger.levelInBrackets", false), printStream, SLCompatSettings.getBoolean(properties, fileProperties, "datadog.slf4j.simpleLogger.showShortLogName", false), SLCompatSettings.getBoolean(properties, fileProperties, "datadog.slf4j.simpleLogger.showLogName", true), SLCompatSettings.getBoolean(properties, fileProperties, "datadog.slf4j.simpleLogger.showThreadName", true), DTFormatter.create(SLCompatSettings.getString(properties, fileProperties, "datadog.slf4j.simpleLogger.dateTimeFormat", Defaults.DATE_TIME_FORMAT)), SLCompatSettings.getBoolean(properties, fileProperties, "datadog.slf4j.simpleLogger.showDateTime", false), SLCompatSettings.getBoolean(properties, fileProperties, "datadog.slf4j.simpleLogger.jsonEnabled", false), LogLevel.fromString(SLCompatSettings.getString(properties, fileProperties, "datadog.slf4j.simpleLogger.defaultLogLevel", "INFO")), SLCompatSettings.getBoolean(properties, fileProperties, "datadog.slf4j.simpleLogger.embedException", false));
    }

    public SLCompatSettings(Properties properties, Properties fileProperties, String warnLevelString, boolean levelInBrackets, PrintStream printStream, boolean showShortLogName, boolean showLogName, boolean showThreadName, DTFormatter dateTimeFormatter, boolean showDateTime, boolean jsonEnabled, LogLevel defaultLogLevel, boolean embedException) {
        this.properties = properties;
        this.fileProperties = fileProperties;
        this.warnLevelString = warnLevelString;
        this.levelInBrackets = levelInBrackets;
        this.printStream = printStream;
        this.showShortLogName = showShortLogName;
        this.showLogName = showLogName;
        this.showThreadName = showThreadName;
        this.dateTimeFormatter = dateTimeFormatter;
        this.showDateTime = showDateTime;
        this.jsonEnabled = jsonEnabled;
        this.defaultLogLevel = defaultLogLevel;
        this.embedException = embedException;
    }

    String getString(String name) {
        return SLCompatSettings.getString(this.properties, this.fileProperties, name);
    }

    public LogLevel logLevelForName(String name) {
        String level = null;
        String remainder = name;
        int end = name.length();
        while (level == null && end > -1) {
            remainder = remainder.substring(0, end);
            level = this.getString("datadog.slf4j.simpleLogger.log." + remainder);
            end = remainder.lastIndexOf(46);
        }
        return level != null ? LogLevel.fromString(level) : this.defaultLogLevel;
    }

    public String logNameForName(String name) {
        if (this.showShortLogName) {
            return name.substring(name.lastIndexOf(".") + 1);
        }
        if (this.showLogName) {
            return name;
        }
        return "";
    }

    public Map<String, Object> getSettingsDescription() {
        HashMap<String, Object> settingsDescription = new HashMap<String, Object>();
        settingsDescription.put("warnLevelString", this.warnLevelString != null ? this.warnLevelString : LogLevel.WARN.toString());
        settingsDescription.put("levelInBrackets", this.levelInBrackets);
        settingsDescription.put("logFile", SLCompatSettings.getString(this.properties, this.fileProperties, "datadog.slf4j.simpleLogger.logFile", "System.err"));
        settingsDescription.put("showLogName", this.showLogName);
        settingsDescription.put("showShortLogName", this.showShortLogName);
        settingsDescription.put("showThreadName", this.showThreadName);
        settingsDescription.put("showDateTime", this.showDateTime);
        settingsDescription.put("jsonEnabled", this.jsonEnabled);
        String dateTimeFormat = SLCompatSettings.getString(this.properties, this.fileProperties, "datadog.slf4j.simpleLogger.dateTimeFormat", Defaults.DATE_TIME_FORMAT);
        settingsDescription.put("dateTimeFormat", dateTimeFormat != null ? dateTimeFormat : "relative");
        settingsDescription.put("defaultLogLevel", this.defaultLogLevel.toString());
        settingsDescription.put("embedException", this.embedException);
        settingsDescription.put("configurationFile", this.properties.getProperty("datadog.slf4j.simpleLogger.configurationFile", "simplelogger.properties"));
        return settingsDescription;
    }

    private static final class ResourceStreamPrivilegedAction
    implements PrivilegedAction<InputStream> {
        private final String fileName;

        public ResourceStreamPrivilegedAction(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public InputStream run() {
            ClassLoader threadCL = Thread.currentThread().getContextClassLoader();
            if (threadCL != null) {
                return threadCL.getResourceAsStream(this.fileName);
            }
            return ClassLoader.getSystemResourceAsStream(this.fileName);
        }
    }

    public static class NewDTFormatter
    extends DTFormatter {
        private final Object dateTimeFormatter;
        private final MethodHandle formatTo;
        private final MethodHandle instantOfEpochMilli;
        private final Object zoneId;
        private final MethodHandle zdtOfInstant;

        public NewDTFormatter(String dateTimeFormat) {
            MethodHandles.Lookup l = MethodHandles.publicLookup();
            try {
                ClassLoader cl = ClassLoader.getSystemClassLoader();
                Class<?> fClass = cl.loadClass("java.time.format.DateTimeFormatter");
                Class<?> tClass = cl.loadClass("java.time.temporal.TemporalAccessor");
                Class<?> iClass = cl.loadClass("java.time.Instant");
                Class<?> zdtClass = cl.loadClass("java.time.ZonedDateTime");
                Class<?> zClass = cl.loadClass("java.time.ZoneId");
                this.dateTimeFormatter = l.findStatic(fClass, "ofPattern", MethodType.methodType(fClass, String.class)).invoke(dateTimeFormat);
                this.formatTo = l.findVirtual(fClass, "formatTo", MethodType.methodType(Void.TYPE, tClass, Appendable.class));
                this.instantOfEpochMilli = l.findStatic(iClass, "ofEpochMilli", MethodType.methodType(iClass, Long.TYPE));
                this.zoneId = l.findStatic(zClass, "systemDefault", MethodType.methodType(zClass)).invoke();
                this.zdtOfInstant = l.findStatic(zdtClass, "ofInstant", MethodType.methodType(zdtClass, iClass, zClass));
            }
            catch (Throwable t) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public void appendFormattedDate(StringBuilder builder, long timeMillis, long startTimeMillis) {
            try {
                this.formatTo.invoke(this.dateTimeFormatter, this.zdtOfInstant.invoke(this.instantOfEpochMilli.invoke(timeMillis), this.zoneId), builder);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class LegacyDTFormatter
    extends DTFormatter {
        private final DateFormat dateFormat;

        public LegacyDTFormatter(String dateTimeFormat) {
            this.dateFormat = new SimpleDateFormat(dateTimeFormat);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void appendFormattedDate(StringBuilder builder, long timeMillis, long startTimeMillis) {
            String dateString;
            Date date = new Date(timeMillis);
            DateFormat dateFormat = this.dateFormat;
            synchronized (dateFormat) {
                dateString = this.dateFormat.format(date);
            }
            builder.append(dateString);
        }
    }

    public static class DiffDTFormatter
    extends DTFormatter {
        @Override
        public void appendFormattedDate(StringBuilder builder, long timeMillis, long startTimeMillis) {
            builder.append(timeMillis - startTimeMillis);
        }
    }

    public static abstract class DTFormatter {
        public static DTFormatter create(String dateTimeFormat) {
            if (dateTimeFormat == null) {
                return new DiffDTFormatter();
            }
            try {
                return new NewDTFormatter(dateTimeFormat);
            }
            catch (Throwable t) {
                try {
                    return new LegacyDTFormatter(dateTimeFormat);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return new DiffDTFormatter();
                }
            }
        }

        public abstract void appendFormattedDate(StringBuilder var1, long var2, long var4);
    }

    public static final class Defaults {
        public static final boolean LEVEL_IN_BRACKETS = false;
        public static final String LOG_FILE = "System.err";
        public static final boolean SHOW_SHORT_LOG_NAME = false;
        public static final boolean SHOW_LOG_NAME = true;
        public static final boolean SHOW_THREAD_NAME = true;
        public static final String DATE_TIME_FORMAT = null;
        public static final boolean SHOW_DATE_TIME = false;
        public static final boolean JSON_ENABLED = false;
        public static final String DEFAULT_LOG_LEVEL = "INFO";
        public static final boolean EMBED_EXCEPTION = false;
        public static final String CONFIGURATION_FILE = "simplelogger.properties";
    }

    public static final class Keys {
        private static final String PREFIX = "datadog.slf4j.simpleLogger.";
        public static final String LOG_KEY_PREFIX = "datadog.slf4j.simpleLogger.log.";
        public static final String WARN_LEVEL_STRING = "datadog.slf4j.simpleLogger.warnLevelString";
        public static final String LEVEL_IN_BRACKETS = "datadog.slf4j.simpleLogger.levelInBrackets";
        public static final String LOG_FILE = "datadog.slf4j.simpleLogger.logFile";
        public static final String SHOW_SHORT_LOG_NAME = "datadog.slf4j.simpleLogger.showShortLogName";
        public static final String SHOW_LOG_NAME = "datadog.slf4j.simpleLogger.showLogName";
        public static final String SHOW_THREAD_NAME = "datadog.slf4j.simpleLogger.showThreadName";
        public static final String DATE_TIME_FORMAT = "datadog.slf4j.simpleLogger.dateTimeFormat";
        public static final String SHOW_DATE_TIME = "datadog.slf4j.simpleLogger.showDateTime";
        public static final String JSON_ENABLED = "datadog.slf4j.simpleLogger.jsonEnabled";
        public static final String DEFAULT_LOG_LEVEL = "datadog.slf4j.simpleLogger.defaultLogLevel";
        public static final String EMBED_EXCEPTION = "datadog.slf4j.simpleLogger.embedException";
        static final String CONFIGURATION_FILE = "datadog.slf4j.simpleLogger.configurationFile";
    }

    public static final class Names {
        public static final String WARN_LEVEL_STRING = "warnLevelString";
        public static final String LEVEL_IN_BRACKETS = "levelInBrackets";
        public static final String LOG_FILE = "logFile";
        public static final String SHOW_SHORT_LOG_NAME = "showShortLogName";
        public static final String SHOW_LOG_NAME = "showLogName";
        public static final String SHOW_THREAD_NAME = "showThreadName";
        public static final String DATE_TIME_FORMAT = "dateTimeFormat";
        public static final String SHOW_DATE_TIME = "showDateTime";
        public static final String JSON_ENABLED = "jsonEnabled";
        public static final String DEFAULT_LOG_LEVEL = "defaultLogLevel";
        public static final String EMBED_EXCEPTION = "embedException";
        public static final String CONFIGURATION_FILE = "configurationFile";
    }
}

