/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.context.Context;
import datadog.context.propagation.CarrierSetter;
import datadog.context.propagation.Propagators;
import datadog.trace.api.Config;
import datadog.trace.api.datastreams.DataStreamsContext;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.decorator.ClientDecorator;
import java.net.URI;
import javax.annotation.Nonnull;

public abstract class UriBasedClientDecorator
extends ClientDecorator {
    public void onURI(@Nonnull AgentSpan span, @Nonnull URI uri) {
        String host = uri.getHost();
        int port = uri.getPort();
        if (null != host && !host.isEmpty()) {
            span.setTag("peer.hostname", host);
            if (Config.get().isHttpClientSplitByDomain() && host.charAt(0) >= 'A') {
                span.setServiceName(host);
            }
            if (port > 0) {
                this.setPeerPort(span, port);
            }
        }
    }

    public <C> void injectContext(Context context, C request, CarrierSetter<C> setter) {
        if (DataStreamsContext.fromContext(context) == null && AgentTracer.traceConfig().isDataStreamsEnabled()) {
            context = context.with(DataStreamsContext.forHttpClient());
        }
        Propagators.defaultPropagator().inject(context, request, setter);
    }
}

